/*
 * Decompiled with CFR 0.152.
 */
package wallconnect;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.inventory.item.toolItem.ToolType;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.WallObject;
import net.bytebuddy.asm.Advice;

public class WallObjectPatch {
    public static List<Integer> wallObjIds = new ArrayList<Integer>();

    @ModMethodPatch(target=WallObject.class, name="isConnectedWall", arguments={GameObject.class})
    public static class IsConnectedWallPatch {
        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        static boolean onEnter() {
            return true;
        }

        @Advice.OnMethodExit
        static void onExit(@Advice.This WallObject target, @Advice.Argument(value=0) GameObject object, @Advice.Return(readOnly=false) boolean returnVal) {
            returnVal = object == target || target.connectedWalls.contains(object.getID());
        }
    }

    @ModMethodPatch(target=WallObject.class, name="onObjectRegistryClosed", arguments={})
    public static class OnObjectRegistryClosedPatch {
        @Advice.OnMethodExit
        public static void onExit(@Advice.This WallObject target) {
            target.connectedWalls.addAll(wallObjIds);
        }
    }

    @ModMethodPatch(target=WallObject.class, name="registerWallObjects", arguments={String.class, String.class, String.class, float.class, Color.class, ToolType.class, float.class, float.class, boolean.class, boolean.class})
    public static class RegisterWallObjectsPatch {
        @Advice.OnMethodExit
        public static void onExit(@Advice.Return int[] objIds) {
            wallObjIds.add(objIds[0]);
        }
    }
}

