/*
 * Decompiled with CFR 0.152.
 */
package com.schem;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class Schematic {
    public final int width;
    public final int height;
    public final int[][] tiles;
    public final int[][] objects;

    public Schematic(int width, int height) {
        this.width = width;
        this.height = height;
        this.tiles = new int[height][width];
        this.objects = new int[height][width];
    }

    public void saveToFile(Path file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter bw = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            int x;
            StringBuilder sb;
            bw.write(this.width + ";" + this.height);
            bw.newLine();
            int y = 0;
            while (y < this.height) {
                sb = new StringBuilder();
                x = 0;
                while (x < this.width) {
                    if (x > 0) {
                        sb.append(';');
                    }
                    sb.append(this.tiles[y][x]);
                    ++x;
                }
                bw.write(sb.toString());
                bw.newLine();
                ++y;
            }
            y = 0;
            while (y < this.height) {
                sb = new StringBuilder();
                x = 0;
                while (x < this.width) {
                    if (x > 0) {
                        sb.append(';');
                    }
                    sb.append(this.objects[y][x]);
                    ++x;
                }
                bw.write(sb.toString());
                bw.newLine();
                ++y;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Schematic loadFromFile(Path file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader br = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            int x;
            String[] parts;
            String line;
            String header = br.readLine();
            if (header == null) {
                throw new IOException("Empty schematic file: " + String.valueOf(file));
            }
            String[] hw = header.split(";");
            if (hw.length < 2) {
                throw new IOException("Invalid header in schematic: " + header);
            }
            int w = Integer.parseInt(hw[0]);
            int h = Integer.parseInt(hw[1]);
            Schematic s = new Schematic(w, h);
            int y = 0;
            while (y < h) {
                line = br.readLine();
                if (line == null) {
                    throw new IOException("Unexpected EOF while reading tiles.");
                }
                parts = line.split(";");
                x = 0;
                while (x < w && x < parts.length) {
                    try {
                        s.tiles[y][x] = Integer.parseInt(parts[x]);
                    }
                    catch (NumberFormatException ignore) {
                        s.tiles[y][x] = 0;
                    }
                    ++x;
                }
                ++y;
            }
            y = 0;
            while (y < h) {
                line = br.readLine();
                if (line == null) {
                    throw new IOException("Unexpected EOF while reading objects.");
                }
                parts = line.split(";");
                x = 0;
                while (x < w && x < parts.length) {
                    try {
                        s.objects[y][x] = Integer.parseInt(parts[x]);
                    }
                    catch (NumberFormatException ignore) {
                        s.objects[y][x] = 0;
                    }
                    ++x;
                }
                ++y;
            }
            return s;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

