/*
 * Decompiled with CFR 0.152.
 */
package com.schem;

import com.schem.EgiveServerCommand;
import com.schem.EregenServerCommand;
import com.schem.InvisibleBuff;
import com.schem.InvisibleCommand;
import com.schem.SchemCommand;
import com.schem.SchemManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import necesse.engine.GameEventInterface;
import necesse.engine.GameEventListener;
import necesse.engine.GameEvents;
import necesse.engine.commands.ChatCommand;
import necesse.engine.commands.CommandsManager;
import necesse.engine.events.players.ObjectDamageEvent;
import necesse.engine.events.players.TileDamageEvent;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.BuffRegistry;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.level.maps.Level;

@ModEntry
public class SchemMod {
    public static SchemManager SCHEM;
    private static final long CHAT_COOLDOWN_MS = 60000L;
    private static final Map<Long, Long> lastMsg;

    static {
        lastMsg = new ConcurrentHashMap<Long, Long>();
    }

    public void init() {
        System.out.println("[EternalSchem] init (schem + spawn protect)");
        SCHEM = new SchemManager();
        SchemCommand.register();
        CommandsManager.registerServerCommand((ChatCommand)new EgiveServerCommand());
        CommandsManager.registerServerCommand((ChatCommand)new EregenServerCommand());
        BuffRegistry.registerBuff((String)"eternal_invisible", (Buff)new InvisibleBuff());
        CommandsManager.registerServerCommand((ChatCommand)new InvisibleCommand());
        GameEvents.addListener(ObjectDamageEvent.class, (GameEventInterface)new GameEventListener<ObjectDamageEvent>(){

            public void onEvent(ObjectDamageEvent e) {
                Level level = SchemMod.getLevel(e);
                Integer x = SchemMod.getTileX(e);
                Integer y = SchemMod.getTileY(e);
                ServerClient sc = SchemMod.getServerClient(e);
                if (level == null || x == null || y == null) {
                    return;
                }
                if (!SCHEM.isInSpawnProtect(level, x, y)) {
                    return;
                }
                if (sc == null) {
                    return;
                }
                SchemMod.denyThrottled(sc);
                e.preventDefault();
            }
        });
        GameEvents.addListener(TileDamageEvent.class, (GameEventInterface)new GameEventListener<TileDamageEvent>(){

            public void onEvent(TileDamageEvent e) {
                Level level = SchemMod.getLevel(e);
                Integer x = SchemMod.getTileX(e);
                Integer y = SchemMod.getTileY(e);
                ServerClient sc = SchemMod.getServerClient(e);
                if (level == null || x == null || y == null) {
                    return;
                }
                if (!SCHEM.isInSpawnProtect(level, x, y)) {
                    return;
                }
                if (sc == null) {
                    return;
                }
                SchemMod.denyThrottled(sc);
                e.preventDefault();
            }
        });
        SchemMod.registerPlaceListener("necesse.engine.events.players.ItemPlaceEvent");
    }

    private static void denyThrottled(ServerClient client) {
        if (client == null) {
            return;
        }
        long auth = client.authentication;
        long now = System.currentTimeMillis();
        Long last = lastMsg.get(auth);
        if (last == null || now - last >= 60000L) {
            lastMsg.put(auth, now);
            SchemMod.denyImmediate(client, "This spawn area is protected.");
        }
    }

    private static void denyImmediate(ServerClient client, String msg) {
        try {
            if (client != null) {
                client.sendChatMessage((GameMessage)new StaticMessage(msg));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static ServerClient getServerClient(Object e) {
        Object sc2;
        try {
            sc2 = e.getClass().getField("client").get(e);
            if (sc2 instanceof ServerClient) {
                return (ServerClient)sc2;
            }
        }
        catch (Throwable sc2) {
            // empty catch block
        }
        try {
            sc2 = e.getClass().getField("serverClient").get(e);
            if (sc2 instanceof ServerClient) {
                return (ServerClient)sc2;
            }
        }
        catch (Throwable sc3) {
            // empty catch block
        }
        try {
            Object sc4;
            Object player = e.getClass().getField("player").get(e);
            if (player != null && (sc4 = player.getClass().getMethod("getServerClient", new Class[0]).invoke(player, new Object[0])) instanceof ServerClient) {
                return (ServerClient)sc4;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Level getLevel(Object e) {
        Object l2;
        try {
            l2 = e.getClass().getField("level").get(e);
            if (l2 instanceof Level) {
                return (Level)l2;
            }
        }
        catch (Throwable l2) {
            // empty catch block
        }
        try {
            l2 = e.getClass().getMethod("getLevel", new Class[0]).invoke(e, new Object[0]);
            if (l2 instanceof Level) {
                return (Level)l2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Integer getTileX(Object e) {
        try {
            return (Integer)e.getClass().getField("tileX").get(e);
        }
        catch (Throwable throwable) {
            try {
                return (Integer)e.getClass().getMethod("getTileX", new Class[0]).invoke(e, new Object[0]);
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
    }

    private static Integer getTileY(Object e) {
        try {
            return (Integer)e.getClass().getField("tileY").get(e);
        }
        catch (Throwable throwable) {
            try {
                return (Integer)e.getClass().getMethod("getTileY", new Class[0]).invoke(e, new Object[0]);
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
    }

    private static void registerPlaceListener(String className) {
        try {
            Class<?> evt = Class.forName(className);
            GameEventListener<Object> listener = new GameEventListener<Object>(){

                public void onEvent(Object e) {
                    ServerClient sc = SchemMod.getServerClient(e);
                    Level level = SchemMod.getLevel(e);
                    Integer x = SchemMod.getTileX(e);
                    Integer y = SchemMod.getTileY(e);
                    if (level == null || x == null || y == null) {
                        return;
                    }
                    if (!SCHEM.isInSpawnProtect(level, x, y)) {
                        return;
                    }
                    if (sc == null) {
                        return;
                    }
                    SchemMod.denyThrottled(sc);
                    try {
                        e.getClass().getMethod("preventDefault", new Class[0]).invoke(e, new Object[0]);
                    }
                    catch (Throwable ignore1) {
                        try {
                            e.getClass().getMethod("cancel", new Class[0]).invoke(e, new Object[0]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            };
            Class<?> rawEvt = evt;
            GameEventListener<Object> rawListener = listener;
            GameEvents.addListener(rawEvt, (GameEventInterface)rawListener);
            System.out.println("[EternalSchem] Registered spawn-protect place listener: " + className);
        }
        catch (Throwable t) {
            System.out.println("[EternalSchem] ItemPlaceEvent not found; skipping (" + className + ")");
        }
    }
}

