/*
 * Decompiled with CFR 0.152.
 */
package com.schem;

import com.schem.Schematic;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketChatMessage;
import necesse.engine.network.packet.PacketSpawnFirework;
import necesse.engine.network.packet.PacketUnloadRegions;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.TileRegistry;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.PlayerMob;
import necesse.level.maps.Level;

public class SchemManager {
    private final Path schemDir;
    private final Map<String, Schematic> cache = new ConcurrentHashMap<String, Schematic>();
    private final Path spawnProtectFile;
    private final Map<Integer, SpawnProtectZone> spawnZones = new ConcurrentHashMap<Integer, SpawnProtectZone>();

    public SchemManager() {
        this.schemDir = Paths.get("schematics", new String[0]);
        this.spawnProtectFile = Paths.get("schem_spawnprotect.txt", new String[0]);
        try {
            Files.createDirectories(this.schemDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.out.println("[EternalSchem] Failed to create schematics folder: " + e.getMessage());
        }
        this.loadSpawnProtectFromFile();
    }

    private void send(ServerClient sc, String msg) {
        if (sc == null || msg == null) {
            return;
        }
        try {
            sc.sendPacket((Packet)new PacketChatMessage(msg));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String sanitizeName(String s) {
        if (s == null) {
            return "noname";
        }
        String out = s.trim().toLowerCase(Locale.ROOT);
        if ((out = out.replaceAll("[^a-z0-9_\\-]", "_")).isEmpty()) {
            out = "noname";
        }
        return out;
    }

    private Path getFile(String name) {
        String clean = this.sanitizeName(name);
        return this.schemDir.resolve(clean + ".schem");
    }

    private boolean isBaseTerrain(int tileID) {
        if (tileID <= 0) {
            return true;
        }
        return tileID == TileRegistry.dirtID || tileID == TileRegistry.sandID || tileID == TileRegistry.gravelID || tileID == TileRegistry.snowID || tileID == TileRegistry.iceID || tileID == TileRegistry.mudID || tileID == TileRegistry.rockID || tileID == TileRegistry.snowRockID || tileID == TileRegistry.swampRockID || tileID == TileRegistry.deepRockID || tileID == TileRegistry.deepSnowRockID || tileID == TileRegistry.deepSwampRockID || tileID == TileRegistry.sandstoneID || tileID == TileRegistry.deepSandstoneID || tileID == TileRegistry.grassID || tileID == TileRegistry.overgrownGrassID || tileID == TileRegistry.plainsGrassID || tileID == TileRegistry.overgrownPlainsGrassID || tileID == TileRegistry.swampGrassID || tileID == TileRegistry.overgrownSwampGrassID;
    }

    private void saveSpawnProtectToFile() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(this.spawnProtectFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                for (Map.Entry<Integer, SpawnProtectZone> e : this.spawnZones.entrySet()) {
                    int levelHash = e.getKey();
                    SpawnProtectZone z = e.getValue();
                    bw.write(levelHash + ";" + z.centerX + ";" + z.centerY + ";" + z.radius);
                    bw.newLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("[EternalSchem] Failed to save spawn protect file: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadSpawnProtectFromFile() {
        this.spawnZones.clear();
        if (!Files.exists(this.spawnProtectFile, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader br = Files.newBufferedReader(this.spawnProtectFile, StandardCharsets.UTF_8);){
                while (true) {
                    String[] parts;
                    String line;
                    if ((line = br.readLine()) == null) {
                        System.out.println("[EternalSchem] Loaded spawn protect zones: " + this.spawnZones.size());
                        return;
                    }
                    if ((line = line.trim()).isEmpty() || line.startsWith("#") || (parts = line.split(";")).length < 4) continue;
                    try {
                        int levelHash = Integer.parseInt(parts[0]);
                        int cx = Integer.parseInt(parts[1]);
                        int cy = Integer.parseInt(parts[2]);
                        int radius = Integer.parseInt(parts[3]);
                        this.spawnZones.put(levelHash, new SpawnProtectZone(cx, cy, radius));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("[EternalSchem] Failed to load spawn protect file: " + e.getMessage());
        }
    }

    public void addSpawnProtect(ServerClient sc, int radius) {
        if (sc == null) {
            return;
        }
        PlayerMob pm = sc.playerMob;
        if (pm == null) {
            this.send(sc, "[Schem] Player mob is null.");
            return;
        }
        Level level = pm.getLevel();
        if (level == null) {
            this.send(sc, "[Schem] Level is null.");
            return;
        }
        if (radius < 1) {
            radius = 1;
        }
        if (radius > 256) {
            radius = 256;
        }
        int cx = pm.getTileX();
        int cy = pm.getTileY();
        int key = level.getIdentifierHashCode();
        this.spawnZones.put(key, new SpawnProtectZone(cx, cy, radius));
        this.saveSpawnProtectToFile();
        this.send(sc, "[Schem] Spawn protect set on this level at (" + cx + ", " + cy + ") radius " + radius + " tiles.");
    }

    public void removeSpawnProtect(ServerClient sc) {
        if (sc == null) {
            return;
        }
        PlayerMob pm = sc.playerMob;
        if (pm == null) {
            this.send(sc, "[Schem] Player mob is null.");
            return;
        }
        Level level = pm.getLevel();
        if (level == null) {
            this.send(sc, "[Schem] Level is null.");
            return;
        }
        int key = level.getIdentifierHashCode();
        if (this.spawnZones.remove(key) != null) {
            this.saveSpawnProtectToFile();
            this.send(sc, "[Schem] Spawn protection removed on this level.");
        } else {
            this.send(sc, "[Schem] No spawn protection was set on this level.");
        }
    }

    public boolean isSpawnProtectedTile(Level level, int tileX, int tileY) {
        if (level == null) {
            return false;
        }
        SpawnProtectZone z = this.spawnZones.get(level.getIdentifierHashCode());
        if (z == null) {
            return false;
        }
        int dx = Math.abs(tileX - z.centerX);
        int dy = Math.abs(tileY - z.centerY);
        return dx <= z.radius && dy <= z.radius;
    }

    public boolean isInSpawnProtect(Level level, int tileX, int tileY) {
        return this.isSpawnProtectedTile(level, tileX, tileY);
    }

    public void saveArea(ServerClient sc, String rawName, int radius) {
        if (sc == null) {
            return;
        }
        PlayerMob pm = sc.playerMob;
        if (pm == null) {
            this.send(sc, "[Schem] Player mob is null.");
            return;
        }
        Level level = pm.getLevel();
        if (level == null) {
            this.send(sc, "[Schem] Level is null.");
            return;
        }
        if (!level.isServer()) {
            this.send(sc, "[Schem] Can only be used on server level.");
            return;
        }
        if (radius < 1) {
            radius = 1;
        }
        if (radius > 128) {
            radius = 128;
        }
        int cx = pm.getTileX();
        int cy = pm.getTileY();
        int width = radius * 2 + 1;
        int height = radius * 2 + 1;
        Schematic s = new Schematic(width, height);
        int dy = 0;
        while (dy < height) {
            int ty = cy - radius + dy;
            int dx = 0;
            while (dx < width) {
                int tx = cx - radius + dx;
                int tileID = 0;
                int objID = 0;
                try {
                    tileID = level.getTileID(tx, ty);
                    objID = level.getObjectID(tx, ty);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.isBaseTerrain(tileID)) {
                    tileID = 0;
                }
                s.tiles[dy][dx] = tileID;
                s.objects[dy][dx] = objID;
                ++dx;
            }
            ++dy;
        }
        Path file = this.getFile(rawName);
        try {
            s.saveToFile(file);
            this.cache.put(this.sanitizeName(rawName), s);
            this.send(sc, "[Schem] Saved \"" + this.sanitizeName(rawName) + "\" radius " + radius + " (" + width + "x" + height + ").");
        }
        catch (IOException e) {
            this.send(sc, "[Schem] Failed to save schematic: " + e.getMessage());
        }
    }

    public Schematic load(String rawName) {
        String key = this.sanitizeName(rawName);
        Schematic cached = this.cache.get(key);
        if (cached != null) {
            return cached;
        }
        Path file = this.getFile(key);
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        try {
            Schematic s = Schematic.loadFromFile(file);
            this.cache.put(key, s);
            return s;
        }
        catch (IOException e) {
            System.out.println("[EternalSchem] Failed to load schematic " + key + ": " + e.getMessage());
            return null;
        }
    }

    public void paste(ServerClient sc, String rawName) {
        if (sc == null) {
            return;
        }
        PlayerMob pm = sc.playerMob;
        if (pm == null) {
            this.send(sc, "[Schem] Player mob is null.");
            return;
        }
        Level level = pm.getLevel();
        if (level == null) {
            this.send(sc, "[Schem] Level is null.");
            return;
        }
        if (!level.isServer()) {
            this.send(sc, "[Schem] Can only be used on server level.");
            return;
        }
        Schematic s = this.load(rawName);
        if (s == null) {
            this.send(sc, "[Schem] Schematic not found: " + this.sanitizeName(rawName));
            return;
        }
        int cx = pm.getTileX();
        int cy = pm.getTileY();
        int radiusX = s.width / 2;
        int radiusY = s.height / 2;
        HashSet<Point> changedRegions = new HashSet<Point>();
        int dy = 0;
        while (dy < s.height) {
            int ty = cy - radiusY + dy;
            int dx = 0;
            while (dx < s.width) {
                int tx = cx - radiusX + dx;
                int tileID = s.tiles[dy][dx];
                int objID = s.objects[dy][dx];
                try {
                    if (tileID != 0) {
                        level.setTile(tx, ty, tileID);
                    }
                    level.setObject(tx, ty, objID);
                    int regionX = GameMath.getRegionCoordByTile((int)tx);
                    int regionY = GameMath.getRegionCoordByTile((int)ty);
                    changedRegions.add(new Point(regionX, regionY));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++dx;
            }
            ++dy;
        }
        if (!changedRegions.isEmpty()) {
            try {
                sc.sendPacket((Packet)new PacketUnloadRegions(level, changedRegions));
            }
            catch (Throwable t) {
                System.out.println("[EternalSchem] Failed to send PacketUnloadRegions: " + String.valueOf(t));
            }
        }
        this.send(sc, "[Schem] Pasted \"" + this.sanitizeName(rawName) + "\" at your position.");
    }

    public void showRadius(ServerClient sc, int radius) {
        if (sc == null) {
            return;
        }
        PlayerMob pm = sc.playerMob;
        if (pm == null) {
            this.send(sc, "[Schem] Player mob is null.");
            return;
        }
        Level level = pm.getLevel();
        if (level == null) {
            this.send(sc, "[Schem] Level is null.");
            return;
        }
        if (radius < 1) {
            radius = 1;
        }
        if (radius > 120) {
            radius = 120;
        }
        int centerX = pm.getX();
        int centerY = pm.getY();
        int pixelRadius = radius * 32;
        int stepTiles = radius <= 30 ? 1 : (radius <= 80 ? 2 : 3);
        GameRandom rand = GameRandom.globalRandom;
        GNDItemMap gndBase = new GNDItemMap();
        int height = 120;
        float size = 1.2f;
        int off = -radius;
        while (off <= radius) {
            float px = (float)centerX + (float)off * 32.0f;
            this.spawnFirework(sc, level, px, centerY - pixelRadius, height, size, gndBase, rand);
            this.spawnFirework(sc, level, px, centerY + pixelRadius, height, size, gndBase, rand);
            off += stepTiles;
        }
        off = -radius + stepTiles;
        while (off <= radius - stepTiles) {
            float py = (float)centerY + (float)off * 32.0f;
            this.spawnFirework(sc, level, centerX - pixelRadius, py, height, size, gndBase, rand);
            this.spawnFirework(sc, level, centerX + pixelRadius, py, height, size, gndBase, rand);
            off += stepTiles;
        }
        this.send(sc, "[Schem] Showing SQUARE radius " + radius + " tiles with fireworks!");
    }

    private void spawnFirework(ServerClient sc, Level level, float px, float py, int height, float size, GNDItemMap gnd, GameRandom rand) {
        try {
            int seed = rand.nextInt();
            PacketSpawnFirework packet = new PacketSpawnFirework(level, px, py, height, size, gnd, seed);
            sc.sendPacket((Packet)packet);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void listSchems(ServerClient sc) {
        if (sc == null) {
            return;
        }
        try {
            if (!Files.exists(this.schemDir, new LinkOption[0])) {
                this.send(sc, "[Schem] No schematics folder yet.");
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("[Schem] Available schematics: ");
            boolean any = false;
            for (Path p : Files.newDirectoryStream(this.schemDir, "*.schem")) {
                String fn = p.getFileName().toString();
                if (fn.endsWith(".schem")) {
                    fn = fn.substring(0, fn.length() - ".schem".length());
                }
                if (any) {
                    sb.append(", ");
                }
                sb.append(fn);
                any = true;
            }
            if (!any) {
                this.send(sc, "[Schem] No schematics saved yet.");
            } else {
                this.send(sc, sb.toString());
            }
        }
        catch (IOException e) {
            this.send(sc, "[Schem] Error listing schematics: " + e.getMessage());
        }
    }

    public void deleteSchemat(ServerClient sc, String rawName) {
        if (sc == null) {
            return;
        }
        String key = this.sanitizeName(rawName);
        Path file = this.getFile(key);
        this.cache.remove(key);
        try {
            if (Files.exists(file, new LinkOption[0])) {
                Files.delete(file);
                this.send(sc, "[Schem] Deleted schematic: " + key);
            } else {
                this.send(sc, "[Schem] Schematic not found: " + key);
            }
        }
        catch (IOException e) {
            this.send(sc, "[Schem] Failed to delete schematic: " + e.getMessage());
        }
    }

    private static class SpawnProtectZone {
        final int centerX;
        final int centerY;
        final int radius;

        SpawnProtectZone(int centerX, int centerY, int radius) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.radius = radius;
        }
    }
}

