/*
 * Decompiled with CFR 0.152.
 */
package com.schem;

import com.schem.PermissionsUtil;
import com.schem.SchemMod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import necesse.engine.commands.AutoComplete;
import necesse.engine.commands.ChatCommand;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.CommandsManager;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;

public class SchemCommand
extends ChatCommand {
    public SchemCommand() {
        super("schem", PermissionLevel.USER);
    }

    public static void register() {
        CommandsManager.registerServerCommand((ChatCommand)new SchemCommand());
    }

    public boolean isCheat() {
        return false;
    }

    public String getUsage() {
        return "save | paste | list | del | showradius | spawnprotect";
    }

    public String getAction() {
        return "Save, paste and protect schematics";
    }

    public String getCurrentUsage(Client c, Server s, ServerClient sc, String[] args) {
        return "Usage:\n(Admin/Owner Only)\n\n/schem save <name> <radius>\n/schem paste <name>\n/schem list\n/schem del <name>\n/schem showradius <radius>\n\n/schem spawnprotect <radius>\n/schem spawnprotect remove\n";
    }

    public List<AutoComplete> autocomplete(Client c, Server s, ServerClient sc, String[] args) {
        return Collections.emptyList();
    }

    public boolean run(Client client, Server server, ServerClient sc, ArrayList<String> args, CommandLog log) {
        String sub;
        if (sc == null) {
            log.add("This command must be used by a player.");
            return false;
        }
        if (!PermissionsUtil.isAdminOrOwner(sc)) {
            log.add("You do not have permission to use /schem. (Admin/Owner only)");
            return false;
        }
        if (args == null || args.isEmpty()) {
            SchemMod.SCHEM.listSchems(sc);
            return true;
        }
        switch (sub = args.get(0).toLowerCase()) {
            case "save": {
                int radius;
                if (args.size() < 3) {
                    log.add("Usage: /schem save <name> <radius>");
                    return false;
                }
                String name = args.get(1);
                try {
                    radius = Integer.parseInt(args.get(2));
                }
                catch (NumberFormatException e) {
                    log.add("Radius must be a number.");
                    return false;
                }
                SchemMod.SCHEM.saveArea(sc, name, radius);
                return true;
            }
            case "paste": {
                if (args.size() < 2) {
                    log.add("Usage: /schem paste <name>");
                    return false;
                }
                String name = args.get(1);
                SchemMod.SCHEM.paste(sc, name);
                return true;
            }
            case "list": {
                SchemMod.SCHEM.listSchems(sc);
                return true;
            }
            case "delete": 
            case "del": {
                if (args.size() < 2) {
                    log.add("Usage: /schem del <name>");
                    return false;
                }
                SchemMod.SCHEM.deleteSchemat(sc, args.get(1));
                return true;
            }
            case "showradius": {
                int radius;
                if (args.size() < 2) {
                    log.add("Usage: /schem showradius <radius>");
                    return false;
                }
                try {
                    radius = Integer.parseInt(args.get(1));
                }
                catch (NumberFormatException e) {
                    log.add("Radius must be a number.");
                    return false;
                }
                SchemMod.SCHEM.showRadius(sc, radius);
                return true;
            }
            case "spawnprotect": {
                int radius;
                if (args.size() >= 2 && args.get(1).equalsIgnoreCase("remove")) {
                    SchemMod.SCHEM.removeSpawnProtect(sc);
                    return true;
                }
                if (args.size() < 2) {
                    log.add("Usage: /schem spawnprotect <radius>  OR  /schem spawnprotect remove");
                    return false;
                }
                try {
                    radius = Integer.parseInt(args.get(1));
                }
                catch (NumberFormatException e) {
                    log.add("Radius must be a number.");
                    return false;
                }
                SchemMod.SCHEM.addSpawnProtect(sc, radius);
                return true;
            }
        }
        log.add("Unknown subcommand.");
        return false;
    }
}

