/*
 * Decompiled with CFR 0.152.
 */
package com.schem;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;

public final class PermissionsUtil {
    private PermissionsUtil() {
    }

    public static boolean hasAtLeast(ServerClient sc, PermissionLevel minLevel) {
        Object pl;
        Method m3;
        if (sc == null || minLevel == null) {
            return false;
        }
        try {
            m3 = sc.getClass().getMethod("hasPermission", PermissionLevel.class);
            Object r = m3.invoke((Object)sc, minLevel);
            if (r instanceof Boolean) {
                Boolean b = (Boolean)r;
                return b;
            }
        }
        catch (Throwable m2) {
            // empty catch block
        }
        try {
            m3 = sc.getClass().getMethod("getPermissionLevel", new Class[0]);
            pl = m3.invoke((Object)sc, new Object[0]);
            if (pl instanceof PermissionLevel) {
                PermissionLevel p = (PermissionLevel)pl;
                return p.getLevel() >= minLevel.getLevel();
            }
        }
        catch (Throwable m3) {
            // empty catch block
        }
        try {
            Field f = sc.getClass().getField("permissionLevel");
            pl = f.get(sc);
            if (pl instanceof PermissionLevel) {
                PermissionLevel p = (PermissionLevel)pl;
                return p.getLevel() >= minLevel.getLevel();
            }
        }
        catch (Throwable f) {
            // empty catch block
        }
        Server srv = sc.getServer();
        if (srv != null) {
            try {
                Method m4 = srv.getClass().getMethod("getPermissionLevel", ServerClient.class);
                Object pl2 = m4.invoke((Object)srv, sc);
                if (pl2 instanceof PermissionLevel) {
                    PermissionLevel p = (PermissionLevel)pl2;
                    return p.getLevel() >= minLevel.getLevel();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (PermissionsUtil.callBool(srv, "isServerOwner", ServerClient.class, sc)) {
                return true;
            }
            if (PermissionsUtil.callBool(srv, "isHost", ServerClient.class, sc)) {
                return true;
            }
            if (PermissionsUtil.sameObject(srv, "getOwnerClient", sc)) {
                return true;
            }
            if (PermissionsUtil.sameObject(srv, "getHostClient", sc)) {
                return true;
            }
            if (PermissionsUtil.sameObject(srv, "getOwner", sc)) {
                return true;
            }
        }
        if (PermissionsUtil.callBool(sc, "isServerOwner")) {
            return true;
        }
        if (PermissionsUtil.callBool(sc, "isOwner")) {
            return true;
        }
        return minLevel.getLevel() <= PermissionLevel.ADMIN.getLevel() && PermissionsUtil.callBool(sc, "isAdmin");
    }

    public static boolean isAdminOrOwner(ServerClient sc) {
        return PermissionsUtil.hasAtLeast(sc, PermissionLevel.ADMIN) || PermissionsUtil.hasAtLeast(sc, PermissionLevel.OWNER) || PermissionsUtil.hasAtLeast(sc, PermissionLevel.SERVER);
    }

    private static boolean callBool(Object target, String method) {
        try {
            Method m = target.getClass().getMethod(method, new Class[0]);
            Object r = m.invoke(target, new Object[0]);
            return r instanceof Boolean && (Boolean)r != false;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    private static boolean callBool(Object target, String method, Class<?> pType, Object arg) {
        try {
            Method m = target.getClass().getMethod(method, pType);
            Object r = m.invoke(target, arg);
            return r instanceof Boolean && (Boolean)r != false;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    private static boolean sameObject(Object target, String getterNoArgs, Object expect) {
        try {
            Method m = target.getClass().getMethod(getterNoArgs, new Class[0]);
            Object r = m.invoke(target, new Object[0]);
            return r == expect;
        }
        catch (Throwable ignore) {
            return false;
        }
    }
}

