/*
 * Decompiled with CFR 0.152.
 */
package com.schem;

import necesse.engine.network.server.ServerClient;
import necesse.engine.world.WorldEntityGameClock;
import necesse.engine.world.worldData.SettlementsWorldData;
import necesse.level.maps.Level;
import necesse.level.maps.levelData.settlementData.NetworkSettlementData;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;

public class NoGrindUtil {
    public static boolean isInSettlementProtectedZone(ServerClient sc) {
        if (sc == null || sc.playerMob == null) {
            return false;
        }
        Level level = sc.getLevel();
        if (level == null || !NoGrindUtil.isServerLevel(level)) {
            return false;
        }
        int tx = sc.playerMob.getX() / 32;
        int ty = sc.playerMob.getY() / 32;
        return NoGrindUtil.isClaimedSettlementTile(level, tx, ty);
    }

    private static boolean isClaimedSettlementTile(Level level, int tileX, int tileY) {
        try {
            SettlementsWorldData world = SettlementsWorldData.getSettlementsData((WorldEntityGameClock)level);
            ServerSettlementData data = world.getServerDataAtTile(level.getIdentifier(), tileX, tileY);
            if (data == null) {
            }
            NetworkSettlementData net = data.networkData;
            return net != null && net.hasOwner();
        }
        finally {
            return false;
        }
    }

    private static boolean isServerLevel(Level level) {
        try {
            return level.isServer();
        }
        catch (Throwable t) {
            return true;
        }
    }
}

