/*
 * Decompiled with CFR 0.152.
 */
package com.schem;

import com.schem.PermissionsUtil;
import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.BuffRegistry;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;

public class InvisibleCommand
extends ModularChatCommand {
    public static final String BUFF_ID = "eternal_invisible";

    public InvisibleCommand() {
        super("invisible", "Invisibility: /invisible [on|off|toggle]", PermissionLevel.USER, false, new CmdParameter[0]);
    }

    public void runModular(Client client, Server server, ServerClient sc, Object[] args, String[] errors, CommandLog logs) {
        if (sc == null || sc.playerMob == null) {
            logs.add("This command must be used by a player.");
            return;
        }
        if (!PermissionsUtil.isAdminOrOwner(sc)) {
            logs.add("No permission. (Admin/Owner only)");
            return;
        }
        int buffTypeID = BuffRegistry.getBuffID((String)BUFF_ID);
        if (buffTypeID == -1) {
            logs.add("Invisible buff not registered: eternal_invisible");
            return;
        }
        String mode = "toggle";
        if (args != null && args.length > 0 && args[0] instanceof String) {
            mode = ((String)args[0]).toLowerCase();
        }
        boolean has = sc.playerMob.buffManager.hasBuff(buffTypeID);
        switch (mode) {
            case "off": {
                if (has) {
                    sc.playerMob.buffManager.removeBuff(buffTypeID, true);
                }
                logs.add("Invisibility OFF");
                break;
            }
            case "on": {
                if (!has) {
                    ActiveBuff ab = new ActiveBuff(BuffRegistry.getBuff((int)buffTypeID), (Mob)sc.playerMob, -1, null);
                    sc.playerMob.buffManager.addBuff(ab, true);
                }
                logs.add("Invisibility ON");
                break;
            }
            default: {
                if (has) {
                    sc.playerMob.buffManager.removeBuff(buffTypeID, true);
                    logs.add("Invisibility OFF");
                    break;
                }
                ActiveBuff ab = new ActiveBuff(BuffRegistry.getBuff((int)buffTypeID), (Mob)sc.playerMob, -1, null);
                sc.playerMob.buffManager.addBuff(ab, true);
                logs.add("Invisibility ON");
            }
        }
    }
}

