/*
 * Decompiled with CFR 0.152.
 */
package com.schem;

import java.io.IOException;
import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.commands.parameterHandlers.BoolParameterHandler;
import necesse.engine.commands.parameterHandlers.LevelIdentifierParameterHandler;
import necesse.engine.commands.parameterHandlers.ParameterHandler;
import necesse.engine.network.Packet;
import necesse.engine.network.client.Client;
import necesse.engine.network.packet.PacketPlayerLevelChange;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.engine.util.LevelIdentifier;
import necesse.engine.world.WorldGenerator;
import necesse.engine.world.worldData.SettlementsWorldData;
import necesse.level.maps.Level;

public class EregenServerCommand
extends ModularChatCommand {
    public EregenServerCommand() {
        super("eregen", "Regenerates the entire level (no cheat)", PermissionLevel.OWNER, false, new CmdParameter[]{new CmdParameter("seeded", (ParameterHandler)new BoolParameterHandler(Boolean.valueOf(true)), true, new CmdParameter[0]), new CmdParameter("level", (ParameterHandler)new LevelIdentifierParameterHandler(null), true, new CmdParameter[0])});
    }

    public void runModular(Client client, Server server, ServerClient executor, Object[] args, String[] errors, CommandLog logs) {
        boolean seeded = (Boolean)args[0];
        LevelIdentifier li = (LevelIdentifier)args[1];
        if (li == null) {
            if (executor == null) {
                logs.add("Please specify level");
                return;
            }
            li = executor.getLevelIdentifier();
        }
        LevelIdentifier levelIdentifier = li;
        try {
            server.world.fileSystem.deleteAllLevelFiles(levelIdentifier);
            SettlementsWorldData.getSettlementsData((Server)server).deleteSettlementsAt(levelIdentifier);
            GameBlackboard blackboard = new GameBlackboard();
            if (!seeded) {
                blackboard.set("seed", (Object)GameRandom.globalRandom.nextInt());
            }
            Level newLevel = WorldGenerator.generateNewLevel((LevelIdentifier)levelIdentifier, (Server)server, (GameBlackboard)blackboard);
            newLevel.makeServerLevel(server);
            newLevel.overwriteIdentifier(levelIdentifier);
            server.world.levelManager.overwriteLevel(newLevel);
            server.streamClients().filter(c -> c.isSamePlace(levelIdentifier)).forEach(c -> {
                c.reset();
                server.network.sendPacket((Packet)new PacketPlayerLevelChange(c.slot, levelIdentifier, true), c);
            });
            logs.add("Regenerated level " + String.valueOf(levelIdentifier) + (seeded ? "" : " (not seeded)") + ".");
        }
        catch (IOException e) {
            System.err.println("Could not delete level regions folder for " + String.valueOf(levelIdentifier));
            logs.add("Error deleting regions folder for " + String.valueOf(levelIdentifier) + ": " + e.getMessage());
            e.printStackTrace();
        }
    }
}

