/*
 * Decompiled with CFR 0.152.
 */
package PartyCreator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;

public class PartyState {
    public static final int NUM_SLOTS = 3;
    private static final Map<Integer, PartySlot[]> settlementParties = new HashMap<Integer, PartySlot[]>();

    private static int getSettlementHash(String settlementKey) {
        if (settlementKey == null) {
            return 0;
        }
        return settlementKey.hashCode();
    }

    private static PartySlot[] getOrCreateSlots(String settlementKey) {
        int hash = PartyState.getSettlementHash(settlementKey);
        PartySlot[] slots = settlementParties.get(hash);
        if (slots == null) {
            slots = new PartySlot[3];
            for (int i = 0; i < 3; ++i) {
                slots[i] = new PartySlot("Party " + (i + 1));
            }
            settlementParties.put(hash, slots);
        }
        return slots;
    }

    public static void saveParty(String settlementKey, int slotIndex, List<Integer> settlers) {
        PartySlot[] slots = PartyState.getOrCreateSlots(settlementKey);
        if (slotIndex < 0 || slotIndex >= 3) {
            return;
        }
        PartySlot slot = slots[slotIndex];
        slot.settlers.clear();
        slot.settlers.addAll(settlers);
    }

    public static boolean hasParty(String settlementKey, int slotIndex) {
        int hash = PartyState.getSettlementHash(settlementKey);
        PartySlot[] slots = settlementParties.get(hash);
        if (slots == null || slotIndex < 0 || slotIndex >= 3) {
            return false;
        }
        return !slots[slotIndex].settlers.isEmpty();
    }

    public static List<Integer> getParty(String settlementKey, int slotIndex) {
        PartySlot[] slots = PartyState.getOrCreateSlots(settlementKey);
        if (slotIndex < 0 || slotIndex >= 3) {
            return Collections.emptyList();
        }
        return new ArrayList<Integer>(slots[slotIndex].settlers);
    }

    public static String getPartyName(String settlementKey, int slotIndex) {
        PartySlot[] slots = PartyState.getOrCreateSlots(settlementKey);
        if (slotIndex < 0 || slotIndex >= 3) {
            return "";
        }
        return slots[slotIndex].name;
    }

    public static void setPartyName(String settlementKey, int slotIndex, String newName) {
        PartySlot[] slots = PartyState.getOrCreateSlots(settlementKey);
        if (slotIndex < 0 || slotIndex >= 3) {
            return;
        }
        if (newName == null || newName.trim().isEmpty()) {
            newName = "Party " + (slotIndex + 1);
        }
        slots[slotIndex].name = newName;
    }

    public static void saveAll(SaveData root) {
        SaveData partyRoot = new SaveData("partycreator");
        for (Map.Entry<Integer, PartySlot[]> entry : settlementParties.entrySet()) {
            int settlementHash = entry.getKey();
            PartySlot[] slots = entry.getValue();
            SaveData settlementData = new SaveData("settlement");
            settlementData.addInt("hash", settlementHash);
            boolean hasAnySlots = false;
            for (int i = 0; i < 3; ++i) {
                boolean hasSettlers;
                PartySlot slot = slots[i];
                boolean bl = hasSettlers = !slot.settlers.isEmpty();
                if (!hasSettlers) continue;
                SaveData slotData = new SaveData("slot");
                slotData.addInt("index", i);
                slotData.addUnsafeString("name", slot.name);
                for (int j = 0; j < slot.settlers.size(); ++j) {
                    int id = slot.settlers.get(j);
                    SaveData settlerData = new SaveData("settler");
                    settlerData.addInt("id", id);
                    slotData.addSaveData(settlerData);
                }
                settlementData.addSaveData(slotData);
                hasAnySlots = true;
            }
            if (!hasAnySlots) continue;
            partyRoot.addSaveData(settlementData);
        }
        root.addSaveData(partyRoot);
    }

    public static void loadAll(LoadData root) {
        settlementParties.clear();
        LoadData partyRoot = root.getFirstLoadDataByName("partycreator");
        if (partyRoot == null) {
            return;
        }
        List settlements = partyRoot.getLoadDataByName("settlement");
        if (settlements == null) {
            return;
        }
        for (int s = 0; s < settlements.size(); ++s) {
            LoadData settlementData = (LoadData)settlements.get(s);
            int settlementHash = settlementData.getInt("hash", 0);
            PartySlot[] slots = new PartySlot[3];
            for (int i = 0; i < 3; ++i) {
                slots[i] = new PartySlot("Party " + (i + 1));
            }
            settlementParties.put(settlementHash, slots);
            List slotDatas = settlementData.getLoadDataByName("slot");
            if (slotDatas == null) continue;
            for (int i = 0; i < slotDatas.size(); ++i) {
                LoadData slotData = (LoadData)slotDatas.get(i);
                int idx = slotData.getInt("index", -1);
                if (idx < 0 || idx >= 3) continue;
                PartySlot slot = slots[idx];
                slot.settlers.clear();
                String loadedName = null;
                try {
                    loadedName = slotData.getUnsafeString("name");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (loadedName == null || loadedName.isEmpty()) {
                    loadedName = "Party " + (idx + 1);
                }
                slot.name = loadedName;
                List settlerDatas = slotData.getLoadDataByName("settler");
                if (settlerDatas == null) continue;
                for (int j = 0; j < settlerDatas.size(); ++j) {
                    LoadData settlerData = (LoadData)settlerDatas.get(j);
                    int id = settlerData.getInt("id", -1);
                    if (id == -1) continue;
                    slot.settlers.add(id);
                }
            }
        }
    }

    public static class PartySlot {
        public String name;
        public List<Integer> settlers;

        public PartySlot(String name) {
            this.name = name;
            this.settlers = new ArrayList<Integer>();
        }
    }
}

