/*
 * Decompiled with CFR 0.152.
 */
package PartyCreator;

import PartyCreator.PartyState;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import necesse.engine.GameLog;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.gfx.forms.ContainerComponent;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentIconButton;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormTextButton;
import necesse.gfx.forms.components.FormTextInput;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.components.localComponents.FormLocalTextButton;
import necesse.gfx.forms.events.FormInputEvent;
import necesse.gfx.forms.presets.containerComponent.SelectedSettlersHandler;
import necesse.gfx.forms.presets.containerComponent.settlement.SettlementCommandForm;
import necesse.gfx.forms.presets.containerComponent.settlement.SettlementContainerForm;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonTexture;
import net.bytebuddy.asm.Advice;

public class PartyCommandPatch {
    public static SettlementCommandForm<?> lastForm;
    public static final Set<Form> patchedNoneForms;
    private static int pendingSaveSlot;
    private static int renameSlotIndex;
    private static FormTextInput renameInput;
    public static FormContentIconButton[] renameButtons;

    private static void logToClient(SettlementCommandForm<?> form, String msg) {
        try {
            if (form != null && form.client != null && form.client.chat != null) {
                form.client.chat.addMessage(msg);
            } else {
                GameLog.out.println(msg);
            }
        }
        catch (Exception e) {
            GameLog.out.println(msg);
            e.printStackTrace();
        }
    }

    public static String getSettlementKey(SettlementCommandForm<?> form) {
        try {
            Field containerField = SettlementCommandForm.class.getDeclaredField("containerForm");
            containerField.setAccessible(true);
            Object container = containerField.get(form);
            if (container == null) {
                return "global";
            }
            Field settlementField = container.getClass().getField("settlement");
            Object settlement = settlementField.get(container);
            if (settlement == null) {
                return "global";
            }
            Field idField = settlement.getClass().getField("settlementID");
            int id = idField.getInt(settlement);
            return "settlement_" + id;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "global";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int saveCurrentSelection(SettlementCommandForm<?> form, int slotIndex) throws Exception {
        ArrayList<Integer> ids;
        String settlementKey = PartyCommandPatch.getSettlementKey(form);
        Field containerFormField = SettlementCommandForm.class.getDeclaredField("containerForm");
        containerFormField.setAccessible(true);
        SettlementContainerForm containerForm = (SettlementContainerForm)containerFormField.get(form);
        SelectedSettlersHandler selectedSettlersHandler = containerForm.selectedSettlers;
        synchronized (selectedSettlersHandler) {
            ids = new ArrayList<Integer>(containerForm.selectedSettlers.get());
        }
        if (ids.isEmpty()) {
            System.out.println("[PartyCreator] No settlers selected, party not changed");
            PartyCommandPatch.logToClient(form, "No settlers selected, party not changed");
            return 0;
        }
        PartyState.saveParty(settlementKey, slotIndex, ids);
        String partyName = PartyState.getPartyName(settlementKey, slotIndex);
        System.out.println("Party created");
        System.out.println("[PartyCreator] Saved " + ids.size() + " settlers to slot " + (slotIndex + 1) + " for " + settlementKey);
        PartyCommandPatch.logToClient(form, "Party " + partyName + " saved in slot number " + (slotIndex + 1));
        return ids.size();
    }

    private static void showReplaceConfirmUI(int slotIndex) {
        if (lastForm == null) {
            return;
        }
        pendingSaveSlot = slotIndex;
        try {
            Field selectedFormField = SettlementCommandForm.class.getDeclaredField("selectedForm");
            selectedFormField.setAccessible(true);
            Form selectedForm = (Form)selectedFormField.get(lastForm);
            if (selectedForm == null) {
                return;
            }
            int baseY = selectedForm.getHeight() + 4;
            int width = selectedForm.getWidth() - 8;
            int x = 4;
            FormLocalLabel label = new FormLocalLabel("ui", "partycreatorconfirm", new FontOptions(14), -1, x, baseY, width);
            selectedForm.addComponent((FormComponent)label);
            int buttonY = baseY + 40;
            int halfWidth = (width - 4) / 2;
            FormLocalTextButton yesButton = new FormLocalTextButton("ui", "partycreatorokbutton", x, buttonY, halfWidth, FormInputSize.SIZE_24, ButtonColor.BASE);
            yesButton.onClicked(PartyCommandPatch::onConfirmReplaceClicked);
            selectedForm.addComponent((FormComponent)yesButton);
            FormLocalTextButton noButton = new FormLocalTextButton("ui", "cancelbutton", x + halfWidth + 4, buttonY, halfWidth, FormInputSize.SIZE_24, ButtonColor.BASE);
            noButton.onClicked(PartyCommandPatch::onConfirmCancelClicked);
            selectedForm.addComponent((FormComponent)noButton);
            int newHeight = buttonY + 24 + 4;
            selectedForm.setHeight(newHeight);
            ContainerComponent.setPosInventory((Form)selectedForm);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void showRenameDialog(int slotIndex) {
        if (lastForm == null) {
            return;
        }
        renameSlotIndex = slotIndex;
        renameInput = null;
        try {
            Field selectedFormField = SettlementCommandForm.class.getDeclaredField("selectedForm");
            selectedFormField.setAccessible(true);
            Form selectedForm = (Form)selectedFormField.get(lastForm);
            if (selectedForm == null) {
                return;
            }
            String settlementKey = PartyCommandPatch.getSettlementKey(lastForm);
            String currentName = PartyState.getPartyName(settlementKey, slotIndex);
            int baseY = selectedForm.getHeight() + 4;
            int width = selectedForm.getWidth() - 8;
            int x = 4;
            FormLocalLabel label = new FormLocalLabel("ui", "partycreatorrenamelabel", new FontOptions(14), -1, x, baseY, width);
            selectedForm.addComponent((FormComponent)label);
            int inputY = baseY + 18;
            renameInput = new FormTextInput(x, inputY, FormInputSize.SIZE_24, width, 32);
            renameInput.setText(currentName);
            selectedForm.addComponent((FormComponent)renameInput);
            if (slotIndex >= 0 && slotIndex < renameButtons.length && renameButtons[slotIndex] != null) {
                renameButtons[slotIndex].setIcon(PartyCommandPatch.lastForm.getInterfaceStyle().container_rename_save);
                renameButtons[slotIndex].setTooltips(new GameMessage[]{new LocalMessage("ui", "settlersavename")});
            }
            int buttonY = inputY + 24 + 4;
            FormLocalTextButton okBtn = new FormLocalTextButton("ui", "partycreatorokbutton", x, buttonY, width, FormInputSize.SIZE_24, ButtonColor.BASE);
            okBtn.onClicked(PartyCommandPatch::onRenameConfirmClicked);
            selectedForm.addComponent((FormComponent)okBtn);
            int newHeight = buttonY + 24 + 4;
            selectedForm.setHeight(newHeight);
            ContainerComponent.setPosInventory((Form)selectedForm);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void onRenameConfirmClicked(FormInputEvent e) {
        if (lastForm == null || renameInput == null || renameSlotIndex < 0) {
            return;
        }
        try {
            String settlementKey = PartyCommandPatch.getSettlementKey(lastForm);
            String newName = renameInput.getText();
            if (newName == null || newName.trim().isEmpty()) {
                newName = "Party " + (renameSlotIndex + 1);
            }
            PartyState.setPartyName(settlementKey, renameSlotIndex, newName);
            PartyCommandPatch.logToClient(lastForm, "Party renamed to " + newName);
            if (renameSlotIndex >= 0 && renameSlotIndex < renameButtons.length && renameButtons[renameSlotIndex] != null) {
                renameButtons[renameSlotIndex].setIcon(PartyCommandPatch.lastForm.getInterfaceStyle().container_rename);
                renameButtons[renameSlotIndex].setTooltips(new GameMessage[]{new LocalMessage("ui", "renamebutton")});
            }
            renameSlotIndex = -1;
            renameInput = null;
            lastForm.updateSelectedForm();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void onSavePartyClicked(int slotIndex) {
        if (lastForm == null) {
            return;
        }
        try {
            String settlementKey = PartyCommandPatch.getSettlementKey(lastForm);
            if (PartyState.hasParty(settlementKey, slotIndex)) {
                PartyCommandPatch.showReplaceConfirmUI(slotIndex);
            } else {
                PartyCommandPatch.saveCurrentSelection(lastForm, slotIndex);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onLoadPartyClicked(int slotIndex) {
        if (lastForm == null) {
            return;
        }
        try {
            String settlementKey = PartyCommandPatch.getSettlementKey(lastForm);
            if (!PartyState.hasParty(settlementKey, slotIndex)) {
                System.out.println("[PartyCreator] No party saved in slot " + (slotIndex + 1) + " for " + settlementKey);
                PartyCommandPatch.logToClient(lastForm, "No party saved in this slot");
                return;
            }
            Field containerFormField = SettlementCommandForm.class.getDeclaredField("containerForm");
            containerFormField.setAccessible(true);
            SettlementContainerForm containerForm = (SettlementContainerForm)containerFormField.get(lastForm);
            List<Integer> ids = PartyState.getParty(settlementKey, slotIndex);
            String partyName = PartyState.getPartyName(settlementKey, slotIndex);
            SelectedSettlersHandler selectedSettlersHandler = containerForm.selectedSettlers;
            synchronized (selectedSettlersHandler) {
                containerForm.selectedSettlers.selectSettlers(ids);
            }
            lastForm.updateCurrentForm();
            System.out.println("Selected " + ids.size() + " settlers");
            System.out.println("[PartyCreator] Loaded slot " + (slotIndex + 1) + " with " + ids.size() + " settlers for " + settlementKey);
            PartyCommandPatch.logToClient(lastForm, "Party " + partyName + " loaded.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void onSaveSlot1(FormInputEvent e) {
        PartyCommandPatch.onSavePartyClicked(0);
    }

    public static void onSaveSlot2(FormInputEvent e) {
        PartyCommandPatch.onSavePartyClicked(1);
    }

    public static void onSaveSlot3(FormInputEvent e) {
        PartyCommandPatch.onSavePartyClicked(2);
    }

    public static void onLoadSlot1(FormInputEvent e) {
        PartyCommandPatch.onLoadPartyClicked(0);
    }

    public static void onLoadSlot2(FormInputEvent e) {
        PartyCommandPatch.onLoadPartyClicked(1);
    }

    public static void onLoadSlot3(FormInputEvent e) {
        PartyCommandPatch.onLoadPartyClicked(2);
    }

    public static void onRenameSlot1(FormInputEvent e) {
        PartyCommandPatch.showRenameDialog(0);
    }

    public static void onRenameSlot2(FormInputEvent e) {
        PartyCommandPatch.showRenameDialog(1);
    }

    public static void onRenameSlot3(FormInputEvent e) {
        PartyCommandPatch.showRenameDialog(2);
    }

    public static void onConfirmReplaceClicked(FormInputEvent e) {
        if (lastForm == null || pendingSaveSlot < 0) {
            return;
        }
        try {
            PartyCommandPatch.saveCurrentSelection(lastForm, pendingSaveSlot);
            pendingSaveSlot = -1;
            lastForm.updateSelectedForm();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void onConfirmCancelClicked(FormInputEvent e) {
        if (lastForm == null) {
            return;
        }
        try {
            pendingSaveSlot = -1;
            lastForm.updateSelectedForm();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        patchedNoneForms = new HashSet<Form>();
        pendingSaveSlot = -1;
        renameSlotIndex = -1;
        renameInput = null;
        renameButtons = new FormContentIconButton[3];
    }

    @ModMethodPatch(target=SettlementCommandForm.class, name="updateCurrentForm", arguments={})
    public static class UpdateCurrentFormPatch {
        @Advice.OnMethodExit
        public static void onExit(@Advice.This SettlementCommandForm<?> form) {
            try {
                lastForm = form;
                Field noneSelectedFormField = SettlementCommandForm.class.getDeclaredField("noneSelectedForm");
                noneSelectedFormField.setAccessible(true);
                Form noneSelectedForm = (Form)noneSelectedFormField.get(form);
                if (noneSelectedForm == null) {
                    return;
                }
                if (patchedNoneForms.contains(noneSelectedForm)) {
                    return;
                }
                patchedNoneForms.add(noneSelectedForm);
                int oldHeight = noneSelectedForm.getHeight();
                int x = 4;
                int width = noneSelectedForm.getWidth() - 8;
                int buttonHeight = 24;
                int spacing = 4;
                int rowY = oldHeight + spacing;
                String settlementKey = PartyCommandPatch.getSettlementKey(form);
                int y1 = rowY;
                String name1 = PartyState.getPartyName(settlementKey, 0);
                FormTextButton load1 = new FormTextButton("Load " + name1, x, y1, width, FormInputSize.SIZE_24, ButtonColor.BASE);
                load1.onClicked(PartyCommandPatch::onLoadSlot1);
                noneSelectedForm.addComponent((FormComponent)load1);
                int y2 = rowY + (buttonHeight + spacing);
                String name2 = PartyState.getPartyName(settlementKey, 1);
                FormTextButton load2 = new FormTextButton("Load " + name2, x, y2, width, FormInputSize.SIZE_24, ButtonColor.BASE);
                load2.onClicked(PartyCommandPatch::onLoadSlot2);
                noneSelectedForm.addComponent((FormComponent)load2);
                int y3 = rowY + 2 * (buttonHeight + spacing);
                String name3 = PartyState.getPartyName(settlementKey, 2);
                FormTextButton load3 = new FormTextButton("Load " + name3, x, y3, width, FormInputSize.SIZE_24, ButtonColor.BASE);
                load3.onClicked(PartyCommandPatch::onLoadSlot3);
                noneSelectedForm.addComponent((FormComponent)load3);
                int newHeight = y3 + buttonHeight + spacing;
                noneSelectedForm.setHeight(newHeight);
                ContainerComponent.setPosInventory((Form)noneSelectedForm);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @ModMethodPatch(target=SettlementCommandForm.class, name="updateSelectedForm", arguments={})
    public static class UpdateSelectedFormPatch {
        @Advice.OnMethodExit
        public static void onExit(@Advice.This SettlementCommandForm<?> form) {
            try {
                FormContentIconButton rename3;
                FormContentIconButton rename2;
                FormContentIconButton rename1;
                lastForm = form;
                Field selectedFormField = SettlementCommandForm.class.getDeclaredField("selectedForm");
                selectedFormField.setAccessible(true);
                Form selectedForm = (Form)selectedFormField.get(form);
                if (selectedForm == null) {
                    return;
                }
                int oldHeight = selectedForm.getHeight();
                int x = 4;
                int width = selectedForm.getWidth() - 8;
                int buttonHeight = 24;
                int spacing = 4;
                int rowY = oldHeight + spacing;
                int renameWidth = 24;
                int buttonRowWidth = width - renameWidth - spacing;
                int halfWidth = (buttonRowWidth - spacing) / 2;
                int renameX = x + buttonRowWidth + spacing;
                String settlementKey = PartyCommandPatch.getSettlementKey(form);
                int y1 = rowY;
                String name1 = PartyState.getPartyName(settlementKey, 0);
                FormTextButton save1 = new FormTextButton("Save " + name1, x, y1, halfWidth, FormInputSize.SIZE_24, ButtonColor.BASE);
                save1.onClicked(PartyCommandPatch::onSaveSlot1);
                selectedForm.addComponent((FormComponent)save1);
                FormTextButton load1 = new FormTextButton("Load " + name1, x + halfWidth + spacing, y1, halfWidth, FormInputSize.SIZE_24, ButtonColor.BASE);
                load1.onClicked(PartyCommandPatch::onLoadSlot1);
                selectedForm.addComponent((FormComponent)load1);
                PartyCommandPatch.renameButtons[0] = rename1 = (FormContentIconButton)selectedForm.addComponent((FormComponent)new FormContentIconButton(renameX, y1, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)form.getInterfaceStyle().container_rename, new GameMessage[]{new LocalMessage("ui", "renamebutton")}));
                rename1.onClicked(PartyCommandPatch::onRenameSlot1);
                int y2 = rowY + (buttonHeight + spacing);
                String name2 = PartyState.getPartyName(settlementKey, 1);
                FormTextButton save2 = new FormTextButton("Save " + name2, x, y2, halfWidth, FormInputSize.SIZE_24, ButtonColor.BASE);
                save2.onClicked(PartyCommandPatch::onSaveSlot2);
                selectedForm.addComponent((FormComponent)save2);
                FormTextButton load2 = new FormTextButton("Load " + name2, x + halfWidth + spacing, y2, halfWidth, FormInputSize.SIZE_24, ButtonColor.BASE);
                load2.onClicked(PartyCommandPatch::onLoadSlot2);
                selectedForm.addComponent((FormComponent)load2);
                PartyCommandPatch.renameButtons[1] = rename2 = (FormContentIconButton)selectedForm.addComponent((FormComponent)new FormContentIconButton(renameX, y2, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)form.getInterfaceStyle().container_rename, new GameMessage[]{new LocalMessage("ui", "renamebutton")}));
                rename2.onClicked(PartyCommandPatch::onRenameSlot2);
                int y3 = rowY + 2 * (buttonHeight + spacing);
                String name3 = PartyState.getPartyName(settlementKey, 2);
                FormTextButton save3 = new FormTextButton("Save " + name3, x, y3, halfWidth, FormInputSize.SIZE_24, ButtonColor.BASE);
                save3.onClicked(PartyCommandPatch::onSaveSlot3);
                selectedForm.addComponent((FormComponent)save3);
                FormTextButton load3 = new FormTextButton("Load " + name3, x + halfWidth + spacing, y3, halfWidth, FormInputSize.SIZE_24, ButtonColor.BASE);
                load3.onClicked(PartyCommandPatch::onLoadSlot3);
                selectedForm.addComponent((FormComponent)load3);
                PartyCommandPatch.renameButtons[2] = rename3 = (FormContentIconButton)selectedForm.addComponent((FormComponent)new FormContentIconButton(renameX, y3, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)form.getInterfaceStyle().container_rename, new GameMessage[]{new LocalMessage("ui", "renamebutton")}));
                rename3.onClicked(PartyCommandPatch::onRenameSlot3);
                int newHeight = y3 + buttonHeight + spacing;
                selectedForm.setHeight(newHeight);
                ContainerComponent.setPosInventory((Form)selectedForm);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

