/*
 * Decompiled with CFR 0.152.
 */
package moremounts.mobs;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.stream.Stream;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.registries.ItemRegistry;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.summon.summonFollowingMob.mountFollowingMob.MountFollowingMob;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.level.gameTile.GameTile;
import necesse.level.maps.CollisionFilter;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class SpiderMountMob
extends MountFollowingMob {
    public static GameTexture texture;
    public static GameTexture textureShadow;
    public static GameTexture textureMask;
    public static boolean canHaveSpiders;

    static {
        canHaveSpiders = false;
    }

    public SpiderMountMob() {
        super(100);
        this.setSpeed(80.0f);
        this.setFriction(3.0f);
        this.setSwimSpeed(1.0f);
        this.setKnockbackModifier(0.2f);
        this.collision = new Rectangle(-20, -20, 40, 40);
        this.hitBox = new Rectangle(-30, -25, 60, 50);
        this.selectBox = new Rectangle(-40, -45, 80, 60);
        this.overrideMountedWaterWalking = false;
    }

    private boolean isLiquidTile(int pixelX, int pixelY) {
        Level level = this.getLevel();
        if (level == null) {
            return false;
        }
        int tx = pixelX / 32;
        int ty = pixelY / 32;
        try {
            GameTile tile = level.getTile(tx, ty);
            try {
                return tile.getClass().getField("isLiquid").getBoolean(tile);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                try {
                    Object v = tile.getClass().getMethod("isLiquid", new Class[0]).invoke((Object)tile, new Object[0]);
                    return v instanceof Boolean && (Boolean)v != false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void tickMovement(float delta) {
        int lookY;
        int lookX;
        int y;
        int x;
        boolean onWaterNow;
        if (this.isMounted() && !(onWaterNow = this.isLiquidTile(x = this.getX(), y = this.getY())) && (this.moveX != 0.0f || this.moveY != 0.0f) && this.isLiquidTile(lookX = x + (this.moveX > 0.0f ? 16 : (this.moveX < 0.0f ? -16 : 0)), lookY = y + (this.moveY > 0.0f ? 16 : (this.moveY < 0.0f ? -16 : 0)))) {
            this.moveX = 0.0f;
            this.moveY = 0.0f;
        }
        super.tickMovement(delta);
    }

    public void serverTick() {
        super.serverTick();
        if (!this.isMounted()) {
            this.moveX = 0.0f;
            this.moveY = 0.0f;
        }
        this.clampMovement();
    }

    public void clientTick() {
        super.clientTick();
        if (!this.isMounted()) {
            this.moveX = 0.0f;
            this.moveY = 0.0f;
        }
        this.clampMovement();
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 48;
        int drawY = camera.getDrawY(y) - 60;
        PlayerMob player = (PlayerMob)this.getFollowingMob();
        if (player != null) {
            Point sprite = this.isAccelerating() ? this.getAnimSprite(x, y, player.getDir()) : this.getIdleAnimSprite(x + 70, y, player.getDir());
            if (player.getDir() == 0 || player.getDir() == 2) {
                drawX -= 18;
            }
            TextureDrawOptionsEnd options = texture.initDraw().sprite(sprite.x, sprite.y, 96).light(light).pos(drawX, drawY);
            list.add(new MobDrawable((TextureDrawOptions)options){
                private final /* synthetic */ TextureDrawOptions val$options;
                {
                    this.val$options = textureDrawOptions;
                }

                public void draw(TickManager tickManager) {
                }

                public void drawBehindRider(TickManager tickManager) {
                    this.val$options.draw();
                }
            });
            TextureDrawOptionsEnd shadowOptions = textureShadow.initDraw().sprite(sprite.x, sprite.y, 96).light(light).pos(drawX, drawY);
            tileList.add(tm -> shadowOptions.draw());
        }
    }

    public Point getAnimSprite(int x, int y, int dir) {
        return new Point((int)(this.getWorldEntity().getTime() / (long)this.getRockSpeed()) % 4, dir % 4);
    }

    public Point getIdleAnimSprite(int x, int y, int dir) {
        return new Point((int)(this.getWorldEntity().getTime() / 2000L) % 4, dir % 4);
    }

    public int getRockSpeed() {
        return 100;
    }

    public int getWaterRockSpeed() {
        return 100;
    }

    public CollisionFilter getLevelCollisionFilter() {
        return super.getLevelCollisionFilter().allLiquidTiles();
    }

    public Point getSpriteOffset(int spriteX, int spriteY) {
        Point point = new Point(0, 0);
        if (this.isAccelerating() && (spriteX == 1 || spriteX == 2)) {
            point.y = 2;
        }
        point.x += this.getRiderDrawXOffset();
        point.y += this.getRiderDrawYOffset();
        return point;
    }

    public int getRiderDrawYOffset() {
        PlayerMob player = (PlayerMob)this.getFollowingMob();
        return player != null ? -25 : 0;
    }

    public int getRiderDrawXOffset() {
        PlayerMob player = (PlayerMob)this.getFollowingMob();
        if (player != null) {
            return player.getDir() == 1 ? 18 : -18;
        }
        return 0;
    }

    public int getRiderArmSpriteX() {
        return 1;
    }

    public int getRiderDir(int startDir) {
        return startDir % 4;
    }

    public GameTexture getRiderMask() {
        return textureMask;
    }

    public int getRiderMaskYOffset() {
        return -9;
    }

    public Stream<ModifierValue<?>> getDefaultModifiers() {
        return this.isMounted() ? Stream.of(new ModifierValue(BuffModifiers.SLOW, (Object)Float.valueOf(0.0f)).max((Object)Float.valueOf(0.0f))) : Stream.of(new ModifierValue[0]);
    }

    public Stream<ModifierValue<?>> getDefaultRiderModifiers() {
        PlayerMob following = (PlayerMob)this.getFollowingMob();
        canHaveSpiders = false;
        if (following != null) {
            Item item;
            InventoryItem held = null;
            if (following.getSelectedItem() != null) {
                held = following.getSelectedItem();
            }
            if (held == null && following.attackSlot != null) {
                held = following.attackSlot.getItem(following.getInv());
            }
            if (held != null && held.item != null && (item = held.item) == ItemRegistry.getItem((String)"spiderstaff")) {
                canHaveSpiders = true;
            }
        }
        if (canHaveSpiders) {
            return Stream.of(new ModifierValue(BuffModifiers.MAX_SUMMONS, (Object)10));
        }
        return Stream.of(new ModifierValue(BuffModifiers.MAX_SUMMONS, (Object)0));
    }

    public float getFullInLiquidAtPercent(int x, int y) {
        return super.getFullInLiquidAtPercent(x, y);
    }

    private void clampMovement() {
        float max = 20.0f;
        if (this.moveX > max) {
            this.moveX = max;
        } else if (this.moveX < -max) {
            this.moveX = -max;
        }
        if (this.moveY > max) {
            this.moveY = max;
        } else if (this.moveY < -max) {
            this.moveY = -max;
        }
    }
}

