/*
 * Decompiled with CFR 0.152.
 */
package moremounts.mobs;

import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Stream;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.modifiers.ModifierValue;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.summon.summonFollowingMob.mountFollowingMob.MountFollowingMob;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.gameTile.GameTile;
import necesse.level.maps.CollisionFilter;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class PolarBearMountMob
extends MountFollowingMob {
    public static GameTexture texture;
    public static GameTexture textureShadow;
    private static final int TILE = 128;
    private static final float LAND_SPEED = 75.0f;
    private static final float WATER_MULT = 0.5f;
    private boolean inWaterVisual = false;

    public PolarBearMountMob() {
        super(100);
        this.setSpeed(75.0f);
        this.setFriction(4.0f);
        this.setSwimSpeed(1.0f);
        this.collision = new Rectangle(-20, -20, 40, 40);
        this.hitBox = new Rectangle(-30, -25, 60, 50);
        this.selectBox = new Rectangle(-40, -45, 80, 60);
        this.overrideMountedWaterWalking = true;
    }

    private boolean isOnWaterVisual() {
        return this.inWaterVisual;
    }

    private boolean isOnWaterTile() {
        Method m;
        int ty;
        int tx;
        Level level;
        block21: {
            level = this.getLevel();
            if (level == null) {
                return false;
            }
            tx = this.getX() / 32;
            ty = this.getY() / 32;
            try {
                Object lm = null;
                try {
                    m = level.getClass().getMethod("getLiquidManager", new Class[0]);
                    lm = m.invoke((Object)level, new Object[0]);
                }
                catch (NoSuchMethodException ignored) {
                    try {
                        Field f = level.getClass().getField("liquidManager");
                        lm = f.get(level);
                    }
                    catch (NoSuchFieldException f) {
                        // empty catch block
                    }
                }
                if (lm == null) break block21;
                String[] stringArray = new String[]{"getHeight", "getLiquidHeight", "getLiquidAmount", "getAmount"};
                int n = stringArray.length;
                int f = 0;
                while (f < n) {
                    String name = stringArray[f];
                    try {
                        Method m2 = lm.getClass().getMethod(name, Integer.TYPE, Integer.TYPE);
                        Object out = m2.invoke(lm, tx, ty);
                        if (out instanceof Number) {
                            return ((Number)out).floatValue() > 0.0f;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    ++f;
                }
                try {
                    Method m3 = lm.getClass().getMethod("getLiquid", Integer.TYPE, Integer.TYPE);
                    Object liq = m3.invoke(lm, tx, ty);
                    return liq != null;
                }
                catch (NoSuchMethodException m3) {
                }
            }
            catch (Exception lm) {
                // empty catch block
            }
        }
        try {
            Object v;
            GameTile tile = level.getTile(tx, ty);
            try {
                Field f = tile.getClass().getField("isLiquid");
                v = f.get(tile);
                if (v instanceof Boolean) {
                    return (Boolean)v;
                }
            }
            catch (NoSuchFieldException f) {
                // empty catch block
            }
            try {
                m = tile.getClass().getMethod("isLiquid", new Class[0]);
                v = m.invoke((Object)tile, new Object[0]);
                if (v instanceof Boolean) {
                    return (Boolean)v;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void serverTick() {
        super.serverTick();
        if (!this.isMounted()) {
            this.moveX = 0.0f;
            this.moveY = 0.0f;
        }
        this.applyLandWaterSpeed();
        this.clampMovement();
    }

    public void clientTick() {
        super.clientTick();
        if (!this.isMounted()) {
            this.moveX = 0.0f;
            this.moveY = 0.0f;
        }
        this.applyLandWaterSpeed();
        this.clampMovement();
    }

    private void applyLandWaterSpeed() {
        float target = this.isOnWaterTile() ? 75.0f : 37.5f;
        if (this.getSpeed() != target) {
            this.setSpeed(target);
        }
    }

    public void tickMovement(float delta) {
        super.tickMovement(delta);
        float liq = this.inLiquidFloat();
        this.inWaterVisual = liq > 0.1f;
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 64;
        int drawY = camera.getDrawY(y) - 128 + 36;
        drawY += this.getBobbing(x, y);
        Point sprite = this.getAnimSprite(x, y, this.getDir());
        TextureDrawOptionsEnd options = texture.initDraw().sprite(sprite.x, sprite.y, 128).light(light).pos(drawX, drawY += level.getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
        list.add(new MobDrawable((DrawOptions)options){
            private final /* synthetic */ DrawOptions val$options;
            {
                this.val$options = drawOptions;
            }

            public void draw(TickManager tm) {
            }

            public void drawBehindRider(TickManager tm) {
                this.val$options.draw();
            }
        });
    }

    protected TextureDrawOptions getShadowDrawOptions(Level level, int x, int y, GameLight light, GameCamera camera) {
        int drawX = camera.getDrawX(x) - 64;
        int drawY = camera.getDrawY(y) - 128 + 36;
        drawY += this.getBobbing(x, y);
        int dir = this.getDir();
        int row = dir % 4;
        if (this.isOnWaterVisual()) {
            row += 5;
        }
        return textureShadow.initDraw().sprite(0, row, 128).light(light).pos(drawX, drawY);
    }

    public Point getAnimSprite(int x, int y, int dir) {
        boolean moving = this.isAccelerating() || this.getCurrentSpeed() > 5.0f;
        int frame = moving ? (int)(this.getWorldEntity().getTime() / (long)this.getRockSpeed()) % 4 : 0;
        int row = dir % 4;
        if (this.isOnWaterVisual()) {
            row += 5;
        }
        return new Point(frame, row);
    }

    public int getRockSpeed() {
        return 100;
    }

    public int getWaterRockSpeed() {
        return 100;
    }

    public Point getSpriteOffset(int spriteX, int spriteY) {
        Point p = new Point(0, 0);
        if (this.isAccelerating() && (spriteX == 1 || spriteX == 2)) {
            p.y -= 5;
        }
        if (spriteX == 0 || spriteX == 2) {
            p.x -= 2;
        }
        p.x += this.getRiderDrawXOffset();
        p.y += this.getRiderDrawYOffset() + 5;
        return p;
    }

    public int getRiderDrawYOffset() {
        PlayerMob player = (PlayerMob)this.getFollowingMob();
        return player != null ? -50 : 0;
    }

    public CollisionFilter getLevelCollisionFilter() {
        return super.getLevelCollisionFilter();
    }

    public float getFullInLiquidAtPercent(int x, int y) {
        return super.getFullInLiquidAtPercent(x, y);
    }

    public Stream<ModifierValue<?>> getDefaultRiderModifiers() {
        return Stream.of(new ModifierValue(BuffModifiers.MAX_HEALTH_FLAT, (Object)50), new ModifierValue(BuffModifiers.WATER_WALKING, (Object)true));
    }

    private void clampMovement() {
        float max = 20.0f;
        if (this.moveX > max) {
            this.moveX = max;
        } else if (this.moveX < -max) {
            this.moveX = -max;
        }
        if (this.moveY > max) {
            this.moveY = max;
        } else if (this.moveY < -max) {
            this.moveY = -max;
        }
    }
}

