/*
 * Decompiled with CFR 0.152.
 */
package moremounts.mobs;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.stream.Stream;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.modifiers.ModifierValue;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.summon.summonFollowingMob.mountFollowingMob.MountFollowingMob;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.CollisionFilter;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class CrocodileMountMob
extends MountFollowingMob {
    public static GameTexture texture;

    public CrocodileMountMob() {
        super(100);
        this.setSpeed(50.0f);
        this.setFriction(1.0f);
        this.setSwimSpeed(3.0f);
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-14, -14, 28, 28);
        this.selectBox = new Rectangle(-15, -15, 30, 30);
        this.overrideMountedWaterWalking = true;
    }

    public void serverTick() {
        super.serverTick();
        if (!this.isMounted()) {
            this.moveX = 0.0f;
            this.moveY = 0.0f;
        }
        this.clampMovement();
    }

    public void clientTick() {
        super.clientTick();
        if (!this.isMounted()) {
            this.moveX = 0.0f;
            this.moveY = 0.0f;
        }
        this.clampMovement();
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 64;
        int drawY = camera.getDrawY(y) - 128 + 36;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += this.getBobbing(x, y);
        TextureDrawOptionsEnd options = texture.initDraw().sprite(sprite.x, sprite.y, 128).light(light).pos(drawX - 2, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
        list.add(new MobDrawable((DrawOptions)options){
            private final /* synthetic */ DrawOptions val$options;
            {
                this.val$options = drawOptions;
            }

            public void draw(TickManager tickManager) {
            }

            public void drawBehindRider(TickManager tickManager) {
                this.val$options.draw();
            }
        });
    }

    public Point getSpriteOffset(int spriteX, int spriteY) {
        Point point = new Point(0, 0);
        if (this.isAccelerating() && (spriteX == 1 || spriteX == 2)) {
            point.y = -5;
        }
        point.x += this.getRiderDrawXOffset();
        point.y += this.getRiderDrawYOffset() + 12;
        return point;
    }

    public int getRiderDrawYOffset() {
        PlayerMob player = (PlayerMob)this.getFollowingMob();
        return player != null ? -25 : 0;
    }

    public CollisionFilter getLevelCollisionFilter() {
        return super.getLevelCollisionFilter();
    }

    public float getFullInLiquidAtPercent(int x, int y) {
        return 0.0f;
    }

    public Stream<ModifierValue<?>> getDefaultRiderModifiers() {
        return Stream.of(new ModifierValue(BuffModifiers.WATER_WALKING, (Object)true));
    }

    private void clampMovement() {
        float max = 20.0f;
        if (this.moveX > max) {
            this.moveX = max;
        } else if (this.moveX < -max) {
            this.moveX = -max;
        }
        if (this.moveY > max) {
            this.moveY = max;
        } else if (this.moveY < -max) {
            this.moveY = -max;
        }
    }
}

