/*
 * Decompiled with CFR 0.152.
 */
package moremounts;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import moremounts.items.BatMountItem;
import moremounts.items.CrocodileMountItem;
import moremounts.items.PolarBearMountItem;
import moremounts.items.SpiderMountItem;
import moremounts.mobs.BatMountMob;
import moremounts.mobs.CrocodileMountMob;
import moremounts.mobs.PolarBearMountMob;
import moremounts.mobs.SpiderMountMob;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.mobs.hostile.bosses.CryoQueenMob;
import necesse.entity.mobs.hostile.bosses.EvilsProtectorMob;
import necesse.entity.mobs.hostile.bosses.QueenSpiderMob;
import necesse.entity.mobs.hostile.bosses.SwampGuardianHead;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.item.Item;
import necesse.inventory.lootTable.lootItem.ChanceLootItem;

@ModEntry
public class MountPack {
    private static float MOUNT_DROP_CHANCE = 0.1f;
    public static GameSound toggleNightVisionEffect;

    public void init() {
        System.out.println("[MoreMounts] Loading mount drop config...");
        this.loadConfig();
        System.out.println("[MoreMounts] Drop chance = " + MOUNT_DROP_CHANCE);
        System.out.println("We have more mounts!");
        ItemRegistry.registerItem((String)"batmount", (Item)new BatMountItem(), (float)35000.0f, (boolean)true);
        ItemRegistry.registerItem((String)"spidermount", (Item)new SpiderMountItem(), (float)35000.0f, (boolean)true);
        ItemRegistry.registerItem((String)"crocodilemount", (Item)new CrocodileMountItem(), (float)35000.0f, (boolean)true);
        ItemRegistry.registerItem((String)"polarbearmount", (Item)new PolarBearMountItem(), (float)35000.0f, (boolean)true);
        MobRegistry.registerMob((String)"batmount", BatMountMob.class, (boolean)false);
        MobRegistry.registerMob((String)"spidermount", SpiderMountMob.class, (boolean)false);
        MobRegistry.registerMob((String)"crocodilemount", CrocodileMountMob.class, (boolean)false);
        MobRegistry.registerMob((String)"polarbearmount", PolarBearMountMob.class, (boolean)false);
        EvilsProtectorMob.lootTable.items.add(new ChanceLootItem(MOUNT_DROP_CHANCE, "batmount"));
        QueenSpiderMob.lootTable.items.add(new ChanceLootItem(MOUNT_DROP_CHANCE, "spidermount"));
        SwampGuardianHead.lootTable.items.add(new ChanceLootItem(MOUNT_DROP_CHANCE, "crocodilemount"));
        CryoQueenMob.lootTable.items.add(new ChanceLootItem(MOUNT_DROP_CHANCE, "polarbearmount"));
    }

    public void initResources() {
        toggleNightVisionEffect = GameSound.fromFile((String)"togglenightvision");
        BatMountMob.texture = GameTexture.fromFile((String)"mobs/batmount");
        BatMountMob.textureShadow = GameTexture.fromFile((String)"mobs/batmount_shadow");
        BatMountMob.textureMask = GameTexture.fromFile((String)"mobs/spidermount_mask");
        SpiderMountMob.texture = GameTexture.fromFile((String)"mobs/spidermount");
        SpiderMountMob.textureShadow = GameTexture.fromFile((String)"mobs/spidermount_shadow");
        SpiderMountMob.textureMask = GameTexture.fromFile((String)"mobs/spidermount_mask");
        CrocodileMountMob.texture = GameTexture.fromFile((String)"mobs/crocodilemount");
        PolarBearMountMob.texture = GameTexture.fromFile((String)"mobs/polarbearmount");
        PolarBearMountMob.textureShadow = GameTexture.fromFile((String)"mobs/polarbearmount_shadow");
    }

    private void loadConfig() {
        try {
            Path path = Paths.get("mounts_config.txt", new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                List<String> lines = Arrays.asList("# MoreMounts drop chance config", "# Value from 0.0 to 1.0", "drop_chance=" + MOUNT_DROP_CHANCE);
                Files.write(path, lines, StandardCharsets.UTF_8, new OpenOption[0]);
                System.out.println("[MoreMounts] Config not found, generating default.");
                return;
            }
            List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
            for (String line : lines) {
                if (!(line = line.trim()).startsWith("drop_chance=")) continue;
                String value = line.substring("drop_chance=".length());
                MOUNT_DROP_CHANCE = Float.parseFloat(value);
            }
        }
        catch (Exception e) {
            System.err.println("[MoreMounts] Failed to load config, using default value.");
        }
    }

    public void postInit() {
    }
}

