/*
 * Decompiled with CFR 0.152.
 */
package com.tpmod;

import com.tpmod.RandomTPManager;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketChatMessage;
import necesse.engine.network.packet.PacketPlayerMovement;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.LevelIdentifier;
import necesse.level.maps.regionSystem.RegionPositionGetter;

public class TpManager {
    public RandomTPManager RTP = new RandomTPManager();
    private final Path homesPath = Paths.get("tp_homes.txt", new String[0]);
    private final Map<String, Home> homes = new HashMap<String, Home>();
    private final Map<Integer, TpRequest> pending = new HashMap<Integer, TpRequest>();
    private final Map<Integer, Long> lastTpRequest = new HashMap<Integer, Long>();
    private static final long TPA_COOLDOWN_MS = 60000L;
    private static final long REQ_TIMEOUT_MS = 120000L;

    public TpManager() {
        this.loadHomes();
    }

    void send(ServerClient sc, String msg) {
        try {
            sc.getServer().network.sendPacket((Packet)new PacketChatMessage(msg), sc);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String safeName(ServerClient sc) {
        try {
            String n = sc.getName();
            if (n != null && !n.isEmpty()) {
                return n;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "Player_" + sc.slot;
    }

    private String accountKey(ServerClient sc) {
        try {
            if (sc.getName() != null && !sc.getName().isEmpty()) {
                return sc.getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "slot_" + sc.slot;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadHomes() {
        if (!Files.exists(this.homesPath, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader br = Files.newBufferedReader(this.homesPath, StandardCharsets.UTF_8);){
                while (true) {
                    int y;
                    int x;
                    String[] a;
                    String line;
                    if ((line = br.readLine()) == null) {
                        return;
                    }
                    if ((line = line.trim()).isEmpty() || line.startsWith("#") || (a = line.split(";", -1)).length < 4) continue;
                    String name = a[0];
                    String level = a[1];
                    try {
                        x = Integer.parseInt(a[2]);
                        y = Integer.parseInt(a[3]);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    this.homes.put(name, new Home(level, x, y));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("[TP] Error loading homes: " + String.valueOf(e));
        }
    }

    private void saveHomes() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(this.homesPath, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                bw.write("# player;level;x;y\n");
                for (Map.Entry<String, Home> e : this.homes.entrySet()) {
                    Home h = e.getValue();
                    bw.write(e.getKey() + ";" + h.levelId + ";" + h.x + ";" + h.y);
                    bw.newLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("[TP] Error saving homes: " + String.valueOf(e));
        }
    }

    public void setHome(Server server, ServerClient sc) {
        if (sc == null || sc.playerMob == null) {
            return;
        }
        String key = this.accountKey(sc);
        String level = sc.getLevelIdentifier().toString();
        int x = sc.playerMob.getX();
        int y = sc.playerMob.getY();
        this.homes.put(key, new Home(level, x, y));
        this.saveHomes();
        this.send(sc, "[TP] Home set!");
    }

    public void goHome(Server server, ServerClient sc) {
        if (sc == null || sc.playerMob == null) {
            return;
        }
        String key = this.accountKey(sc);
        Home h = this.homes.get(key);
        if (h == null) {
            this.send(sc, "[TP] No home set!");
            return;
        }
        try {
            LevelIdentifier destId = new LevelIdentifier(h.levelId);
            sc.playerMob.dx = 0.0f;
            sc.playerMob.dy = 0.0f;
            if (sc.isSamePlace(destId)) {
                sc.playerMob.setPos((float)h.x, (float)h.y, true);
                server.network.sendToClientsWithEntity((Packet)new PacketPlayerMovement(sc, true), (RegionPositionGetter)sc.playerMob);
            } else {
                sc.changeLevel(destId, lvl -> new Point(home.x, home.y), true);
            }
            this.send(sc, "[TP] Teleported to home.");
        }
        catch (Throwable t) {
            this.send(sc, "[TP] Home level not found.");
        }
    }

    public void requestTp(Server server, ServerClient from, String targetNameArg) {
        long last;
        if (from == null || from.playerMob == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - (last = this.lastTpRequest.getOrDefault(from.slot, 0L).longValue()) < 60000L) {
            long sec = (60000L - (now - last)) / 1000L;
            this.send(from, "[TP] Wait " + sec + "s before sending another request.");
            return;
        }
        ServerClient target = this.findClientByName(server, targetNameArg);
        if (target == null || target.playerMob == null) {
            this.send(from, "[TP] Player not found.");
            return;
        }
        if (target.slot == from.slot) {
            this.send(from, "[TP] Cannot send request to yourself.");
            return;
        }
        this.pending.put(target.slot, new TpRequest(from.slot, target.slot, now));
        this.lastTpRequest.put(from.slot, now);
        this.send(from, "[TP] Request sent to " + this.safeName(target));
        this.send(target, "[TP] " + this.safeName(from) + " wants to teleport to you. /tpa tpaccept or /tpa tpdeny");
    }

    public void acceptTp(Server server, ServerClient target) {
        if (target == null || target.playerMob == null) {
            return;
        }
        TpRequest req = this.pending.get(target.slot);
        if (req == null) {
            this.send(target, "[TP] No pending request.");
            return;
        }
        long now = System.currentTimeMillis();
        if (now - req.time > 120000L) {
            this.pending.remove(target.slot);
            this.send(target, "[TP] Request expired.");
            return;
        }
        ServerClient from = server.getClient(req.fromSlot);
        if (from == null || from.playerMob == null) {
            this.pending.remove(target.slot);
            this.send(target, "[TP] Player left the game.");
            return;
        }
        try {
            LevelIdentifier destId = target.getLevelIdentifier();
            int x = target.playerMob.getX();
            int y = target.playerMob.getY();
            from.playerMob.dx = 0.0f;
            from.playerMob.dy = 0.0f;
            if (from.isSamePlace(destId)) {
                from.playerMob.setPos((float)x, (float)y, true);
                server.network.sendToClientsWithEntity((Packet)new PacketPlayerMovement(from, true), (RegionPositionGetter)from.playerMob);
            } else {
                from.changeLevel(destId, lvl -> new Point(x, y), true);
            }
            this.send(from, "[TP] Teleported to " + this.safeName(target));
            this.send(target, "[TP] Request accepted.");
        }
        finally {
            this.pending.remove(target.slot);
        }
    }

    public void denyTp(ServerClient target) {
        if (target == null) {
            return;
        }
        TpRequest req = this.pending.remove(target.slot);
        if (req == null) {
            this.send(target, "[TP] No pending request.");
            return;
        }
        this.send(target, "[TP] Request denied.");
    }

    public void adminTpTo(Server server, ServerClient admin, String targetNameArg) {
        if (server == null || admin == null || admin.playerMob == null) {
            return;
        }
        if (targetNameArg == null || targetNameArg.trim().isEmpty()) {
            return;
        }
        ServerClient target = this.findClientByName(server, targetNameArg);
        if (target == null || target.playerMob == null) {
            return;
        }
        if (target.slot == admin.slot) {
            return;
        }
        try {
            LevelIdentifier destId = target.getLevelIdentifier();
            int x = target.playerMob.getX();
            int y = target.playerMob.getY();
            admin.playerMob.dx = 0.0f;
            admin.playerMob.dy = 0.0f;
            if (admin.isSamePlace(destId)) {
                admin.playerMob.setPos((float)x, (float)y, true);
                server.network.sendToClientsWithEntity((Packet)new PacketPlayerMovement(admin, true), (RegionPositionGetter)admin.playerMob);
            } else {
                admin.changeLevel(destId, lvl -> new Point(x, y), true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private ServerClient findClientByName(Server server, String name) {
        String lower = name.toLowerCase(Locale.ROOT);
        for (ServerClient c : server.getClients()) {
            String cn;
            if (c == null || !(cn = this.safeName(c).toLowerCase(Locale.ROOT)).equals(lower) && !cn.contains(lower)) continue;
            return c;
        }
        return null;
    }

    private static class Home {
        String levelId;
        int x;
        int y;

        Home(String levelId, int x, int y) {
            this.levelId = levelId;
            this.x = x;
            this.y = y;
        }
    }

    private static class TpRequest {
        int fromSlot;
        int toSlot;
        long time;

        TpRequest(int fromSlot, int toSlot, long time) {
            this.fromSlot = fromSlot;
            this.toSlot = toSlot;
            this.time = time;
        }
    }
}

