/*
 * Decompiled with CFR 0.152.
 */
package com.tpmod;

import com.tpmod.TpMod;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import necesse.engine.commands.AutoComplete;
import necesse.engine.commands.ChatCommand;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.CommandsManager;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.LevelIdentifier;

public class TpCommand
extends ChatCommand {
    private static final String RAID_LEVEL_ID_CONTAINS = "raid-arena-evils";
    private static final File SPAWN_FILE = new File("tpmod_spawn.txt");

    public TpCommand() {
        super("tpa", PermissionLevel.USER);
    }

    public static void register() {
        CommandsManager.registerServerCommand((ChatCommand)new TpCommand());
    }

    public boolean isCheat() {
        return false;
    }

    public String getUsage() {
        return "<sethome|home|tpto <player>|tpaccept|tpdeny|random|spawn|setspawn>";
    }

    public String getAction() {
        return "Teleport requests, home system, random teleport, and spawn teleport";
    }

    public String getCurrentUsage(Client c, Server s, ServerClient sc, String[] args) {
        return "Usage: /tpa sethome | /tpa home | /tpa tpto <player> | /tpa tpaccept | /tpa tpdeny | /tpa random | /tpa spawn | /tpa setspawn";
    }

    public List<AutoComplete> autocomplete(Client c, Server s, ServerClient sc, String[] args) {
        return Collections.emptyList();
    }

    private boolean isInRaid(ServerClient sc) {
        if (sc == null) {
            return false;
        }
        try {
            String lvl = sc.getLevelIdentifier().toString();
            return lvl != null && lvl.contains(RAID_LEVEL_ID_CONTAINS);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private ServerClient findClientByName(Server server, String name) {
        if (server == null || name == null) {
            return null;
        }
        String lower = name.toLowerCase();
        for (ServerClient c : server.getClients()) {
            String cn;
            if (c == null || (cn = c.getName()) == null || !(cn = cn.toLowerCase()).equals(lower) && !cn.contains(lower)) continue;
            return c;
        }
        return null;
    }

    private boolean isAdmin(ServerClient sc) {
        Object pl;
        if (sc == null) {
            return false;
        }
        try {
            pl = sc.getClass().getMethod("getPermissionLevel", new Class[0]).invoke((Object)sc, new Object[0]);
            if (pl != null) {
                String n = pl.toString().toUpperCase();
                return n.contains("ADMIN") || n.contains("OWNER");
            }
        }
        catch (Throwable pl2) {
            // empty catch block
        }
        try {
            pl = sc.getClass().getField("permissionLevel").get(sc);
            if (pl != null) {
                String n = pl.toString().toUpperCase();
                return n.contains("ADMIN") || n.contains("OWNER");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private synchronized SpawnData loadSpawn() {
        if (!SPAWN_FILE.exists()) {
            return null;
        }
        SpawnData d = new SpawnData();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(SPAWN_FILE));){
                String line;
                while ((line = br.readLine()) != null) {
                    int eq;
                    if ((line = line.trim()).isEmpty() || (eq = line.indexOf(61)) <= 0) continue;
                    String k = line.substring(0, eq).trim();
                    String v = line.substring(eq + 1).trim();
                    if (k.equalsIgnoreCase("level")) {
                        d.levelId = v;
                        continue;
                    }
                    if (k.equalsIgnoreCase("x")) {
                        d.x = Integer.parseInt(v);
                        continue;
                    }
                    if (!k.equalsIgnoreCase("y")) continue;
                    d.y = Integer.parseInt(v);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable ignored) {
            return null;
        }
        if (d.levelId == null || d.levelId.isEmpty()) {
            return null;
        }
        return d;
    }

    private synchronized boolean saveSpawn(String levelId, int x, int y) {
        block12: {
            Throwable throwable = null;
            Object var5_7 = null;
            BufferedWriter bw = new BufferedWriter(new FileWriter(SPAWN_FILE, false));
            try {
                bw.write("level=" + levelId);
                bw.newLine();
                bw.write("x=" + x);
                bw.newLine();
                bw.write("y=" + y);
                bw.newLine();
                if (bw == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable ignored) {
                    return false;
                }
            }
            bw.close();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(Client client, Server server, ServerClient sc, ArrayList<String> args, CommandLog log) {
        if (sc == null) {
            log.add("Server-only command.");
            return false;
        }
        if (args.isEmpty()) {
            TpMod.TP.send(sc, this.getCurrentUsage(client, server, sc, new String[0]));
            return false;
        }
        String sub = args.get(0).toLowerCase();
        if (this.isInRaid(sc) && !sub.equals("home") && !sub.equals("spawn")) {
            TpMod.TP.send(sc, "[TP] Only /tpa home and /tpa spawn are allowed during raids.");
            return false;
        }
        switch (sub) {
            case "sethome": {
                TpMod.TP.setHome(server, sc);
                return true;
            }
            case "home": {
                TpMod.TP.goHome(server, sc);
                return true;
            }
            case "tpto": {
                if (args.size() < 2) {
                    TpMod.TP.send(sc, "[TP] Usage: /tpa tpto <player>");
                    return false;
                }
                String targetName = args.get(1);
                ServerClient target = this.findClientByName(server, targetName);
                if (target != null && this.isInRaid(target)) {
                    TpMod.TP.send(sc, "[TP] You cannot teleport to a player who is in a raid.");
                    return false;
                }
                TpMod.TP.requestTp(server, sc, targetName);
                return true;
            }
            case "tpaccept": {
                if (this.isInRaid(sc)) {
                    TpMod.TP.send(sc, "[TP] You cannot accept teleport requests during raids.");
                    return false;
                }
                TpMod.TP.acceptTp(server, sc);
                return true;
            }
            case "tpdeny": {
                TpMod.TP.denyTp(sc);
                return true;
            }
            case "random": {
                TpMod.TP.RTP.randomTeleport(server, sc);
                return true;
            }
            case "setspawn": {
                if (!this.isAdmin(sc)) {
                    TpMod.TP.send(sc, "[TP] You do not have permission to use /tpa setspawn.");
                    return false;
                }
                try {
                    String levelId = sc.getLevelIdentifier().toString();
                    int x = sc.playerMob.getX();
                    int y = sc.playerMob.getY();
                    if (this.saveSpawn(levelId, x, y)) {
                        TpMod.TP.send(sc, "[TP] Spawn set: " + levelId + " @ " + x + "," + y);
                        return true;
                    }
                    TpMod.TP.send(sc, "[TP] Failed to save spawn (tpmod_spawn.txt).");
                    return false;
                }
                catch (Throwable t) {
                    TpMod.TP.send(sc, "[TP] Failed to set spawn: " + String.valueOf(t));
                    return false;
                }
            }
            case "spawn": {
                SpawnData d = this.loadSpawn();
                if (d == null) {
                    TpMod.TP.send(sc, "[TP] Spawn is not set. Ask admin to use /tpa setspawn.");
                    return false;
                }
                try {
                    LevelIdentifier dest = new LevelIdentifier(d.levelId);
                    sc.changeLevel(dest, lvl -> new Point(spawnData.x, spawnData.y), true);
                    TpMod.TP.send(sc, "[TP] Teleporting to spawn...");
                    return true;
                }
                catch (Throwable t) {
                    TpMod.TP.send(sc, "[TP] Failed to teleport to spawn: " + String.valueOf(t));
                    return false;
                }
            }
        }
        TpMod.TP.send(sc, this.getCurrentUsage(client, server, sc, new String[0]));
        return false;
    }

    private static class SpawnData {
        String levelId;
        int x;
        int y;

        private SpawnData() {
        }
    }
}

