/*
 * Decompiled with CFR 0.152.
 */
package com.tpmod;

import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketChatMessage;
import necesse.engine.network.packet.PacketPlayerMovement;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.entity.mobs.PlayerMob;
import necesse.level.maps.Level;
import necesse.level.maps.regionSystem.RegionPositionGetter;

public class RandomTPManager {
    private static final int MIN_DISTANCE_TILES = 1000;
    private static final int MAX_DISTANCE_TILES = 5000;
    private static final long COOLDOWN = 60000L;
    private final Map<Integer, Long> lastUse = new HashMap<Integer, Long>();
    private final Random random = new Random();

    public void send(ServerClient sc, String msg) {
        try {
            sc.getServer().network.sendPacket((Packet)new PacketChatMessage(msg), sc);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean canUse(ServerClient sc) {
        long last;
        long now = System.currentTimeMillis();
        if (now - (last = this.lastUse.getOrDefault(sc.slot, 0L).longValue()) < 60000L) {
            long sec = (60000L - (now - last)) / 1000L;
            this.send(sc, "[TP] Wait " + sec + "s before using random teleport again.");
            return false;
        }
        this.lastUse.put(sc.slot, now);
        return true;
    }

    public void randomTeleport(Server server, ServerClient sc) {
        if (sc == null || sc.playerMob == null) {
            return;
        }
        if (!this.canUse(sc)) {
            return;
        }
        PlayerMob player = sc.playerMob;
        Level level = player.getLevel();
        this.send(sc, "[TP] Searching for land...");
        int originTileX = player.getX() / 32;
        int originTileY = player.getY() / 32;
        int i = 0;
        while (i < 50) {
            Point tilePos = this.getRandomTile(originTileX, originTileY);
            if (this.isSafe(level, tilePos.x, tilePos.y)) {
                this.teleport(server, sc, tilePos.x, tilePos.y);
                this.send(sc, "[TP] Teleported to safe land!");
                return;
            }
            ++i;
        }
        this.send(sc, "[TP] Could not find safe ground. Try again.");
    }

    private Point getRandomTile(int originTileX, int originTileY) {
        int dist = 1000 + this.random.nextInt(4001);
        double angle = this.random.nextDouble() * Math.PI * 2.0;
        int x = originTileX + (int)(Math.cos(angle) * (double)dist);
        int y = originTileY + (int)(Math.sin(angle) * (double)dist);
        return new Point(x, y);
    }

    private boolean isSafe(Level level, int tileX, int tileY) {
        block5: {
            block4: {
                try {
                    if (!level.isSolidTile(tileX, tileY)) break block4;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (!level.isLiquidTile(tileX, tileY)) break block5;
            return false;
        }
        return !level.isProtected(tileX, tileY);
    }

    private void teleport(Server server, ServerClient sc, int tileX, int tileY) {
        try {
            int px = tileX * 32 + 16;
            int py = tileY * 32 + 16;
            sc.playerMob.dx = 0.0f;
            sc.playerMob.dy = 0.0f;
            sc.playerMob.setPos((float)px, (float)py, true);
            server.network.sendToClientsWithEntity((Packet)new PacketPlayerMovement(sc, true), (RegionPositionGetter)sc.playerMob);
        }
        catch (Throwable t) {
            this.send(sc, "[TP] Error teleporting.");
        }
    }
}

