/*
 * Decompiled with CFR 0.152.
 */
package com.xp.patches;

import com.xp.XpMod;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.server.ServerClient;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=Mob.class, name="onDeath", arguments={Attacker.class, HashSet.class})
public class XpMobDeathPatch {
    private static final boolean DEBUG = false;

    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void onEnter(@Advice.This Object mob, @Advice.Argument(value=0) Object attacker, @Advice.Argument(value=1) HashSet<?> attackers) {
        boolean isFriendlyNonHumanNonCritter;
        if (mob == null) {
            return;
        }
        if (XpMobDeathPatch.isInstance(mob, "necesse.entity.mobs.player.PlayerMob")) {
            return;
        }
        if (XpMobDeathPatch.isInstance(mob, "necesse.entity.mobs.friendly.human.HumanMob")) {
            return;
        }
        ServerClient sc = XpMobDeathPatch.extractServerClient(attacker);
        if (sc == null) {
            sc = XpMobDeathPatch.extractServerClientFromAttackers(attackers);
        }
        if (sc == null) {
            return;
        }
        String mobName = XpMobDeathPatch.safeStringId(mob);
        String mobKey = mobName == null ? "" : mobName.trim().toLowerCase(Locale.ROOT);
        boolean bl = isFriendlyNonHumanNonCritter = XpMobDeathPatch.isInstance(mob, "necesse.entity.mobs.friendly.FriendlyMob") && !XpMobDeathPatch.isInstance(mob, "necesse.entity.mobs.friendly.human.HumanMob") && !XpMobDeathPatch.isInstance(mob, "necesse.entity.mobs.friendly.critters.CritterMob");
        if (isFriendlyNonHumanNonCritter) {
            XpMod.XP.onFriendlyKilled(sc, mobKey);
            return;
        }
        XpMod.XP.onHostileKilled(sc, mobKey);
    }

    public static ServerClient extractServerClient(Object atkObj) {
        ServerClient sc;
        Object m;
        Object sc2;
        if (atkObj == null) {
            return null;
        }
        try {
            Object pm = atkObj.getClass().getMethod("getFirstPlayerOwner", new Class[0]).invoke(atkObj, new Object[0]);
            if (pm != null && (sc2 = pm.getClass().getMethod("getServerClient", new Class[0]).invoke(pm, new Object[0])) instanceof ServerClient) {
                return sc2;
            }
        }
        catch (Throwable pm) {
            // empty catch block
        }
        try {
            Object owner = atkObj.getClass().getMethod("getAttackOwner", new Class[0]).invoke(atkObj, new Object[0]);
            sc2 = XpMobDeathPatch.resolveServerClientFromMobChain(owner, 6);
            if (sc2 != null) {
                return sc2;
            }
        }
        catch (Throwable owner) {
            // empty catch block
        }
        try {
            Method gm = atkObj.getClass().getMethod("getMob", new Class[0]);
            m = gm.invoke(atkObj, new Object[0]);
            sc = XpMobDeathPatch.resolveServerClientFromMobChain(m, 6);
            if (sc != null) {
                return sc;
            }
        }
        catch (Throwable gm) {
            // empty catch block
        }
        try {
            Method go = atkObj.getClass().getMethod("getOwner", new Class[0]);
            m = go.invoke(atkObj, new Object[0]);
            sc = XpMobDeathPatch.resolveServerClientFromMobChain(m, 6);
            if (sc != null) {
                return sc;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static ServerClient extractServerClientFromAttackers(Set<?> set) {
        if (set == null) {
            return null;
        }
        for (Object a : set) {
            ServerClient sc = XpMobDeathPatch.extractServerClient(a);
            if (sc == null) continue;
            return sc;
        }
        return null;
    }

    public static ServerClient resolveServerClientFromMobChain(Object mob, int depth) {
        String[] chain;
        if (mob == null || depth <= 0) {
            return null;
        }
        try {
            Object sc = mob.getClass().getMethod("getServerClient", new Class[0]).invoke(mob, new Object[0]);
            if (sc instanceof ServerClient) {
                return (ServerClient)sc;
            }
        }
        catch (Throwable sc) {
            // empty catch block
        }
        String[] stringArray = chain = new String[]{"getFirstAttackOwner", "getAttackOwner", "getOwner"};
        int n = chain.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            try {
                Object next = mob.getClass().getMethod(m, new Class[0]).invoke(mob, new Object[0]);
                ServerClient sc = XpMobDeathPatch.resolveServerClientFromMobChain(next, depth - 1);
                if (sc != null) {
                    return sc;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    public static boolean isInstance(Object o, String fqcn) {
        try {
            return Class.forName(fqcn).isInstance(o);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String safeStringId(Object mob) {
        try {
            return String.valueOf(mob.getClass().getMethod("getStringID", new Class[0]).invoke(mob, new Object[0]));
        }
        catch (Throwable ignore) {
            return mob.getClass().getName();
        }
    }
}

