/*
 * Decompiled with CFR 0.152.
 */
package com.xp;

import com.xp.XpMod;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import necesse.engine.events.players.ObjectDamageEvent;
import necesse.engine.network.server.ServerClient;
import necesse.level.gameObject.GameObject;
import necesse.level.maps.Level;

public final class XpTreeHooks {
    private static final Map<String, Boolean> wasTreeAtHit = new ConcurrentHashMap<String, Boolean>();
    private static final Set<String> TREE_KW = new HashSet<String>(Arrays.asList("tree", "bamboo", "birch", "cavebirch", "cavemaple", "deadwood", "dryad", "maple", "oak", "palm", "pine", "spruce", "apple", "banana", "coconut", "lemon"));

    private XpTreeHooks() {
    }

    public static void onObjectDamage(ObjectDamageEvent e) {
        try {
            ServerClient sc = e.client;
            Level level = e.level;
            int tx = e.tileX;
            int ty = e.tileY;
            GameObject before = XpTreeHooks.safeGetObject(level, tx, ty);
            boolean wasTree = XpTreeHooks.looksLikeTree(before);
            wasTreeAtHit.put(XpTreeHooks.key(level, tx, ty), wasTree);
            XpMod.XP.runLater(() -> {
                try {
                    Boolean remembered = wasTreeAtHit.remove(XpTreeHooks.key(level, tx, ty));
                    if (remembered == null || !remembered.booleanValue()) {
                        return;
                    }
                    GameObject now = XpTreeHooks.safeGetObject(level, tx, ty);
                    if (!XpTreeHooks.looksLikeTree(now) && XpMod.XP.markIfNotRecentlyCounted(level, tx, ty, 3500L)) {
                        XpMod.XP.onTreeChopped(sc);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, 2000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String key(Level level, int x, int y) {
        try {
            return String.valueOf(level.getIdentifier()) + ":" + x + ":" + y;
        }
        catch (Throwable t) {
            return "L:" + x + ":" + y;
        }
    }

    private static boolean containsAnyKeyword(String s, Set<String> kws) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        String n = s.toLowerCase().replace(" ", "").replace("_", "").replace("-", "");
        for (String k : kws) {
            if (!n.contains(k)) continue;
            return true;
        }
        return false;
    }

    static boolean looksLikeTree(GameObject obj) {
        if (obj == null) {
            return false;
        }
        try {
            if (XpTreeHooks.containsAnyKeyword(obj.getClass().getSimpleName(), TREE_KW)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Method m = obj.getClass().getMethod("getStringID", new Class[0]);
            Object id = m.invoke((Object)obj, new Object[0]);
            if (id instanceof String) {
                String s = (String)id;
                return XpTreeHooks.containsAnyKeyword(s, TREE_KW);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    static GameObject safeGetObject(Level level, int x, int y) {
        try {
            return level.getObject(x, y);
        }
        catch (Throwable t) {
            try {
                return (GameObject)Level.class.getMethod("getObject", Integer.TYPE, Integer.TYPE).invoke((Object)level, x, y);
            }
            catch (Throwable ignore) {
                return null;
            }
        }
    }
}

