/*
 * Decompiled with CFR 0.152.
 */
package com.xp;

import com.xp.PacketXpTopRequest;
import com.xp.PacketXpTopResponse;
import com.xp.XpGuiForm;
import com.xp.XpMod;
import java.util.ArrayList;
import java.util.List;
import necesse.engine.network.Packet;
import necesse.engine.network.client.Client;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormLabel;
import necesse.gfx.forms.components.FormTextButton;
import necesse.gfx.gameFont.FontOptions;

public class XpTopForm
extends Form {
    public static XpTopForm INSTANCE;
    private final Client client;
    private final XpGuiForm parent;
    private FormLabel noteLabel;
    private final List<FormLabel> rowLabels = new ArrayList<FormLabel>();

    public XpTopForm(Client client, XpGuiForm parent) {
        super("xpTopForm", 420, 320);
        this.client = client;
        this.parent = parent;
        INSTANCE = this;
        FontOptions titleFont = new FontOptions(20);
        FontOptions rowFont = new FontOptions(14);
        this.addComponent((FormComponent)new FormLabel("XP Top 10", titleFont, -1, 16, 16));
        this.noteLabel = (FormLabel)this.addComponent((FormComponent)new FormLabel("Loading Top 10 from server...", rowFont, -1, 16, 48));
        int startY = 72;
        int i = 0;
        while (i < 10) {
            FormLabel row = (FormLabel)this.addComponent((FormComponent)new FormLabel("", rowFont, -1, 16, startY + i * 18));
            this.rowLabels.add(row);
            ++i;
        }
        FormTextButton backBtn = (FormTextButton)this.addComponent((FormComponent)new FormTextButton("Back", 16, startY + 180 + 16, 100));
        backBtn.onClicked(e -> {
            this.setHidden(true);
            if (parent != null) {
                parent.setHidden(false);
            }
        });
        FormTextButton closeBtn = (FormTextButton)this.addComponent((FormComponent)new FormTextButton("X", this.getWidth() - 26, 6, 20));
        closeBtn.onClicked(e -> {
            this.setHidden(true);
            if (parent != null) {
                parent.setHidden(false);
            }
        });
    }

    public void requestTop10() {
        if (this.noteLabel != null) {
            this.noteLabel.setText("Loading Top 10 from server...");
        }
        if (this.client == null) {
            return;
        }
        try {
            this.client.network.sendPacket((Packet)new PacketXpTopRequest(10));
        }
        catch (Throwable t) {
            System.out.println("[XpMod] Failed to request XP top10: " + String.valueOf(t));
        }
    }

    public void applyTopEntries(List<PacketXpTopResponse.Entry> entries) {
        if (this.noteLabel != null) {
            if (entries == null || entries.isEmpty()) {
                this.noteLabel.setText("No XP data received from server.");
            } else {
                this.noteLabel.setText("XP leaderboard:");
            }
        }
        int i = 0;
        while (i < this.rowLabels.size()) {
            FormLabel row = this.rowLabels.get(i);
            if (entries != null && i < entries.size()) {
                PacketXpTopResponse.Entry e = entries.get(i);
                String rankName = e.rankName != null && !e.rankName.isEmpty() ? e.rankName : XpMod.getRankForXp(e.xp);
                row.setText(String.format("%d. %s - %s - %d XP", i + 1, e.name, rankName, e.xp));
            } else {
                row.setText("");
            }
            ++i;
        }
    }
}

