/*
 * Decompiled with CFR 0.152.
 */
package com.xp;

import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;

public class XpSkillBuff
extends Buff {
    public static final String STRING_ID = "xp_skill_buff";

    public XpSkillBuff() {
        this.isVisible = false;
        this.isImportant = true;
        this.canCancel = false;
        this.shouldSave = true;
    }

    public void init(ActiveBuff buff, BuffEventSubscriber subscriber) {
        try {
            int hp = buff.getGndData().getInt("xp_hp", 0);
            int mana = buff.getGndData().getInt("xp_mana", 0);
            int speed = buff.getGndData().getInt("xp_speed", 0);
            int crit = buff.getGndData().getInt("xp_crit", 0);
            int dmg = buff.getGndData().getInt("xp_dmg", 0);
            int armor = buff.getGndData().getInt("xp_armor", 0);
            int resil = buff.getGndData().getInt("xp_resil", 0);
            if (hp > 0) {
                int hpBonus = hp * 10;
                buff.setModifier(BuffModifiers.MAX_HEALTH_FLAT, (Object)hpBonus);
            }
            if (mana > 0) {
                float manaBonus = (float)mana * 0.02f;
                buff.setModifier(BuffModifiers.MAX_MANA, (Object)Float.valueOf(manaBonus));
            }
            if (speed > 0) {
                float speedBonus = (float)speed * 0.02f;
                buff.setModifier(BuffModifiers.SPEED, (Object)Float.valueOf(speedBonus));
            }
            if (crit > 0) {
                float critBonus = (float)crit * 0.01f;
                buff.setModifier(BuffModifiers.CRIT_CHANCE, (Object)Float.valueOf(critBonus));
            }
            if (dmg > 0) {
                float dmgBonus = (float)dmg * 0.01f;
                buff.setModifier(BuffModifiers.ALL_DAMAGE, (Object)Float.valueOf(dmgBonus));
            }
            if (armor > 0) {
                buff.setModifier(BuffModifiers.ARMOR_FLAT, (Object)armor);
            }
            if (resil > 0) {
                float resilBonus = (float)resil * 0.01f;
                buff.setModifier(BuffModifiers.MAX_RESILIENCE, (Object)Float.valueOf(resilBonus));
            }
        }
        catch (Exception e) {
            System.out.println("[XpMod] Error in XpSkillBuff.init: " + String.valueOf(e));
        }
    }
}

