/*
 * Decompiled with CFR 0.152.
 */
package com.xp;

import com.xp.EternalChatColorMod;
import com.xp.JobsCompat;
import com.xp.PacketXpSelfStats;
import com.xp.PacketXpTopRequest;
import com.xp.PacketXpTopResponse;
import com.xp.XpBannerConfig;
import com.xp.XpCommand;
import com.xp.XpJobBonusConfig;
import com.xp.XpManager;
import com.xp.XpOreHooks;
import com.xp.XpSkillBuff;
import com.xp.XpTreeHooks;
import necesse.engine.GameEventInterface;
import necesse.engine.GameEventListener;
import necesse.engine.GameEvents;
import necesse.engine.commands.ChatCommand;
import necesse.engine.commands.CommandsManager;
import necesse.engine.events.players.ObjectDamageEvent;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.PacketRegistry;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.objectEntity.BannerOfWarObjectEntity;

@ModEntry
public class XpMod {
    public static final XpManager XP = new XpManager();
    public static XpBannerConfig BANNER_CFG;
    public static final XpJobBonusConfig JOB_BONUS_CFG;

    static {
        JOB_BONUS_CFG = new XpJobBonusConfig();
    }

    public static String getRankForXp(int xp) {
        if (xp < 0) {
            xp = 0;
        }
        return XP.getRankNameForXp(xp);
    }

    public static String getJobBonusText(ServerClient sc) {
        if (sc == null) {
            return "";
        }
        JOB_BONUS_CFG.reloadIfChanged();
        String[] jobs = new String[]{"WOODCUTTER", "MINER", "HUNTER", "SLAYER", "FISHER"};
        String[] actions = new String[]{"TREE", "ORE", "FRIENDLY_KILL", "HOSTILE_KILL", "FISH"};
        int i = 0;
        while (i < jobs.length) {
            block22: {
                int rank = JobsCompat.getRankIfJobMatches(sc, jobs[i]);
                if (rank <= 0) break block22;
                int perRank = JOB_BONUS_CFG.getPerRank(jobs[i], actions[i]);
                if (perRank <= 0) {
                    return "";
                }
                int bonus = rank * perRank;
                String nice = switch (jobs[i]) {
                    case "WOODCUTTER" -> "Woodcutter";
                    case "MINER" -> "Miner";
                    case "HUNTER" -> "Hunter";
                    case "SLAYER" -> "Slayer";
                    case "FISHER" -> "Fisher";
                    default -> jobs[i];
                };
                return "You have XP bonus from " + nice + " job: +" + bonus;
            }
            ++i;
        }
        return "";
    }

    public void init() {
        System.out.println("[XpMod] init() start");
        try {
            BANNER_CFG = new XpBannerConfig();
            BannerOfWarObjectEntity.BANNER_SPAWN_RATE_MODIFIER = BANNER_CFG.getSpawnRate();
            BannerOfWarObjectEntity.BANNER_SPAWN_CAP_MODIFIER = BANNER_CFG.getSpawnCap();
            System.out.println("[XpMod] Banner of War config applied: rate=" + BANNER_CFG.getSpawnRate() + " cap=" + BANNER_CFG.getSpawnCap());
        }
        catch (Throwable t) {
            System.out.println("[XpMod] Failed to apply Banner of War config: " + String.valueOf(t));
        }
        try {
            EternalChatColorMod.onModLoad();
        }
        catch (Throwable t) {
            System.out.println("[XpMod] ChatColor onModLoad error: " + String.valueOf(t));
        }
        try {
            BuffRegistry.registerBuff((String)"xp_skill_buff", (Buff)new XpSkillBuff());
            System.out.println("[XpMod] Registered skill buff: xp_skill_buff");
        }
        catch (Exception e) {
            System.out.println("[XpMod] ERROR registering buff: " + String.valueOf(e));
        }
        try {
            XpCommand xpCmd = new XpCommand();
            CommandsManager.registerServerCommand((ChatCommand)xpCmd);
            CommandsManager.registerClientCommand((ChatCommand)xpCmd);
            System.out.println("[XpMod] Registered /xp command");
        }
        catch (Exception e) {
            System.out.println("[XpMod] ERROR registering /xp command: " + String.valueOf(e));
        }
        try {
            PacketRegistry.registerPacket(PacketXpTopRequest.class);
            PacketRegistry.registerPacket(PacketXpTopResponse.class);
            PacketRegistry.registerPacket(PacketXpSelfStats.class);
            System.out.println("[XpMod] Registered XP packets");
        }
        catch (Exception e) {
            System.out.println("[XpMod] ERROR registering XP packets: " + String.valueOf(e));
        }
        try {
            GameEvents.addListener(ObjectDamageEvent.class, (GameEventInterface)new GameEventListener<ObjectDamageEvent>(){

                public void onEvent(ObjectDamageEvent e) {
                    try {
                        XpTreeHooks.onObjectDamage(e);
                    }
                    catch (Throwable t) {
                        System.out.println("[XpMod] XP TreeHook error: " + String.valueOf(t));
                    }
                    try {
                        XpOreHooks.onObjectDamage(e);
                    }
                    catch (Throwable t) {
                        System.out.println("[XpMod] XP OreHook error: " + String.valueOf(t));
                    }
                }
            });
            System.out.println("[XpMod] Registered ObjectDamageEvent hooks");
        }
        catch (Exception e) {
            System.out.println("[XpMod] ERROR registering ObjectDamageEvent listener: " + String.valueOf(e));
        }
        System.out.println("[XpMod] init() done");
    }

    public void postInit() {
        System.out.println("[XpMod] postInit()");
    }
}

