/*
 * Decompiled with CFR 0.152.
 */
package com.xp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class XpMobXpConfig {
    private final Path FILE = Paths.get("xp_mob_xp.txt", new String[0]);
    private volatile long lastModified = -1L;
    private final Map<String, Integer> xpMap = new ConcurrentHashMap<String, Integer>();
    private static final Set<String> BOSS_IDS;

    static {
        String[] ids;
        BOSS_IDS = new HashSet<String>();
        String[] stringArray = ids = new String[]{"evilsprotector", "queenspider", "voidwizard", "chieftain", "swampguardian", "ancientvulture", "piratecaptain", "reaper", "cryoqueen", "thecursedcrone", "pestwarden", "sage", "grit", "fallenwizard", "motherslime", "nightswarm", "spiderempress", "sunlightchampion", "moonlightdancer", "crystaldragon", "thevoid", "ascendedwizard"};
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null) {
                BOSS_IDS.add(s.toLowerCase(Locale.ROOT));
            }
            ++n2;
        }
    }

    public XpMobXpConfig() {
        this.initFileIfMissing();
        this.ensureBossDefaultsExist();
        this.forceReload();
    }

    private void initFileIfMissing() {
        if (Files.exists(this.FILE, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(this.FILE, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                bw.write("# Eternal RPG - XP per mob override\n");
                bw.write("#\n");
                bw.write("# If a line matches, it OVERRIDES the base XP from xp_config.\n");
                bw.write("#\n");
                bw.write("# Format:\n");
                bw.write("#   mob=<stringID>;xp=<number>\n");
                bw.write("#   action=<HOSTILE_KILL|FRIENDLY_KILL>;mob=<stringID>;xp=<number>\n");
                bw.write("#\n");
                bw.write("# Boss presets (stringID format, lowercase, no special chars):\n");
                bw.write("# NOTE: edit XP numbers as you want.\n\n");
                bw.write("action=HOSTILE_KILL;mob=evilsprotector;xp=160\n");
                bw.write("action=HOSTILE_KILL;mob=queenspider;xp=120\n");
                bw.write("action=HOSTILE_KILL;mob=voidwizard;xp=140\n");
                bw.write("action=HOSTILE_KILL;mob=chieftain;xp=160\n");
                bw.write("action=HOSTILE_KILL;mob=swampguardian;xp=180\n");
                bw.write("action=HOSTILE_KILL;mob=ancientvulture;xp=200\n");
                bw.write("action=HOSTILE_KILL;mob=piratecaptain;xp=250\n");
                bw.write("action=HOSTILE_KILL;mob=reaper;xp=300\n");
                bw.write("action=HOSTILE_KILL;mob=cryoqueen;xp=320\n");
                bw.write("action=HOSTILE_KILL;mob=thecursedcrone;xp=340\n");
                bw.write("action=HOSTILE_KILL;mob=pestwarden;xp=360\n");
                bw.write("action=HOSTILE_KILL;mob=sage;xp=220\n");
                bw.write("action=HOSTILE_KILL;mob=grit;xp=220\n");
                bw.write("action=HOSTILE_KILL;mob=fallenwizard;xp=500\n");
                bw.write("action=HOSTILE_KILL;mob=motherslime;xp=550\n");
                bw.write("action=HOSTILE_KILL;mob=nightswarm;xp=600\n");
                bw.write("action=HOSTILE_KILL;mob=spiderempress;xp=650\n");
                bw.write("action=HOSTILE_KILL;mob=sunlightchampion;xp=750\n");
                bw.write("action=HOSTILE_KILL;mob=moonlightdancer;xp=800\n");
                bw.write("action=HOSTILE_KILL;mob=crystaldragon;xp=900\n");
                bw.write("action=HOSTILE_KILL;mob=thevoid;xp=1000\n");
                bw.write("action=HOSTILE_KILL;mob=ascendedwizard;xp=1200\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("[XpMod] Failed to create xp_mob_xp.txt: " + String.valueOf(e));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void ensureBossDefaultsExist() {
        if (!Files.exists(this.FILE, new LinkOption[0])) {
            return;
        }
        HashSet<Object> existing = new HashSet<Object>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader br = Files.newBufferedReader(this.FILE, StandardCharsets.UTF_8);){
                String line;
                while ((line = br.readLine()) != null) {
                    String[] parts;
                    String l = line.trim();
                    if (l.isEmpty() || l.startsWith("#")) continue;
                    String action = null;
                    String mob = null;
                    String[] stringArray = parts = l.split(";");
                    int n = parts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String p = stringArray[n2];
                        String[] kv = p.split("=", 2);
                        if (kv.length == 2) {
                            String key = kv[0].trim().toLowerCase(Locale.ROOT);
                            String val = kv[1].trim();
                            if (key.equals("action")) {
                                action = val.toUpperCase(Locale.ROOT);
                            } else if (key.equals("mob")) {
                                mob = val;
                            }
                        }
                        ++n2;
                    }
                    if (mob == null || mob.trim().isEmpty()) continue;
                    String m = mob.trim().toLowerCase(Locale.ROOT);
                    if (action == null || action.trim().isEmpty()) {
                        existing.add(m);
                        continue;
                    }
                    existing.add(action.trim().toUpperCase(Locale.ROOT) + "|" + m);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        for (String string : BOSS_IDS) {
            String k = "HOSTILE_KILL|" + string;
            if (existing.contains(k) || existing.contains(string)) continue;
            Integer xp = this.getDefaultBossXp(string);
            if (xp == null) {
                xp = 0;
            }
            sb.append("action=HOSTILE_KILL;mob=").append(string).append(";xp=").append(xp).append("\n");
        }
        if (sb.length() <= 0) {
            return;
        }
        try {
            Throwable throwable = null;
            Iterator<String> iterator = null;
            try (BufferedWriter bw = Files.newBufferedWriter(this.FILE, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
                bw.write("\n# --- auto-added missing boss presets ---\n");
                bw.write(sb.toString());
            }
            catch (Throwable throwable2) {
                void var3_12;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var3_12;
            }
        }
        catch (Throwable throwable) {
            System.out.println("[XpMod] Failed to append boss presets to xp_mob_xp.txt: " + String.valueOf(throwable));
        }
    }

    private Integer getDefaultBossXp(String id) {
        if (id == null) {
            return null;
        }
        switch (id.toLowerCase(Locale.ROOT)) {
            case "evilsprotector": {
                return 160;
            }
            case "queenspider": {
                return 120;
            }
            case "voidwizard": {
                return 140;
            }
            case "chieftain": {
                return 160;
            }
            case "swampguardian": {
                return 180;
            }
            case "ancientvulture": {
                return 200;
            }
            case "piratecaptain": {
                return 250;
            }
            case "reaper": {
                return 300;
            }
            case "cryoqueen": {
                return 320;
            }
            case "thecursedcrone": {
                return 340;
            }
            case "pestwarden": {
                return 360;
            }
            case "sage": {
                return 220;
            }
            case "grit": {
                return 220;
            }
            case "fallenwizard": {
                return 500;
            }
            case "motherslime": {
                return 550;
            }
            case "nightswarm": {
                return 600;
            }
            case "spiderempress": {
                return 650;
            }
            case "sunlightchampion": {
                return 750;
            }
            case "moonlightdancer": {
                return 800;
            }
            case "crystaldragon": {
                return 900;
            }
            case "thevoid": {
                return 1000;
            }
            case "ascendedwizard": {
                return 1200;
            }
        }
        return null;
    }

    public void forceReload() {
        this.lastModified = -1L;
        this.reloadIfChanged();
    }

    public void reloadIfChanged() {
        try {
            long lm;
            long l = lm = Files.exists(this.FILE, new LinkOption[0]) ? Files.getLastModifiedTime(this.FILE, new LinkOption[0]).toMillis() : -1L;
            if (lm == this.lastModified) {
                return;
            }
            this.lastModified = lm;
        }
        catch (Throwable lm) {
            // empty catch block
        }
        this.xpMap.clear();
        if (!Files.exists(this.FILE, new LinkOption[0])) {
            this.initFileIfMissing();
            return;
        }
        try {
            lm = null;
            Object var2_6 = null;
            try (BufferedReader br = Files.newBufferedReader(this.FILE, StandardCharsets.UTF_8);){
                String line;
                while ((line = br.readLine()) != null) {
                    String[] parts;
                    String l = line.trim();
                    if (l.isEmpty() || l.startsWith("#")) continue;
                    String action = null;
                    String mob = null;
                    Integer xp = null;
                    String[] stringArray = parts = l.split(";");
                    int n = parts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String p = stringArray[n2];
                        String[] kv = p.split("=", 2);
                        if (kv.length == 2) {
                            String key = kv[0].trim().toLowerCase(Locale.ROOT);
                            String val = kv[1].trim();
                            try {
                                if (key.equals("action")) {
                                    action = val.toUpperCase(Locale.ROOT);
                                } else if (key.equals("mob")) {
                                    mob = val;
                                } else if (key.equals("xp")) {
                                    xp = Integer.parseInt(val);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        ++n2;
                    }
                    if (mob == null || mob.trim().isEmpty() || xp == null) continue;
                    if (xp < 0) {
                        xp = 0;
                    }
                    String mobKey = mob.trim().toLowerCase(Locale.ROOT);
                    if (action == null || action.trim().isEmpty()) {
                        this.xpMap.put(mobKey, xp);
                        continue;
                    }
                    String a = action.trim().toUpperCase(Locale.ROOT);
                    this.xpMap.put(a + "|" + mobKey, xp);
                }
            }
            catch (Throwable throwable) {
                if (lm == null) {
                    lm = throwable;
                } else if (lm != throwable) {
                    lm.addSuppressed(throwable);
                }
                throw lm;
            }
        }
        catch (IOException e) {
            System.out.println("[XpMod] Failed to load xp_mob_xp.txt: " + String.valueOf(e));
        }
    }

    public boolean isBoss(String mobName) {
        if (mobName == null) {
            return false;
        }
        String m = mobName.trim().toLowerCase(Locale.ROOT);
        if (m.isEmpty()) {
            return false;
        }
        return BOSS_IDS.contains(m);
    }

    public int getXpForMob(String mobName) {
        if (mobName == null) {
            return -1;
        }
        String m = mobName.trim().toLowerCase(Locale.ROOT);
        if (m.isEmpty()) {
            return -1;
        }
        Integer v = this.xpMap.get(m);
        return v != null ? v : -1;
    }

    public int getXpForMob(String mobName, String action) {
        String a;
        Integer v;
        if (mobName == null) {
            return -1;
        }
        String m = mobName.trim().toLowerCase(Locale.ROOT);
        if (m.isEmpty()) {
            return -1;
        }
        if (action != null && !action.trim().isEmpty() && (v = this.xpMap.get((a = action.trim().toUpperCase(Locale.ROOT)) + "|" + m)) != null) {
            return v;
        }
        Integer v2 = this.xpMap.get(m);
        return v2 != null ? v2 : -1;
    }
}

