/*
 * Decompiled with CFR 0.152.
 */
package com.xp;

import com.xp.JobsCompat;
import com.xp.XpConfig;
import com.xp.XpJobBonusConfig;
import com.xp.XpMobXpConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import necesse.engine.network.server.ServerClient;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.level.maps.Level;

public class XpManager {
    private final Path XP_STORE_FILE = Paths.get("xp_store.txt", new String[0]);
    private final Path XP_SKILLS_FILE = Paths.get("xp_skills.txt", new String[0]);
    private final Path RANK_SETTINGS_FILE = Paths.get("xp_rank_settings.txt", new String[0]);
    private final Map<String, Integer> xpByName = new ConcurrentHashMap<String, Integer>();
    private final Map<String, PlayerSkills> skillsByName = new ConcurrentHashMap<String, PlayerSkills>();
    private final Map<String, Long> recentTileCounts = new ConcurrentHashMap<String, Long>();
    private volatile List<RankEntry> ranks = new ArrayList<RankEntry>();
    private final XpConfig cfg = new XpConfig();
    private final XpJobBonusConfig jobBonusCfg = new XpJobBonusConfig();
    private final XpMobXpConfig mobXpCfg = new XpMobXpConfig();
    private static final ScheduledExecutorService XP_EXEC = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "XpMod-runLater");
        t.setDaemon(true);
        return t;
    });

    public XpManager() {
        this.initRankSettingsFile();
        this.loadRankSettings();
        this.loadXp();
        this.loadSkills();
    }

    private int applyJobBonus(ServerClient sc, int base, String jobName, String actionName) {
        if (sc == null) {
            return base;
        }
        if (base <= 0) {
            return base;
        }
        this.jobBonusCfg.reloadIfChanged();
        int perRank = this.jobBonusCfg.getPerRank(jobName, actionName);
        if (perRank <= 0) {
            return base;
        }
        int rank = JobsCompat.getRankIfJobMatches(sc, jobName);
        if (rank <= 0) {
            return base;
        }
        long bonus = (long)rank * (long)perRank;
        long out = (long)base + bonus;
        if (out > Integer.MAX_VALUE) {
            out = Integer.MAX_VALUE;
        }
        return (int)out;
    }

    private void initRankSettingsFile() {
        if (Files.exists(this.RANK_SETTINGS_FILE, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(this.RANK_SETTINGS_FILE, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                bw.write("# RankName=XP (sorted by XP automatically)\n");
                bw.write("# Add more lines to add more ranks.\n");
                bw.newLine();
                bw.write("Novice=1000\n");
                bw.write("Apprentice=2000\n");
                bw.write("Adept=3000\n");
                bw.write("Skilled=4000\n");
                bw.write("Expert=5000\n");
                bw.write("Elite=6000\n");
                bw.write("Veteran=7000\n");
                bw.write("Champion=8000\n");
                bw.write("Guardian=9000\n");
                bw.write("Warden=10000\n");
                bw.write("Master=12000\n");
                bw.write("Grandmaster=14000\n");
                bw.write("Mythic=16000\n");
                bw.write("Eternal=18000\n");
                bw.write("Celestial=20000\n");
                bw.write("Apex=30000\n");
                bw.write("Paragon=50000\n");
                bw.write("Legendary=150000\n");
                bw.write("Ascendant=300000\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("[XpMod] Failed to init xp_rank_settings.txt: " + String.valueOf(e));
        }
    }

    /*
     * Exception decompiling
     */
    private void loadRankSettings() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getRankIndexForXp(int xp) {
        if (xp < 0) {
            xp = 0;
        }
        List<RankEntry> rs = this.ranks;
        int idx = -1;
        int i = 0;
        while (i < rs.size()) {
            if (xp < rs.get((int)i).xp) break;
            idx = i++;
        }
        return idx;
    }

    public int getRankCount() {
        return this.ranks != null ? this.ranks.size() : 0;
    }

    public String getRankNameForXp(int xp) {
        int idx = this.getRankIndexForXp(xp);
        if (idx < 0) {
            return "Unranked";
        }
        List<RankEntry> rs = this.ranks;
        if (idx >= rs.size()) {
            idx = rs.size() - 1;
        }
        return rs.get((int)idx).name;
    }

    public int getNextRankXp(int xp) {
        if (xp < 0) {
            xp = 0;
        }
        List<RankEntry> rs = this.ranks;
        int idx = this.getRankIndexForXp(xp);
        int next = idx + 1;
        if (next < 0) {
            next = 0;
        }
        if (next >= rs.size()) {
            return xp;
        }
        return rs.get((int)next).xp;
    }

    public String snapshotName(ServerClient sc) {
        if (sc == null) {
            return "unknown";
        }
        String n = null;
        try {
            n = sc.getName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n == null || n.isEmpty()) {
            return ("player_" + sc.slot).toLowerCase(Locale.ROOT);
        }
        return n.trim().toLowerCase(Locale.ROOT);
    }

    public void send(ServerClient sc, String msg) {
        if (sc == null || msg == null) {
            return;
        }
        try {
            sc.sendChatMessage(msg);
        }
        catch (Throwable t) {
            System.out.println("[XpMod] send chat error: " + String.valueOf(t));
        }
    }

    public int getXp(String name) {
        if (name == null) {
            return 0;
        }
        return this.xpByName.getOrDefault(name.toLowerCase(Locale.ROOT), 0);
    }

    public int getTotalSkillPoints(String name) {
        int xp = this.getXp(name);
        int rankIdx = this.getRankIndexForXp(xp);
        return rankIdx + 2;
    }

    public int getUnspentSkillPoints(String name) {
        int total = this.getTotalSkillPoints(name);
        PlayerSkills s = this.getSkills(name);
        int used = s.total();
        return Math.max(0, total - used);
    }

    public PlayerSkills getSkills(String name) {
        if (name == null) {
            return new PlayerSkills();
        }
        String key = name.toLowerCase(Locale.ROOT);
        return this.skillsByName.computeIfAbsent(key, k -> new PlayerSkills());
    }

    public boolean setSkills(String name, int hp, int mana, int speed, int crit, int damage, int armor, int resilience) {
        if (name == null) {
            return false;
        }
        String key = name.toLowerCase(Locale.ROOT);
        PlayerSkills s = new PlayerSkills(hp, mana, speed, crit, damage, armor, resilience);
        int totalPoints = this.getTotalSkillPoints(key);
        int used = s.total();
        if (used > totalPoints) {
            System.out.println("[XpMod] setSkills failed, used=" + used + " > total=" + totalPoints + " for " + key);
            return false;
        }
        this.skillsByName.put(key, s);
        this.saveSkills();
        return true;
    }

    public boolean setSkills(ServerClient sc, int hp, int mana, int speed, int crit, int damage, int armor, int resilience) {
        if (sc == null) {
            return false;
        }
        String name = this.snapshotName(sc);
        boolean ok = this.setSkills(name, hp, mana, speed, crit, damage, armor, resilience);
        if (ok) {
            this.refreshSkillBuff(sc);
        }
        return ok;
    }

    public void resetSkills(String name) {
        if (name == null) {
            return;
        }
        this.skillsByName.remove(name.toLowerCase(Locale.ROOT));
        this.saveSkills();
    }

    public List<TopEntry> getTopEntries(int limit) {
        List<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(this.xpByName.entrySet());
        list.sort(Comparator.comparingInt(e -> (Integer)e.getValue()).reversed());
        if (limit > 0 && list.size() > limit) {
            list = list.subList(0, limit);
        }
        ArrayList<TopEntry> out = new ArrayList<TopEntry>();
        for (Map.Entry entry : list) {
            out.add(new TopEntry((String)entry.getKey(), (Integer)entry.getValue()));
        }
        return out;
    }

    private void addXp(ServerClient sc, int amount) {
        if (sc == null || amount <= 0) {
            return;
        }
        String key = this.snapshotName(sc);
        int oldXp = this.getXp(key);
        int newXp = oldXp + amount;
        if (newXp < 0) {
            newXp = 0;
        }
        this.xpByName.put(key, newXp);
        int oldRank = this.getRankIndexForXp(oldXp);
        int newRank = this.getRankIndexForXp(newXp);
        if (newRank > oldRank) {
            this.send(sc, "[XP] Rank up! You are now " + this.getRankNameForXp(newXp) + ".");
        }
        this.refreshSkillBuff(sc);
        this.saveXp();
        this.saveSkills();
    }

    public void onTreeChopped(ServerClient sc) {
        this.cfg.reloadIfChanged();
        int base = this.cfg.xpPerTree();
        int amount = this.applyJobBonus(sc, base, "WOODCUTTER", "TREE");
        this.addXp(sc, amount);
    }

    public void onOreMined(ServerClient sc) {
        this.cfg.reloadIfChanged();
        int base = this.cfg.xpPerOre();
        int amount = this.applyJobBonus(sc, base, "MINER", "ORE");
        this.addXp(sc, amount);
    }

    public void onFriendlyKilled(ServerClient sc, String mobName) {
        this.cfg.reloadIfChanged();
        this.mobXpCfg.reloadIfChanged();
        int base = this.cfg.xpPerFriendlyKill();
        int override = this.mobXpCfg.getXpForMob(mobName, "FRIENDLY_KILL");
        if (override >= 0) {
            base = override;
        }
        int amount = this.applyJobBonus(sc, base, "HUNTER", "FRIENDLY_KILL");
        this.addXp(sc, amount);
    }

    public void onHostileKilled(ServerClient sc, String mobName) {
        this.cfg.reloadIfChanged();
        this.mobXpCfg.reloadIfChanged();
        int base = this.cfg.xpPerHostileKill();
        int override = this.mobXpCfg.getXpForMob(mobName, "HOSTILE_KILL");
        if (override >= 0) {
            base = override;
        }
        int amount = this.applyJobBonus(sc, base, "SLAYER", "HOSTILE_KILL");
        this.addXp(sc, amount);
        if (amount > 0 && this.mobXpCfg.isBoss(mobName)) {
            this.send(sc, "[XP] You got " + amount + " XP for killing boss!");
        }
    }

    public void onFishCaught(ServerClient sc, String fishID) {
        this.cfg.reloadIfChanged();
        int base = this.cfg.xpPerFish();
        if (base <= 0) {
            return;
        }
        int amount = this.applyJobBonus(sc, base, "FISHER", "FISH");
        this.addXp(sc, amount);
    }

    public void showInfo(ServerClient sc) {
        if (sc == null) {
            return;
        }
        String name = this.snapshotName(sc);
        int xp = this.getXp(name);
        int rankIdx = this.getRankIndexForXp(xp);
        String rankName = this.getRankNameForXp(xp);
        int nextRankXp = this.getNextRankXp(xp);
        int toNext = Math.max(0, nextRankXp - xp);
        PlayerSkills s = this.getSkills(name);
        int totalPoints = this.getTotalSkillPoints(name);
        int used = s.total();
        int free = Math.max(0, totalPoints - used);
        this.send(sc, "[XP] Name: " + name);
        this.send(sc, "[XP] Rank: " + (String)(rankIdx < 0 ? "0 (Unranked)" : rankIdx + 1 + " (" + rankName + ")"));
        this.send(sc, "[XP] XP: " + xp + (String)(nextRankXp > xp ? " / " + nextRankXp + " (+" + toNext + " to next rank)" : " (max rank)"));
        this.send(sc, "[XP] Skill points: total=" + totalPoints + " used=" + used + " free=" + free);
    }

    public void showTop(ServerClient sc, int limit) {
        if (sc == null) {
            return;
        }
        this.send(sc, "[XP] ==== TOP " + limit + " XP ====");
        List<TopEntry> top = this.getTopEntries(limit);
        int i = 0;
        while (i < top.size()) {
            TopEntry e = top.get(i);
            String rankName = this.getRankNameForXp(e.xp);
            this.send(sc, "#" + (i + 1) + " " + e.name + " - " + e.xp + " XP (" + rankName + ")");
            ++i;
        }
    }

    public void showConfig(ServerClient sc) {
        if (sc == null) {
            return;
        }
        this.send(sc, "[XP] ==== Rank config ====");
        List<RankEntry> rs = this.ranks;
        if (rs.isEmpty()) {
            this.send(sc, "[XP] (no ranks loaded)");
            return;
        }
        int i = 0;
        while (i < rs.size()) {
            this.send(sc, "[XP] " + (i + 1) + ") " + rs.get((int)i).name + " = " + rs.get((int)i).xp);
            ++i;
        }
    }

    public void reloadConfig(ServerClient sc) {
        this.cfg.forceReload();
        this.jobBonusCfg.forceReload();
        this.mobXpCfg.forceReload();
        this.loadRankSettings();
        if (sc != null) {
            this.send(sc, "[XP] Config reloaded.");
            this.showConfig(sc);
        }
    }

    public void adminSetXp(ServerClient admin, String targetNickArg, int newXp) {
        if (targetNickArg == null) {
            return;
        }
        String key = targetNickArg.trim().toLowerCase(Locale.ROOT);
        if (newXp < 0) {
            newXp = 0;
        }
        this.xpByName.put(key, newXp);
        this.saveXp();
        this.saveSkills();
        if (admin != null) {
            this.send(admin, "[XP] Set XP of " + key + " to " + newXp + ".");
            String adminName = this.snapshotName(admin);
            if (adminName.equalsIgnoreCase(key)) {
                this.refreshSkillBuff(admin);
            }
        }
    }

    public boolean markIfNotRecentlyCounted(Level level, int x, int y, long cooldownMs) {
        String key;
        if (level == null) {
            return false;
        }
        if (cooldownMs <= 0L) {
            cooldownMs = 1000L;
        }
        try {
            key = String.valueOf(level.getIdentifier()) + ":" + x + ":" + y;
        }
        catch (Throwable t) {
            key = "L:" + x + ":" + y;
        }
        long now = System.currentTimeMillis();
        Long last = this.recentTileCounts.get(key);
        if (last != null && now - last < cooldownMs) {
            return false;
        }
        this.recentTileCounts.put(key, now);
        return true;
    }

    public void runLater(Runnable r, long delayMs) {
        if (r == null) {
            return;
        }
        if (delayMs <= 0L) {
            try {
                r.run();
            }
            catch (Throwable t) {
                System.out.println("[XpMod] runLater error (immediate): " + String.valueOf(t));
            }
            return;
        }
        try {
            XP_EXEC.schedule(() -> {
                try {
                    r.run();
                }
                catch (Throwable t) {
                    System.out.println("[XpMod] runLater error: " + String.valueOf(t));
                }
            }, delayMs, TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            System.out.println("[XpMod] runLater schedule failed: " + String.valueOf(t));
        }
    }

    public void refreshSkillBuff(ServerClient sc) {
        if (sc == null || sc.playerMob == null) {
            return;
        }
        try {
            String name;
            PlayerSkills skills;
            ActiveBuff existing = sc.playerMob.buffManager.getBuff("xp_skill_buff");
            if (existing != null) {
                sc.playerMob.buffManager.removeBuff(existing.buff, true);
            }
            if ((skills = this.getSkills(name = this.snapshotName(sc))) == null) {
                skills = new PlayerSkills();
            }
            ActiveBuff ab = new ActiveBuff("xp_skill_buff", (Mob)sc.playerMob, Integer.MAX_VALUE, null);
            ab.getGndData().setInt("xp_hp", skills.health);
            ab.getGndData().setInt("xp_mana", skills.mana);
            ab.getGndData().setInt("xp_speed", skills.speed);
            ab.getGndData().setInt("xp_crit", skills.crit);
            ab.getGndData().setInt("xp_dmg", skills.damage);
            ab.getGndData().setInt("xp_armor", skills.armor);
            ab.getGndData().setInt("xp_resil", skills.resilience);
            sc.playerMob.buffManager.addBuff(ab, true);
        }
        catch (Exception e) {
            System.out.println("[XpMod] Error applying skill buff: " + String.valueOf(e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadXp() {
        this.xpByName.clear();
        if (!Files.exists(this.XP_STORE_FILE, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader br = Files.newBufferedReader(this.XP_STORE_FILE, StandardCharsets.UTF_8);){
                while (true) {
                    String[] parts;
                    String line;
                    if ((line = br.readLine()) == null) {
                        return;
                    }
                    String l = line.trim();
                    if (l.isEmpty() || l.startsWith("#") || (parts = l.split(";")).length < 2) continue;
                    String name = parts[0].trim().toLowerCase(Locale.ROOT);
                    try {
                        int xp = Integer.parseInt(parts[1].trim());
                        if (xp < 0) {
                            xp = 0;
                        }
                        this.xpByName.put(name, xp);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("[XpMod] Failed to load xp_store.txt: " + String.valueOf(e));
        }
    }

    private void saveXp() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(this.XP_STORE_FILE, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                bw.write("# name;xp\n");
                for (Map.Entry<String, Integer> e : this.xpByName.entrySet()) {
                    bw.write(e.getKey() + ";" + String.valueOf(e.getValue()));
                    bw.newLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("[XpMod] Failed to save xp_store.txt: " + String.valueOf(e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadSkills() {
        this.skillsByName.clear();
        if (!Files.exists(this.XP_SKILLS_FILE, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader br = Files.newBufferedReader(this.XP_SKILLS_FILE, StandardCharsets.UTF_8);){
                while (true) {
                    String[] parts;
                    String line;
                    if ((line = br.readLine()) == null) {
                        return;
                    }
                    String l = line.trim();
                    if (l.isEmpty() || l.startsWith("#") || (parts = l.split(";")).length < 6) continue;
                    String name = parts[0].trim().toLowerCase(Locale.ROOT);
                    try {
                        int hp = Integer.parseInt(parts[1].trim());
                        int mana = Integer.parseInt(parts[2].trim());
                        int speed = Integer.parseInt(parts[3].trim());
                        int crit = Integer.parseInt(parts[4].trim());
                        int dmg = Integer.parseInt(parts[5].trim());
                        int armor = 0;
                        int resil = 0;
                        if (parts.length >= 8) {
                            armor = Integer.parseInt(parts[6].trim());
                            resil = Integer.parseInt(parts[7].trim());
                        }
                        this.skillsByName.put(name, new PlayerSkills(hp, mana, speed, crit, dmg, armor, resil));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("[XpMod] Failed to load xp_skills.txt: " + String.valueOf(e));
        }
    }

    public synchronized void reloadFromDiskForGui() {
        this.loadXp();
        this.loadSkills();
    }

    private void saveSkills() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(this.XP_SKILLS_FILE, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                bw.write("# name;hp;mana;speed;crit;damage;armor;resilience\n");
                for (Map.Entry<String, PlayerSkills> e : this.skillsByName.entrySet()) {
                    PlayerSkills s = e.getValue();
                    bw.write(e.getKey() + ";" + s.health + ";" + s.mana + ";" + s.speed + ";" + s.crit + ";" + s.damage + ";" + s.armor + ";" + s.resilience);
                    bw.newLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("[XpMod] Failed to save xp_skills.txt: " + String.valueOf(e));
        }
    }

    @Deprecated
    public int getLevelForXp(int xp) {
        int idx = this.getRankIndexForXp(xp);
        return Math.max(0, idx + 1);
    }

    private static /* synthetic */ int lambda$1(RankEntry r) {
        return r.xp;
    }

    public static final class PlayerSkills {
        public int health;
        public int mana;
        public int speed;
        public int crit;
        public int damage;
        public int armor;
        public int resilience;

        public PlayerSkills() {
            this(0, 0, 0, 0, 0, 0, 0);
        }

        public PlayerSkills(int health, int mana, int speed, int crit, int damage, int armor, int resilience) {
            this.health = health;
            this.mana = mana;
            this.speed = speed;
            this.crit = crit;
            this.damage = damage;
            this.armor = armor;
            this.resilience = resilience;
        }

        public int total() {
            return this.health + this.mana + this.speed + this.crit + this.damage + this.armor + this.resilience;
        }
    }

    private static final class RankEntry {
        final String name;
        final int xp;

        RankEntry(String name, int xp) {
            this.name = name;
            this.xp = xp;
        }
    }

    public static final class TopEntry {
        public final String name;
        public final int xp;

        public TopEntry(String name, int xp) {
            this.name = name;
            this.xp = xp;
        }
    }
}

