/*
 * Decompiled with CFR 0.152.
 */
package com.xp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class XpJobBonusConfig {
    private final Path FILE = Paths.get("xp_job_bonus.txt", new String[0]);
    private volatile long lastModified = -1L;
    private final Map<String, Integer> perRankMap = new ConcurrentHashMap<String, Integer>();

    public XpJobBonusConfig() {
        this.initFileIfMissing();
        this.forceReload();
    }

    private void initFileIfMissing() {
        if (Files.exists(this.FILE, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(this.FILE, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                bw.write("# Eternal RPG - XP job bonus config\n");
                bw.write("# Format: job=WOODCUTTER;action=TREE;perRank=1\n");
                bw.write("# Formula: finalXP = baseXP + (rank * perRank)\n");
                bw.write("# Bonus applies ONLY if current job == job\n\n");
                bw.write("job=WOODCUTTER;action=TREE;perRank=1\n");
                bw.write("job=MINER;action=ORE;perRank=1\n");
                bw.write("job=FISHER;action=FISH;perRank=1\n");
                bw.write("job=HUNTER;action=FRIENDLY_KILL;perRank=1\n");
                bw.write("job=SLAYER;action=HOSTILE_KILL;perRank=1\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("[XpMod] Failed to create xp_job_bonus.txt: " + String.valueOf(e));
        }
    }

    public void forceReload() {
        this.lastModified = -1L;
        this.reloadIfChanged();
    }

    public void reloadIfChanged() {
        try {
            long lm;
            long l = lm = Files.exists(this.FILE, new LinkOption[0]) ? Files.getLastModifiedTime(this.FILE, new LinkOption[0]).toMillis() : -1L;
            if (lm == this.lastModified) {
                return;
            }
            this.lastModified = lm;
        }
        catch (Throwable lm) {
            // empty catch block
        }
        this.perRankMap.clear();
        if (!Files.exists(this.FILE, new LinkOption[0])) {
            this.initFileIfMissing();
            return;
        }
        try {
            lm = null;
            Object var2_6 = null;
            try (BufferedReader br = Files.newBufferedReader(this.FILE, StandardCharsets.UTF_8);){
                String line;
                while ((line = br.readLine()) != null) {
                    String[] parts;
                    String l = line.trim();
                    if (l.isEmpty() || l.startsWith("#")) continue;
                    String job = null;
                    String action = null;
                    Integer perRank = null;
                    String[] stringArray = parts = l.split(";");
                    int n = parts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String p = stringArray[n2];
                        String[] kv = p.split("=");
                        if (kv.length == 2) {
                            String key = kv[0].trim().toLowerCase(Locale.ROOT);
                            String val = kv[1].trim();
                            try {
                                if (key.equals("job")) {
                                    job = val.toUpperCase(Locale.ROOT);
                                } else if (key.equals("action")) {
                                    action = val.toUpperCase(Locale.ROOT);
                                } else if (key.equals("perrank")) {
                                    perRank = Integer.parseInt(val);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        ++n2;
                    }
                    if (job == null || action == null || perRank == null) continue;
                    if (perRank < 0) {
                        perRank = 0;
                    }
                    this.perRankMap.put(job + "|" + action, perRank);
                }
            }
            catch (Throwable throwable) {
                if (lm == null) {
                    lm = throwable;
                } else if (lm != throwable) {
                    lm.addSuppressed(throwable);
                }
                throw lm;
            }
        }
        catch (IOException e) {
            System.out.println("[XpMod] Failed to load xp_job_bonus.txt: " + String.valueOf(e));
        }
    }

    public int getPerRank(String job, String action) {
        if (job == null || action == null) {
            return 0;
        }
        return this.perRankMap.getOrDefault(job.toUpperCase(Locale.ROOT) + "|" + action.toUpperCase(Locale.ROOT), 0);
    }
}

