/*
 * Decompiled with CFR 0.152.
 */
package com.xp;

import com.xp.XpManager;
import com.xp.XpMod;
import com.xp.XpTopForm;
import necesse.engine.network.Packet;
import necesse.engine.network.client.Client;
import necesse.engine.network.packet.PacketChatMessage;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.MainGameFormManager;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormLabel;
import necesse.gfx.forms.components.FormTextButton;
import necesse.gfx.gameFont.FontOptions;

public class XpGuiForm
extends Form {
    private final Client client;
    private final MainGameFormManager formManager;
    private final String canonicalName;
    private final String displayName;
    private final String jobBonusText;
    private int xp;
    private int totalPoints;
    private int freePoints;
    private int hp;
    private int mana;
    private int speed;
    private int crit;
    private int damage;
    private int armor;
    private int resilience;
    private FormLabel titleLabel;
    private FormLabel xpLabel;
    private FormLabel pointsLabel;
    private FormLabel bonusLabel;
    private final FormLabel[] valueLabels = new FormLabel[7];
    private final FormLabel[] levelTextLabels = new FormLabel[7];
    private XpTopForm topForm;

    public XpGuiForm(Client client, MainGameFormManager formManager, String canonicalName, String displayName, int xp, int freePoints, XpManager.PlayerSkills skills, String jobBonusText) {
        super("xpGuiForm", 900, 340);
        this.client = client;
        this.formManager = formManager;
        this.canonicalName = canonicalName;
        this.displayName = displayName != null ? displayName : canonicalName;
        this.jobBonusText = jobBonusText != null ? jobBonusText : "";
        this.xp = xp;
        if (skills == null) {
            skills = new XpManager.PlayerSkills();
        }
        this.hp = skills.health;
        this.mana = skills.mana;
        this.speed = skills.speed;
        this.crit = skills.crit;
        this.damage = skills.damage;
        this.armor = skills.armor;
        this.resilience = skills.resilience;
        int used = skills.total();
        this.totalPoints = used + Math.max(0, freePoints);
        this.freePoints = Math.max(0, freePoints);
        this.buildGui();
        this.refreshAllTexts();
    }

    private void buildGui() {
        FontOptions title = new FontOptions(22);
        FontOptions info = new FontOptions(14);
        FontOptions statName = new FontOptions(16);
        FontOptions valueFont = new FontOptions(16);
        FontOptions lvlFont = new FontOptions(12);
        FormTextButton closeBtn = (FormTextButton)this.addComponent((FormComponent)new FormTextButton("X", this.getWidth() - 26, 6, 20));
        closeBtn.onClicked(e -> this.setHidden(true));
        FormTextButton topBtn = (FormTextButton)this.addComponent((FormComponent)new FormTextButton("Top 10", this.getWidth() - 120, 6, 80));
        topBtn.onClicked(e -> this.openTop10());
        String rank = XpMod.getRankForXp(this.xp);
        this.titleLabel = (FormLabel)this.addComponent((FormComponent)new FormLabel("XP & Skills - " + this.displayName + " [" + rank + "]", title, -1, 16, 16));
        this.xpLabel = (FormLabel)this.addComponent((FormComponent)new FormLabel("", info, -1, 16, 52));
        this.pointsLabel = (FormLabel)this.addComponent((FormComponent)new FormLabel("", info, -1, 16, 72));
        this.bonusLabel = (FormLabel)this.addComponent((FormComponent)new FormLabel("", info, -1, 16, 92));
        int rowY = 150;
        int nameY = rowY - 34;
        int valueY = rowY + 2;
        int lvlY = rowY + 38;
        int colCount = 5;
        int leftMargin = 100;
        int rightMargin = 100;
        int usableWidth = this.getWidth() - leftMargin - rightMargin;
        int colStep = usableWidth / (colCount - 1);
        int minusW = 32;
        int plusW = 32;
        int gapBetween = 64;
        int i = 0;
        while (i < colCount) {
            int colX = leftMargin + i * colStep;
            this.addStat(switch (i) {
                case 0 -> "Health";
                case 1 -> "Mana";
                case 2 -> "Speed";
                case 3 -> "Critical";
                default -> "Damage";
            }, i, colX, nameY, rowY, valueY, lvlY, minusW, plusW, gapBetween, statName, valueFont, lvlFont);
            ++i;
        }
        int rowY2 = 270;
        int nameY2 = rowY2 - 34;
        int valueY2 = rowY2 + 2;
        int lvlY2 = rowY2 + 38;
        int colArmorX = leftMargin;
        int colResilienceX = leftMargin + 4 * colStep;
        this.addStat("Armor", 5, colArmorX, nameY2, rowY2, valueY2, lvlY2, minusW, plusW, gapBetween, statName, valueFont, lvlFont);
        this.addStat("Resilience", 6, colResilienceX, nameY2, rowY2, valueY2, lvlY2, minusW, plusW, gapBetween, statName, valueFont, lvlFont);
        FormTextButton saveBtn = (FormTextButton)this.addComponent((FormComponent)new FormTextButton("Save", 300, 270, 140));
        saveBtn.onClicked(e -> this.onSave());
        FormTextButton resetBtn = (FormTextButton)this.addComponent((FormComponent)new FormTextButton("Reset", 500, 270, 140));
        resetBtn.onClicked(e -> this.onReset());
    }

    private void addStat(String name, int index, int colCenterX, int nameY, int buttonsY, int valueY, int lvlY, int minusW, int plusW, int gap, FontOptions nameFont, FontOptions valueFont, FontOptions lvlFont) {
        int labelOffset = 30;
        if ("Resilience".equals(name)) {
            labelOffset = 45;
        }
        this.addComponent((FormComponent)new FormLabel(name, nameFont, -1, colCenterX - labelOffset, nameY));
        int minusX = colCenterX - gap / 2 - minusW / 2;
        int plusX = colCenterX + gap / 2 - plusW / 2;
        FormTextButton minus = (FormTextButton)this.addComponent((FormComponent)new FormTextButton("-", minusX, buttonsY, minusW));
        int idxMinus = index;
        minus.onClicked(e -> this.changeStat(idxMinus, -1));
        this.valueLabels[index] = (FormLabel)this.addComponent((FormComponent)new FormLabel("0", valueFont, -1, colCenterX - 6, valueY));
        FormTextButton plus = (FormTextButton)this.addComponent((FormComponent)new FormTextButton("+", plusX, buttonsY, plusW));
        int idxPlus = index;
        plus.onClicked(e -> this.changeStat(idxPlus, 1));
        this.levelTextLabels[index] = (FormLabel)this.addComponent((FormComponent)new FormLabel("Level 0", lvlFont, -1, colCenterX - 28, lvlY));
    }

    private void changeStat(int idx, int delta) {
        int nh = this.hp;
        int nm = this.mana;
        int ns = this.speed;
        int nc = this.crit;
        int nd = this.damage;
        int na = this.armor;
        int nr = this.resilience;
        switch (idx) {
            case 0: {
                nh = Math.max(0, this.hp + delta);
                break;
            }
            case 1: {
                nm = Math.max(0, this.mana + delta);
                break;
            }
            case 2: {
                ns = Math.max(0, this.speed + delta);
                break;
            }
            case 3: {
                nc = Math.max(0, this.crit + delta);
                break;
            }
            case 4: {
                nd = Math.max(0, this.damage + delta);
                break;
            }
            case 5: {
                na = Math.max(0, this.armor + delta);
                break;
            }
            case 6: {
                nr = Math.max(0, this.resilience + delta);
            }
        }
        int used = nh + nm + ns + nc + nd + na + nr;
        if (used > this.totalPoints) {
            return;
        }
        this.hp = nh;
        this.mana = nm;
        this.speed = ns;
        this.crit = nc;
        this.damage = nd;
        this.armor = na;
        this.resilience = nr;
        this.freePoints = this.totalPoints - used;
        this.updateRow(0, this.hp);
        this.updateRow(1, this.mana);
        this.updateRow(2, this.speed);
        this.updateRow(3, this.crit);
        this.updateRow(4, this.damage);
        this.updateRow(5, this.armor);
        this.updateRow(6, this.resilience);
        this.updateHeader();
    }

    private void updateRow(int idx, int value) {
        if (this.valueLabels[idx] != null) {
            this.valueLabels[idx].setText(String.valueOf(value));
        }
        if (this.levelTextLabels[idx] != null) {
            this.levelTextLabels[idx].setText("Level " + value);
        }
    }

    private void updateHeader() {
        String rank = XpMod.getRankForXp(this.xp);
        int nextRankXp = XpMod.XP.getNextRankXp(this.xp);
        if (this.titleLabel != null) {
            this.titleLabel.setText("XP & Skills - " + this.displayName + " [" + rank + "]");
        }
        if (this.xpLabel != null) {
            if (nextRankXp > this.xp) {
                this.xpLabel.setText("XP: " + this.xp + "/" + nextRankXp);
            } else {
                this.xpLabel.setText("XP: " + this.xp + " (max rank)");
            }
        }
        if (this.pointsLabel != null) {
            this.pointsLabel.setText("Rank: " + rank + " | Skill points: total=" + this.totalPoints + " free=" + this.freePoints);
        }
        if (this.bonusLabel != null) {
            this.bonusLabel.setText(this.jobBonusText == null ? "" : this.jobBonusText);
        }
    }

    private void refreshAllTexts() {
        this.updateHeader();
        this.updateRow(0, this.hp);
        this.updateRow(1, this.mana);
        this.updateRow(2, this.speed);
        this.updateRow(3, this.crit);
        this.updateRow(4, this.damage);
        this.updateRow(5, this.armor);
        this.updateRow(6, this.resilience);
    }

    private void onSave() {
        if (this.client == null) {
            return;
        }
        String cmd = "/xp skill " + this.hp + " " + this.mana + " " + this.speed + " " + this.crit + " " + this.damage + " " + this.armor + " " + this.resilience;
        try {
            this.client.network.sendPacket((Packet)new PacketChatMessage(this.client.getSlot(), cmd));
        }
        catch (Throwable t) {
            System.out.println("[XpMod] Failed to send XP skill cmd: " + String.valueOf(t));
        }
    }

    private void onReset() {
        if (this.client != null) {
            try {
                this.client.network.sendPacket((Packet)new PacketChatMessage(this.client.getSlot(), "/xp reset"));
            }
            catch (Throwable t) {
                System.out.println("[XpMod] Failed to send XP reset cmd: " + String.valueOf(t));
            }
        }
        this.damage = 0;
        this.crit = 0;
        this.speed = 0;
        this.mana = 0;
        this.hp = 0;
        this.resilience = 0;
        this.armor = 0;
        this.freePoints = this.totalPoints;
        this.refreshAllTexts();
    }

    private void openTop10() {
        if (this.client == null || this.formManager == null) {
            return;
        }
        if (this.topForm == null) {
            this.topForm = new XpTopForm(this.client, this);
            this.formManager.addComponent((FormComponent)this.topForm);
        }
        this.setHidden(true);
        this.topForm.setHidden(false);
        this.topForm.requestTop10();
    }
}

