/*
 * Decompiled with CFR 0.152.
 */
package com.xp;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Locale;

public final class XpConfig {
    private final Path path = Paths.get("xp_config.txt", new String[0]);
    private volatile long lastLoadedTs = -1L;
    private int XP_TREE = 1;
    private int XP_ORE = 1;
    private int XP_FRIENDLY = 1;
    private int XP_HOSTILE = 2;
    private int XP_FISH = 1;

    public XpConfig() {
        this.tryInitFile();
        this.forceReload();
    }

    private void tryInitFile() {
        if (Files.exists(this.path, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(this.path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                bw.write("# XpMod config\n");
                bw.write("# XP vrednosti po akciji.\n");
                bw.write("XP_PER_TREE=1\n");
                bw.write("XP_PER_ORE=1\n");
                bw.write("XP_PER_FRIENDLY_KILL=1\n");
                bw.write("XP_PER_HOSTILE_KILL=2\n");
                bw.write("XP_PER_FISH=1\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void forceReload() {
        this.loadInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadIfChanged() {
        block6: {
            try {
                long lm = Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
                if (lm == this.lastLoadedTs) break block6;
                XpConfig xpConfig = this;
                synchronized (xpConfig) {
                    long lm2 = Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
                    if (lm2 != this.lastLoadedTs) {
                        this.loadInternal();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void loadInternal() {
        int tree = 1;
        int ore = 1;
        int fr = 1;
        int ho = 2;
        int fish = 1;
        try {
            List<String> lines = Files.readAllLines(this.path, StandardCharsets.UTF_8);
            for (String raw : lines) {
                int i;
                String line = raw.trim();
                if (line.isEmpty() || line.startsWith("#") || (i = line.indexOf(61)) <= 0) continue;
                String key = line.substring(0, i).trim().toUpperCase(Locale.ROOT);
                String val = line.substring(i + 1).trim();
                try {
                    int v = Integer.parseInt(val);
                    switch (key) {
                        case "XP_PER_TREE": {
                            tree = Math.max(0, v);
                            break;
                        }
                        case "XP_PER_ORE": {
                            ore = Math.max(0, v);
                            break;
                        }
                        case "XP_PER_FRIENDLY_KILL": {
                            fr = Math.max(0, v);
                            break;
                        }
                        case "XP_PER_HOSTILE_KILL": {
                            ho = Math.max(0, v);
                            break;
                        }
                        case "XP_PER_FISH": {
                            fish = Math.max(0, v);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.XP_TREE = tree;
        this.XP_ORE = ore;
        this.XP_FRIENDLY = fr;
        this.XP_HOSTILE = ho;
        this.XP_FISH = fish;
        try {
            this.lastLoadedTs = Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("[XpMod][Config] XP(T/O/FR/HO/FISH)=" + this.XP_TREE + "/" + this.XP_ORE + "/" + this.XP_FRIENDLY + "/" + this.XP_HOSTILE + "/" + this.XP_FISH);
    }

    public int xpPerTree() {
        return this.XP_TREE;
    }

    public int xpPerOre() {
        return this.XP_ORE;
    }

    public int xpPerFriendlyKill() {
        return this.XP_FRIENDLY;
    }

    public int xpPerHostileKill() {
        return this.XP_HOSTILE;
    }

    public int xpPerFish() {
        return this.XP_FISH;
    }

    public String snapshotString() {
        return "{XP_PER_TREE=" + this.XP_TREE + ", XP_PER_ORE=" + this.XP_ORE + ", XP_PER_FRIENDLY_KILL=" + this.XP_FRIENDLY + ", XP_PER_HOSTILE_KILL=" + this.XP_HOSTILE + ", XP_PER_FISH=" + this.XP_FISH + "}";
    }
}

