/*
 * Decompiled with CFR 0.152.
 */
package com.xp;

import com.xp.PacketXpSelfStats;
import com.xp.PermissionsUtil;
import com.xp.XpManager;
import com.xp.XpMod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import necesse.engine.commands.AutoComplete;
import necesse.engine.commands.ChatCommand;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.network.Packet;
import necesse.engine.network.client.Client;
import necesse.engine.network.packet.PacketChatMessage;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;

public class XpCommand
extends ChatCommand {
    public XpCommand() {
        super("xp", PermissionLevel.USER);
    }

    public boolean isCheat() {
        return false;
    }

    public String getUsage() {
        return "/xp (GUI)";
    }

    public String getAction() {
        return "XP, Ranks & Skills";
    }

    public String getCurrentUsage(Client c, Server s, ServerClient sc, String[] args) {
        return "Usage: /xp (GUI)";
    }

    public List<AutoComplete> autocomplete(Client c, Server s, ServerClient sc, String[] args) {
        return Collections.emptyList();
    }

    public boolean run(Client client, Server server, ServerClient sc, ArrayList<String> args, CommandLog log) {
        if (server == null && client != null) {
            if (args == null || args.isEmpty()) {
                try {
                    client.network.sendPacket((Packet)new PacketChatMessage(client.getSlot(), "/xp request"));
                }
                catch (Throwable t) {
                    System.out.println("[XpMod] Failed to send /xp request: " + String.valueOf(t));
                }
                return true;
            }
            return false;
        }
        if (server != null && sc != null) {
            if (args == null || args.isEmpty() || args.get(0).equalsIgnoreCase("request")) {
                this.sendSelfStatsPacket(sc);
                return true;
            }
            return this.runServerSide(sc, args);
        }
        if (server != null && sc == null) {
            log.add("[XP] This command is for players only.");
            return false;
        }
        return false;
    }

    private void sendSelfStatsPacket(ServerClient sc) {
        try {
            String name = XpMod.XP.snapshotName(sc);
            int xp = XpMod.XP.getXp(name);
            int totalPoints = XpMod.XP.getTotalSkillPoints(name);
            XpManager.PlayerSkills skills = XpMod.XP.getSkills(name);
            int used = skills != null ? skills.total() : 0;
            int free = Math.max(0, totalPoints - used);
            String bonusText = XpMod.getJobBonusText(sc);
            PacketXpSelfStats p = new PacketXpSelfStats(sc, name, sc.getName(), xp, free, skills, bonusText);
            sc.sendPacket((Packet)p);
        }
        catch (Throwable t) {
            System.out.println("[XpMod] sendSelfStatsPacket error: " + String.valueOf(t));
        }
    }

    private boolean runServerSide(ServerClient sc, ArrayList<String> args) {
        String sub;
        switch (sub = args.get(0).toLowerCase(Locale.ROOT)) {
            case "info": {
                XpMod.XP.showInfo(sc);
                return true;
            }
            case "top": {
                int limit = 10;
                if (args.size() >= 2) {
                    try {
                        limit = Integer.parseInt(args.get(1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (limit <= 0) {
                    limit = 10;
                }
                XpMod.XP.showTop(sc, limit);
                return true;
            }
            case "cfg": {
                if (!PermissionsUtil.isAdminOrOwner(sc)) {
                    XpMod.XP.send(sc, "[XP] No permission.");
                    return false;
                }
                XpMod.XP.showConfig(sc);
                return true;
            }
            case "reload": 
            case "reloadcfg": {
                if (!PermissionsUtil.isAdminOrOwner(sc)) {
                    XpMod.XP.send(sc, "[XP] No permission.");
                    return false;
                }
                XpMod.XP.reloadConfig(sc);
                return true;
            }
            case "set": {
                return this.handleSet(sc, args);
            }
            case "skill": {
                return this.handleSkill(sc, args);
            }
            case "reset": {
                return this.handleReset(sc);
            }
        }
        XpMod.XP.send(sc, "[XP] Unknown command.");
        return false;
    }

    private boolean handleSet(ServerClient sc, ArrayList<String> args) {
        int newXp;
        if (!PermissionsUtil.isAdminOrOwner(sc)) {
            XpMod.XP.send(sc, "[XP] No permission.");
            return false;
        }
        if (args.size() < 3) {
            XpMod.XP.send(sc, "[XP] Usage: /xp set <nick> <xp>");
            return false;
        }
        String nickArg = args.get(1);
        try {
            newXp = Math.max(0, Integer.parseInt(args.get(2)));
        }
        catch (NumberFormatException ex) {
            XpMod.XP.send(sc, "[XP] Invalid XP number.");
            return false;
        }
        XpMod.XP.adminSetXp(sc, nickArg, newXp);
        return true;
    }

    private boolean handleSkill(ServerClient sc, ArrayList<String> args) {
        int resil;
        int armor;
        int dmg;
        int crit;
        int speed;
        int mana;
        int hp;
        if (args.size() < 8) {
            XpMod.XP.send(sc, "[XP] Usage: /xp skill <hp> <mana> <speed> <crit> <damage> <armor> <resilience>");
            XpMod.XP.showInfo(sc);
            return false;
        }
        String name = XpMod.XP.snapshotName(sc);
        try {
            hp = Integer.parseInt(args.get(1));
            mana = Integer.parseInt(args.get(2));
            speed = Integer.parseInt(args.get(3));
            crit = Integer.parseInt(args.get(4));
            dmg = Integer.parseInt(args.get(5));
            armor = Integer.parseInt(args.get(6));
            resil = Integer.parseInt(args.get(7));
        }
        catch (NumberFormatException e) {
            XpMod.XP.send(sc, "[XP] Invalid number.");
            return false;
        }
        if (hp < 0 || mana < 0 || speed < 0 || crit < 0 || dmg < 0 || armor < 0 || resil < 0) {
            XpMod.XP.send(sc, "[XP] All values must be >= 0.");
            return false;
        }
        int used = hp + mana + speed + crit + dmg + armor + resil;
        int totalPoints = XpMod.XP.getTotalSkillPoints(name);
        if (used > totalPoints) {
            XpMod.XP.send(sc, "[XP] Not enough skill points! Total: " + totalPoints + ", trying: " + used);
            return false;
        }
        boolean ok = XpMod.XP.setSkills(name, hp, mana, speed, crit, dmg, armor, resil);
        if (!ok) {
            XpMod.XP.send(sc, "[XP] Could not set skills (validation failed).");
            return false;
        }
        XpMod.XP.refreshSkillBuff(sc);
        XpMod.XP.send(sc, "[XP] Skill points updated.");
        return true;
    }

    private boolean handleReset(ServerClient sc) {
        String name = XpMod.XP.snapshotName(sc);
        XpMod.XP.resetSkills(name);
        XpMod.XP.refreshSkillBuff(sc);
        XpMod.XP.send(sc, "[XP] Skill points reset.");
        return true;
    }
}

