/*
 * Decompiled with CFR 0.152.
 */
package com.xp;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Locale;

public final class XpBannerConfig {
    private static final Path PATH = Paths.get("xp_banner_settings.txt", new String[0]);
    private float spawnRate = 1.0f;
    private float spawnCap = 1.0f;

    public XpBannerConfig() {
        this.initFile();
        this.load();
    }

    private void initFile() {
        if (Files.exists(PATH, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(PATH, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                bw.write("# Banner of War settings\n");
                bw.write("# 1.0 = vanilla, 0.0 = disabled\n\n");
                bw.write("BANNER_SPAWN_RATE=0.0\n");
                bw.write("BANNER_SPAWN_CAP=0.0\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void load() {
        try {
            List<String> lines = Files.readAllLines(PATH, StandardCharsets.UTF_8);
            for (String raw : lines) {
                int i;
                String line = raw.trim();
                if (line.isEmpty() || line.startsWith("#") || (i = line.indexOf(61)) <= 0) continue;
                String key = line.substring(0, i).trim().toUpperCase(Locale.ROOT);
                String val = line.substring(i + 1).trim();
                try {
                    float f = Float.parseFloat(val);
                    switch (key) {
                        case "BANNER_SPAWN_RATE": {
                            this.spawnRate = Math.max(0.0f, f);
                            break;
                        }
                        case "BANNER_SPAWN_CAP": {
                            this.spawnCap = Math.max(0.0f, f);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public float getSpawnRate() {
        return this.spawnRate;
    }

    public float getSpawnCap() {
        return this.spawnCap;
    }
}

