/*
 * Decompiled with CFR 0.152.
 */
package com.xp;

import com.xp.XpManager;
import com.xp.XpMod;
import com.xp.XpTopForm;
import java.util.ArrayList;
import java.util.List;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;

public class PacketXpTopResponse
extends Packet {
    private final List<Entry> entries;

    public PacketXpTopResponse(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader((Packet)this);
        int count = reader.getNextByteUnsigned();
        ArrayList<Entry> list = new ArrayList<Entry>();
        int i = 0;
        while (i < count) {
            String name = reader.getNextString();
            int xp = reader.getNextInt();
            int rankIndex = reader.getNextInt();
            String rank = reader.getNextString();
            list.add(new Entry(name, xp, rankIndex, rank));
            ++i;
        }
        this.entries = list;
    }

    public PacketXpTopResponse(List<XpManager.TopEntry> top) {
        ArrayList<Entry> list = new ArrayList<Entry>();
        int count = top == null ? 0 : Math.min(255, top.size());
        PacketWriter writer = new PacketWriter((Packet)this);
        writer.putNextByteUnsigned(count);
        int i = 0;
        while (i < count) {
            XpManager.TopEntry e = top.get(i);
            String name = e.name;
            int xp = e.xp;
            int rankIndex = XpMod.XP.getRankIndexForXp(xp);
            String rank = XpMod.getRankForXp(xp);
            writer.putNextString(name);
            writer.putNextInt(xp);
            writer.putNextInt(rankIndex);
            writer.putNextString(rank);
            list.add(new Entry(name, xp, rankIndex, rank));
            ++i;
        }
        this.entries = list;
    }

    public void processServer(NetworkPacket packet, Server server, ServerClient client) {
    }

    public void processClient(NetworkPacket packet, Client client) {
        try {
            if (XpTopForm.INSTANCE != null) {
                XpTopForm.INSTANCE.applyTopEntries(this.entries);
            }
        }
        catch (Throwable t) {
            System.out.println("[XpMod] Failed to apply XP top on client: " + String.valueOf(t));
        }
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public static class Entry {
        public final String name;
        public final int xp;
        public final int rankIndex;
        public final String rankName;

        public Entry(String name, int xp, int rankIndex, String rankName) {
            this.name = name;
            this.xp = xp;
            this.rankIndex = rankIndex;
            this.rankName = rankName;
        }
    }
}

