/*
 * Decompiled with CFR 0.152.
 */
package com.xp;

import com.xp.XpGuiForm;
import com.xp.XpManager;
import necesse.engine.GlobalData;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.state.MainGame;
import necesse.engine.state.State;
import necesse.gfx.forms.MainGameFormManager;
import necesse.gfx.forms.components.FormComponent;

public class PacketXpSelfStats
extends Packet {
    public final String canonicalName;
    public final String displayName;
    public final int xp;
    public final int freePoints;
    public final int hp;
    public final int mana;
    public final int speed;
    public final int crit;
    public final int damage;
    public final int armor;
    public final int resilience;
    public final String jobBonusText;

    public PacketXpSelfStats(ServerClient sc, String canonicalName, String displayName, int xp, int freePoints, XpManager.PlayerSkills skills, String jobBonusText) {
        this.canonicalName = canonicalName != null ? canonicalName : "unknown";
        this.displayName = displayName != null ? displayName : this.canonicalName;
        this.xp = xp;
        this.freePoints = freePoints;
        if (skills == null) {
            skills = new XpManager.PlayerSkills();
        }
        this.hp = skills.health;
        this.mana = skills.mana;
        this.speed = skills.speed;
        this.crit = skills.crit;
        this.damage = skills.damage;
        this.armor = skills.armor;
        this.resilience = skills.resilience;
        this.jobBonusText = jobBonusText != null ? jobBonusText : "";
        PacketWriter w = new PacketWriter((Packet)this);
        w.putNextString(this.canonicalName);
        w.putNextString(this.displayName);
        w.putNextInt(this.xp);
        w.putNextInt(this.freePoints);
        w.putNextInt(this.hp);
        w.putNextInt(this.mana);
        w.putNextInt(this.speed);
        w.putNextInt(this.crit);
        w.putNextInt(this.damage);
        w.putNextInt(this.armor);
        w.putNextInt(this.resilience);
        w.putNextString(this.jobBonusText);
    }

    public PacketXpSelfStats(byte[] data) {
        super(data);
        PacketReader r = new PacketReader((Packet)this);
        this.canonicalName = r.getNextString();
        this.displayName = r.getNextString();
        this.xp = r.getNextInt();
        this.freePoints = r.getNextInt();
        this.hp = r.getNextInt();
        this.mana = r.getNextInt();
        this.speed = r.getNextInt();
        this.crit = r.getNextInt();
        this.damage = r.getNextInt();
        this.armor = r.getNextInt();
        this.resilience = r.getNextInt();
        String bonus = "";
        try {
            bonus = r.getNextString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jobBonusText = bonus != null ? bonus : "";
    }

    public void processServer(NetworkPacket packet, Server server, ServerClient client) {
    }

    /*
     * WARNING - void declaration
     */
    public void processClient(NetworkPacket packet, Client client) {
        try {
            void mg;
            State state = GlobalData.getCurrentState();
            if (!(state instanceof MainGame)) {
                return;
            }
            MainGame mainGame = (MainGame)state;
            MainGameFormManager fm = mg.formManager;
            if (fm == null) {
                return;
            }
            XpManager.PlayerSkills skills = new XpManager.PlayerSkills(this.hp, this.mana, this.speed, this.crit, this.damage, this.armor, this.resilience);
            XpGuiForm form = new XpGuiForm(client, fm, this.canonicalName, this.displayName, this.xp, this.freePoints, skills, this.jobBonusText);
            fm.addComponent((FormComponent)form);
            form.setHidden(false);
        }
        catch (Throwable t) {
            System.out.println("[XpMod] PacketXpSelfStats.processClient error: " + String.valueOf(t));
        }
    }
}

