/*
 * Decompiled with CFR 0.152.
 */
package com.xp;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import necesse.engine.network.server.ServerClient;

public final class JobsCompat {
    private static volatile boolean resolved = false;
    private static volatile boolean available = false;
    private static Object jobsManagerInstance;
    private static Method mGetJob;
    private static Method mGetRank;

    private JobsCompat() {
    }

    private static void resolve() {
        if (resolved) {
            return;
        }
        resolved = true;
        try {
            Class<?> jobsModClz = Class.forName("com.jobs.JobsMod");
            Field fJobs = jobsModClz.getDeclaredField("JOBS");
            fJobs.setAccessible(true);
            jobsManagerInstance = fJobs.get(null);
            if (jobsManagerInstance == null) {
                available = false;
                return;
            }
            Class<?> jobsManagerClz = jobsManagerInstance.getClass();
            mGetJob = jobsManagerClz.getMethod("getJob", ServerClient.class);
            mGetRank = jobsManagerClz.getMethod("getRank", ServerClient.class);
            available = true;
            System.out.println("[XpMod] JobsCompat: JobsMod detected, job bonus enabled.");
        }
        catch (Throwable t) {
            available = false;
            jobsManagerInstance = null;
            mGetJob = null;
            mGetRank = null;
            System.out.println("[XpMod] JobsCompat: JobsMod not found (OK). Job bonus disabled.");
        }
    }

    /*
     * Loose catch block
     */
    public static int getRankIfJobMatches(ServerClient sc, String expectedJobName) {
        Object rankObj;
        block13: {
            block12: {
                String jobName;
                Object jobEnum;
                block11: {
                    if (sc == null || expectedJobName == null) {
                        return 0;
                    }
                    JobsCompat.resolve();
                    if (!available) {
                        return 0;
                    }
                    jobEnum = mGetJob.invoke(jobsManagerInstance, sc);
                    if (jobEnum != null) break block11;
                    return 0;
                    {
                        catch (Throwable t) {
                            return 0;
                        }
                    }
                }
                try {
                    Method mName = jobEnum.getClass().getMethod("name", new Class[0]);
                    jobName = String.valueOf(mName.invoke(jobEnum, new Object[0]));
                }
                catch (Throwable ignored) {
                    jobName = String.valueOf(jobEnum);
                }
                if (expectedJobName.equalsIgnoreCase(jobName)) break block12;
                return 0;
            }
            rankObj = mGetRank.invoke(jobsManagerInstance, sc);
            if (!(rankObj instanceof Integer)) break block13;
            return Math.max(0, (Integer)rankObj);
        }
        try {
            return Math.max(0, Integer.parseInt(String.valueOf(rankObj)));
        }
        catch (Throwable ignored) {
            return 0;
        }
    }
}

