/*
 * Decompiled with CFR 0.152.
 */
package com.xp;

import com.xp.XpMod;
import java.lang.reflect.Field;
import java.util.LinkedList;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketChatMessage;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.gfx.GameColor;
import necesse.gfx.fairType.FairType;
import necesse.gfx.forms.components.chat.ChatMessage;
import necesse.gfx.forms.components.chat.ChatMessageList;
import necesse.gfx.forms.components.chat.ChatMessageListener;
import net.bytebuddy.asm.Advice;

public class EternalChatColorMod {
    public static void onModLoad() {
        System.out.println("[EternalChatColor] Loaded from XpMod");
    }

    public static boolean handleChat(PacketChatMessage packet, Server server, ServerClient client) {
        int idx;
        String clean;
        String text;
        block13: {
            block12: {
                GameMessage gm;
                block11: {
                    block10: {
                        block9: {
                            try {
                                if (server != null && client != null) break block9;
                                return false;
                            }
                            catch (Throwable t) {
                                System.out.println("[EternalChatColor] Error in handleChat: " + String.valueOf(t));
                                return false;
                            }
                        }
                        if (packet.slot == client.slot) break block10;
                        return false;
                    }
                    gm = packet.gameMessage;
                    if (gm != null) break block11;
                    return false;
                }
                text = gm.translate();
                if (text != null && !text.isEmpty()) break block12;
                return false;
            }
            if (!text.startsWith("/")) break block13;
            return false;
        }
        String name = client.getName();
        if (name == null || name.isEmpty()) {
            name = "N/A";
        }
        int xp = XpMod.XP.getXp(name);
        String rankName = XpMod.getRankForXp(xp);
        int rankIndex = XpMod.XP.getRankIndexForXp(xp);
        String rankColor = EternalChatColorMod.getRankColorCodeDynamic(rankIndex);
        String nameColor = EternalChatColorMod.getNameColorCode(client);
        String reset = GameColor.WHITE.getColorCode();
        String formatted = rankColor + "[" + rankName + "]" + reset + " " + nameColor + name + reset + ": " + text;
        PacketChatMessage coloredPacket = new PacketChatMessage(formatted);
        server.network.sendToAllClientsExcept((Packet)coloredPacket, null);
        String cleanNoRank = clean = GameColor.stripCodes((String)formatted);
        if (clean.startsWith("[") && (idx = clean.indexOf(93)) != -1 && idx + 2 <= clean.length()) {
            cleanNoRank = clean.substring(idx + 2);
        }
        System.out.println(cleanNoRank);
        return true;
    }

    private static String getNameColorCode(ServerClient client) {
        return GameColor.GREEN.getColorCode();
    }

    private static String getRankColorCodeDynamic(int rankIndex) {
        try {
            if (rankIndex < 0) {
                return GameColor.WHITE.getColorCode();
            }
            int count = XpMod.XP.getRankCount();
            if (count <= 0) {
                return GameColor.WHITE.getColorCode();
            }
            int lastIndex = count - 1;
            int secondLastIndex = count - 2;
            if (rankIndex == lastIndex) {
                return GameColor.CYAN.getColorCode();
            }
            if (rankIndex == secondLastIndex) {
                return GameColor.YELLOW.getColorCode();
            }
            return GameColor.WHITE.getColorCode();
        }
        catch (Throwable t) {
            return GameColor.WHITE.getColorCode();
        }
    }

    @ModMethodPatch(target=ChatMessageList.class, name="addMessage", arguments={String.class})
    public static class PatchClientDuplicateFilter {
        @Advice.OnMethodEnter
        public static void onEnter(@Advice.This ChatMessageList self, @Advice.Argument(value=0) String message) {
            try {
                int idx;
                String visible;
                if (message == null) {
                    return;
                }
                if (message.indexOf(167) == -1) {
                    return;
                }
                String visibleWithoutRank = visible = GameColor.stripCodes((String)message);
                if (visible.startsWith("[") && (idx = visible.indexOf(93)) != -1 && idx + 2 <= visible.length()) {
                    visibleWithoutRank = visible.substring(idx + 2);
                }
                Field messagesField = ChatMessageList.class.getDeclaredField("messages");
                messagesField.setAccessible(true);
                LinkedList list = (LinkedList)messagesField.get(self);
                if (list.isEmpty()) {
                    return;
                }
                ChatMessage last = (ChatMessage)list.getLast();
                if (last == null || last.type == null) {
                    return;
                }
                FairType lastType = last.type;
                String lastStr = lastType.getParseString();
                if (lastStr == null) {
                    return;
                }
                if (lastStr.indexOf(167) == -1 && lastStr.equals(visibleWithoutRank)) {
                    list.removeLast();
                    Field listenersField = ChatMessageList.class.getDeclaredField("listeners");
                    listenersField.setAccessible(true);
                    LinkedList listeners = (LinkedList)listenersField.get(self);
                    for (ChatMessageListener l : listeners) {
                        try {
                            l.onRemoveMessage(last);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    System.out.println("[EternalChatColor] Removed duplicate plain chat: " + lastStr);
                }
            }
            catch (Throwable t) {
                System.out.println("[EternalChatColor] Error cleaning duplicates: " + String.valueOf(t));
            }
        }
    }

    @ModMethodPatch(target=PacketChatMessage.class, name="processServer", arguments={NetworkPacket.class, Server.class, ServerClient.class})
    public static class PatchServerChat {
        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        public static boolean onEnter(@Advice.This PacketChatMessage self, @Advice.Argument(value=0) NetworkPacket packet, @Advice.Argument(value=1) Server server, @Advice.Argument(value=2) ServerClient client) {
            return EternalChatColorMod.handleChat(self, server, client);
        }
    }
}

