/*
 * Decompiled with CFR 0.152.
 */
package com.settlementguard.patches;

import com.settlementguard.AnimalMsg;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.server.ServerClient;
import necesse.engine.world.WorldEntityGameClock;
import necesse.engine.world.worldData.SettlementsWorldData;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.level.maps.Level;
import necesse.level.maps.levelData.settlementData.CachedSettlementData;
import necesse.level.maps.levelData.settlementData.NetworkSettlementData;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=Projectile.class, name="hit", arguments={Mob.class, float.class, float.class, boolean.class, ServerClient.class})
public class ProtectProjectileHitPatch {
    private static final boolean DEBUG = false;

    @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
    public static boolean onEnter(@Advice.This Projectile proj, @Advice.Argument(value=0) Mob mob, @Advice.Argument(value=1) float xdir, @Advice.Argument(value=2) float ydir, @Advice.Argument(value=3) boolean crit, @Advice.Argument(value=4) ServerClient sc) {
        Claim claim;
        block14: {
            block13: {
                Level level;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                if (mob != null) break block9;
                                return false;
                            }
                            level = ProtectProjectileHitPatch.safeGetLevel(mob);
                            if (level != null && ProtectProjectileHitPatch.isServerLevel(level)) break block10;
                            return false;
                        }
                        if (!(mob instanceof PlayerMob)) break block11;
                        return false;
                    }
                    if (!ProtectProjectileHitPatch.isHostile(mob)) break block12;
                    return false;
                }
                int tx = ProtectProjectileHitPatch.toTile(level, ProtectProjectileHitPatch.safeGetX(mob));
                int ty = ProtectProjectileHitPatch.toTile(level, ProtectProjectileHitPatch.safeGetY(mob));
                claim = ProtectProjectileHitPatch.getClaimAt(level, tx, ty);
                if (claim != null && claim.hasOwner) break block13;
                return false;
            }
            if (sc != null) break block14;
            return false;
        }
        try {
            if (!ProtectProjectileHitPatch.isOwnerOrTeam(claim, sc)) {
                AnimalMsg.trySendEvery2Min(sc);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static Claim getClaimAt(Level level, int tx, int ty) {
        try {
            SettlementsWorldData world = SettlementsWorldData.getSettlementsData((WorldEntityGameClock)level);
            NetworkSettlementData net = world.getNetworkDataAtTile(level.getIdentifier(), tx, ty);
            if (net != null && net.hasOwner()) {
                long owner = ProtectProjectileHitPatch.safeGetOwnerAuthFromNet(net);
                if (owner == -1L) {
                }
                int team = ProtectProjectileHitPatch.safeGetTeamIDFromNet(net);
                return new Claim(true, owner, team, net);
            }
            CachedSettlementData cached = world.getCachedDataAtTile(level.getIdentifier(), tx, ty);
            if (cached == null) {
            }
            long owner = ProtectProjectileHitPatch.safeGetOwnerAuthFromCached(cached);
            if (owner == -1L) {
            }
            int team = ProtectProjectileHitPatch.safeGetTeamIDFromCached(cached);
            return new Claim(true, owner, team, null);
        }
        finally {
            return null;
        }
    }

    private static boolean isOwnerOrTeam(Claim claim, ServerClient sc) {
        if (claim == null || sc == null) {
            return false;
        }
        if (sc.authentication == claim.ownerAuth) {
            return true;
        }
        try {
            if (claim.teamID > 0 && sc.getTeamID() == claim.teamID) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (claim.net != null) {
            try {
                return claim.net.streamTeamMembers().anyMatch(m -> m != null && m.authentication == serverClient.authentication);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static long safeGetOwnerAuthFromNet(NetworkSettlementData net) {
        try {
            return net.getOwnerAuth();
        }
        catch (Throwable throwable) {
            try {
                Method m = net.getClass().getMethod("getOwnerAuth", new Class[0]);
                Object r = m.invoke((Object)net, new Object[0]);
                if (r instanceof Number) {
                    return ((Number)r).longValue();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return -1L;
        }
    }

    private static int safeGetTeamIDFromNet(NetworkSettlementData net) {
        Object r;
        try {
            Method m = net.getClass().getMethod("getTeamID", new Class[0]);
            r = m.invoke((Object)net, new Object[0]);
            if (r instanceof Number) {
                return ((Number)r).intValue();
            }
        }
        catch (Throwable m) {
            // empty catch block
        }
        try {
            Field f = net.getClass().getDeclaredField("teamID");
            f.setAccessible(true);
            r = f.get(net);
            if (r instanceof Number) {
                return ((Number)r).intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    private static long safeGetOwnerAuthFromCached(CachedSettlementData cached) {
        try {
            return cached.getOwnerAuth();
        }
        catch (Throwable throwable) {
            Object r;
            try {
                Method m = cached.getClass().getMethod("getOwnerAuth", new Class[0]);
                r = m.invoke((Object)cached, new Object[0]);
                if (r instanceof Number) {
                    return ((Number)r).longValue();
                }
            }
            catch (Throwable m) {
                // empty catch block
            }
            try {
                Field f = cached.getClass().getDeclaredField("ownerAuth");
                f.setAccessible(true);
                r = f.get(cached);
                if (r instanceof Number) {
                    return ((Number)r).longValue();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return -1L;
        }
    }

    private static int safeGetTeamIDFromCached(CachedSettlementData cached) {
        try {
            return cached.getTeamID();
        }
        catch (Throwable throwable) {
            Object r;
            try {
                Method m = cached.getClass().getMethod("getTeamID", new Class[0]);
                r = m.invoke((Object)cached, new Object[0]);
                if (r instanceof Number) {
                    return ((Number)r).intValue();
                }
            }
            catch (Throwable m) {
                // empty catch block
            }
            try {
                Field f = cached.getClass().getDeclaredField("teamID");
                f.setAccessible(true);
                r = f.get(cached);
                if (r instanceof Number) {
                    return ((Number)r).intValue();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return 0;
        }
    }

    public static boolean isServerLevel(Level level) {
        try {
            return level.isServer();
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static float safeGetX(Mob mob) throws Exception {
        try {
            return mob.x;
        }
        catch (Throwable throwable) {
            Method mx = Mob.class.getMethod("getX", new Class[0]);
            return ((Number)mx.invoke((Object)mob, new Object[0])).floatValue();
        }
    }

    public static float safeGetY(Mob mob) throws Exception {
        try {
            return mob.y;
        }
        catch (Throwable throwable) {
            Method my = Mob.class.getMethod("getY", new Class[0]);
            return ((Number)my.invoke((Object)mob, new Object[0])).floatValue();
        }
    }

    public static Level safeGetLevel(Mob mob) {
        try {
            return mob.getLevel();
        }
        catch (Throwable throwable) {
            try {
                Method m = Mob.class.getMethod("getLevel", new Class[0]);
                Object r = m.invoke((Object)mob, new Object[0]);
                return r instanceof Level ? (Level)r : null;
            }
            catch (Throwable ignore) {
                return null;
            }
        }
    }

    public static int toTile(Level level, float v) {
        try {
            Method m = Level.class.getMethod("toTile", Float.TYPE);
            Object r = m.invoke(null, Float.valueOf(v));
            if (r instanceof Integer) {
                return (Integer)r;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return (int)Math.floor(v / 32.0f);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isHostile(Mob mob) {
        try {
            f = Mob.class.getField("isHostile");
            if (Boolean.TRUE.equals(f.get(mob))) {
                return true;
            }
            ** GOTO lbl-1000
        }
        catch (Throwable f) {
            try lbl-1000:
            // 2 sources

            {
                try {
                    m = Mob.class.getMethod("isHostile", new Class[0]);
                    r = m.invoke((Object)mob, new Object[0]);
                    if (r instanceof Boolean == false) return false;
                    if ((Boolean)r == false) return false;
                    return true;
                }
                catch (Throwable var1_3) {
                    return false;
                }
            }
            catch (Throwable var1_4) {
                // empty catch block
            }
        }
        return false;
    }

    private static final class Claim {
        final boolean hasOwner;
        final long ownerAuth;
        final int teamID;
        final NetworkSettlementData net;

        Claim(boolean hasOwner, long ownerAuth, int teamID, NetworkSettlementData net) {
            this.hasOwner = hasOwner;
            this.ownerAuth = ownerAuth;
            this.teamID = teamID;
            this.net = net;
        }
    }
}

