/*
 * Decompiled with CFR 0.152.
 */
package com.settlementguard.patches;

import com.settlementguard.AnimalMsg;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.server.ServerClient;
import necesse.engine.world.WorldEntityGameClock;
import necesse.engine.world.worldData.SettlementsWorldData;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobWasHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.level.maps.Level;
import necesse.level.maps.levelData.settlementData.CachedSettlementData;
import necesse.level.maps.levelData.settlementData.NetworkSettlementData;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=Mob.class, name="isServerHit", arguments={GameDamage.class, float.class, float.class, float.class, Attacker.class})
public class ProtectMobIsServerHitPatch {
    private static final boolean DEBUG = false;

    @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
    public static boolean onEnter(@Advice.This Mob mob, @Advice.Argument(value=0) GameDamage dmg, @Advice.Argument(value=1) float dirX, @Advice.Argument(value=2) float dirY, @Advice.Argument(value=3) float knockback, @Advice.Argument(value=4) Attacker attacker) {
        ServerClient sc;
        Claim claim;
        block13: {
            Mob atkMob;
            block12: {
                Level level;
                block11: {
                    block10: {
                        block9: {
                            level = ProtectMobIsServerHitPatch.safeGetLevel(mob);
                            if (level != null && ProtectMobIsServerHitPatch.isServerLevel(level)) break block9;
                            return false;
                        }
                        if (!(mob instanceof PlayerMob)) break block10;
                        return false;
                    }
                    if (!ProtectMobIsServerHitPatch.isHostile(mob)) break block11;
                    return false;
                }
                int tx = ProtectMobIsServerHitPatch.toTile(level, ProtectMobIsServerHitPatch.safeGetX(mob));
                int ty = ProtectMobIsServerHitPatch.toTile(level, ProtectMobIsServerHitPatch.safeGetY(mob));
                claim = ProtectMobIsServerHitPatch.getClaimAt(level, tx, ty);
                if (claim != null && claim.hasOwner) break block12;
                return false;
            }
            sc = ProtectMobIsServerHitPatch.getServerClientFromAttacker(attacker);
            if (sc == null && (atkMob = ProtectMobIsServerHitPatch.getMobFromAttacker(attacker)) != null) {
                sc = ProtectMobIsServerHitPatch.resolveServerClientFromMobChain(atkMob, 6);
            }
            if (sc != null) break block13;
            return false;
        }
        try {
            if (!ProtectMobIsServerHitPatch.isOwnerOrTeam(claim, sc)) {
                AnimalMsg.trySendEvery2Min(sc);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Advice.OnMethodExit
    public static void onExit(@Advice.Enter boolean skipped, @Advice.Return(readOnly=false) MobWasHitEvent ret) {
        if (skipped) {
            ret = null;
        }
    }

    private static Claim getClaimAt(Level level, int tx, int ty) {
        try {
            SettlementsWorldData world = SettlementsWorldData.getSettlementsData((WorldEntityGameClock)level);
            NetworkSettlementData net = world.getNetworkDataAtTile(level.getIdentifier(), tx, ty);
            if (net != null && net.hasOwner()) {
                long owner = ProtectMobIsServerHitPatch.safeGetOwnerAuthFromNet(net);
                if (owner == -1L) {
                }
                int team = ProtectMobIsServerHitPatch.safeGetTeamIDFromNet(net);
                return new Claim(true, owner, team, net);
            }
            CachedSettlementData cached = world.getCachedDataAtTile(level.getIdentifier(), tx, ty);
            if (cached == null) {
            }
            long owner = ProtectMobIsServerHitPatch.safeGetOwnerAuthFromCached(cached);
            if (owner == -1L) {
            }
            int team = ProtectMobIsServerHitPatch.safeGetTeamIDFromCached(cached);
            return new Claim(true, owner, team, null);
        }
        finally {
            return null;
        }
    }

    private static boolean isOwnerOrTeam(Claim claim, ServerClient sc) {
        if (claim == null || sc == null) {
            return false;
        }
        if (sc.authentication == claim.ownerAuth) {
            return true;
        }
        try {
            if (claim.teamID > 0 && sc.getTeamID() == claim.teamID) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (claim.net != null) {
            try {
                return claim.net.streamTeamMembers().anyMatch(m -> m != null && m.authentication == serverClient.authentication);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static long safeGetOwnerAuthFromNet(NetworkSettlementData net) {
        try {
            return net.getOwnerAuth();
        }
        catch (Throwable throwable) {
            try {
                Method m = net.getClass().getMethod("getOwnerAuth", new Class[0]);
                Object r = m.invoke((Object)net, new Object[0]);
                if (r instanceof Number) {
                    return ((Number)r).longValue();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return -1L;
        }
    }

    private static int safeGetTeamIDFromNet(NetworkSettlementData net) {
        Object r;
        try {
            Method m = net.getClass().getMethod("getTeamID", new Class[0]);
            r = m.invoke((Object)net, new Object[0]);
            if (r instanceof Number) {
                return ((Number)r).intValue();
            }
        }
        catch (Throwable m) {
            // empty catch block
        }
        try {
            Field f = net.getClass().getDeclaredField("teamID");
            f.setAccessible(true);
            r = f.get(net);
            if (r instanceof Number) {
                return ((Number)r).intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    private static long safeGetOwnerAuthFromCached(CachedSettlementData cached) {
        try {
            return cached.getOwnerAuth();
        }
        catch (Throwable throwable) {
            Object r;
            try {
                Method m = cached.getClass().getMethod("getOwnerAuth", new Class[0]);
                r = m.invoke((Object)cached, new Object[0]);
                if (r instanceof Number) {
                    return ((Number)r).longValue();
                }
            }
            catch (Throwable m) {
                // empty catch block
            }
            try {
                Field f = cached.getClass().getDeclaredField("ownerAuth");
                f.setAccessible(true);
                r = f.get(cached);
                if (r instanceof Number) {
                    return ((Number)r).longValue();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return -1L;
        }
    }

    private static int safeGetTeamIDFromCached(CachedSettlementData cached) {
        try {
            return cached.getTeamID();
        }
        catch (Throwable throwable) {
            Object r;
            try {
                Method m = cached.getClass().getMethod("getTeamID", new Class[0]);
                r = m.invoke((Object)cached, new Object[0]);
                if (r instanceof Number) {
                    return ((Number)r).intValue();
                }
            }
            catch (Throwable m) {
                // empty catch block
            }
            try {
                Field f = cached.getClass().getDeclaredField("teamID");
                f.setAccessible(true);
                r = f.get(cached);
                if (r instanceof Number) {
                    return ((Number)r).intValue();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return 0;
        }
    }

    public static boolean isServerLevel(Level level) {
        try {
            return level.isServer();
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static float safeGetX(Mob mob) throws Exception {
        try {
            return mob.x;
        }
        catch (Throwable throwable) {
            Method mx = Mob.class.getMethod("getX", new Class[0]);
            return ((Number)mx.invoke((Object)mob, new Object[0])).floatValue();
        }
    }

    public static float safeGetY(Mob mob) throws Exception {
        try {
            return mob.y;
        }
        catch (Throwable throwable) {
            Method my = Mob.class.getMethod("getY", new Class[0]);
            return ((Number)my.invoke((Object)mob, new Object[0])).floatValue();
        }
    }

    public static Level safeGetLevel(Mob mob) {
        try {
            return mob.getLevel();
        }
        catch (Throwable throwable) {
            try {
                Method m = Mob.class.getMethod("getLevel", new Class[0]);
                Object r = m.invoke((Object)mob, new Object[0]);
                return r instanceof Level ? (Level)r : null;
            }
            catch (Throwable ignore) {
                return null;
            }
        }
    }

    public static int toTile(Level level, float v) {
        try {
            Method m = Level.class.getMethod("toTile", Float.TYPE);
            Object r = m.invoke(null, Float.valueOf(v));
            if (r instanceof Integer) {
                return (Integer)r;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return (int)Math.floor(v / 32.0f);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isHostile(Mob mob) {
        try {
            f = Mob.class.getField("isHostile");
            if (Boolean.TRUE.equals(f.get(mob))) {
                return true;
            }
            ** GOTO lbl-1000
        }
        catch (Throwable f) {
            try lbl-1000:
            // 2 sources

            {
                try {
                    m = Mob.class.getMethod("isHostile", new Class[0]);
                    r = m.invoke((Object)mob, new Object[0]);
                    if (r instanceof Boolean == false) return false;
                    if ((Boolean)r == false) return false;
                    return true;
                }
                catch (Throwable var1_3) {
                    return false;
                }
            }
            catch (Throwable var1_4) {
                // empty catch block
            }
        }
        return false;
    }

    public static ServerClient getServerClientFromAttacker(Attacker atk) {
        if (atk == null) {
            return null;
        }
        try {
            Method m = atk.getClass().getMethod("getServerClient", new Class[0]);
            Object r = m.invoke((Object)atk, new Object[0]);
            if (r instanceof ServerClient) {
                return (ServerClient)r;
            }
        }
        catch (Throwable m) {
            // empty catch block
        }
        try {
            Method gsc;
            Object r2;
            Method gp = atk.getClass().getMethod("getPlayer", new Class[0]);
            Object player = gp.invoke((Object)atk, new Object[0]);
            if (player != null && (r2 = (gsc = player.getClass().getMethod("getServerClient", new Class[0])).invoke(player, new Object[0])) instanceof ServerClient) {
                return (ServerClient)r2;
            }
        }
        catch (Throwable gp) {
            // empty catch block
        }
        Mob mob = ProtectMobIsServerHitPatch.getMobFromAttacker(atk);
        if (mob != null) {
            return ProtectMobIsServerHitPatch.resolveServerClientFromMobChain(mob, 6);
        }
        return null;
    }

    public static Mob getMobFromAttacker(Attacker atk) {
        Object r;
        if (atk == null) {
            return null;
        }
        try {
            Method gm = atk.getClass().getMethod("getMob", new Class[0]);
            r = gm.invoke((Object)atk, new Object[0]);
            if (r instanceof Mob) {
                return (Mob)r;
            }
        }
        catch (Throwable gm) {
            // empty catch block
        }
        try {
            Method go = atk.getClass().getMethod("getOwner", new Class[0]);
            r = go.invoke((Object)atk, new Object[0]);
            if (r instanceof Mob) {
                return (Mob)r;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static ServerClient resolveServerClientFromMobChain(Mob m, int depth) {
        if (m == null || depth <= 0) {
            return null;
        }
        try {
            Method gsc = m.getClass().getMethod("getServerClient", new Class[0]);
            Object r = gsc.invoke((Object)m, new Object[0]);
            if (r instanceof ServerClient) {
                return (ServerClient)r;
            }
        }
        catch (Throwable gsc) {
            // empty catch block
        }
        try {
            Method gfo = m.getClass().getMethod("getFirstAttackOwner", new Class[0]);
            Object owner = gfo.invoke((Object)m, new Object[0]);
            if (owner instanceof Mob) {
                return ProtectMobIsServerHitPatch.resolveServerClientFromMobChain((Mob)owner, depth - 1);
            }
        }
        catch (Throwable gfo) {
            // empty catch block
        }
        try {
            ServerClient sc;
            Method ga = m.getClass().getMethod("getAttacker", new Class[0]);
            Object atk = ga.invoke((Object)m, new Object[0]);
            if (atk instanceof Attacker && (sc = ProtectMobIsServerHitPatch.getServerClientFromAttacker((Attacker)atk)) != null) {
                return sc;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static final class Claim {
        final boolean hasOwner;
        final long ownerAuth;
        final int teamID;
        final NetworkSettlementData net;

        Claim(boolean hasOwner, long ownerAuth, int teamID, NetworkSettlementData net) {
            this.hasOwner = hasOwner;
            this.ownerAuth = ownerAuth;
            this.teamID = teamID;
            this.net = net;
        }
    }
}

