/*
 * Decompiled with CFR 0.152.
 */
package com.settlementguard.patches;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.server.ServerClient;
import necesse.engine.world.WorldEntityGameClock;
import necesse.engine.world.worldData.SettlementsWorldData;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.level.maps.Level;
import necesse.level.maps.levelData.settlementData.CachedSettlementData;
import necesse.level.maps.levelData.settlementData.NetworkSettlementData;
import net.bytebuddy.asm.Advice;

public final class ProtectAnimalsInteractPatch {
    private static boolean shouldSkipInteract(Mob mob, Level level, int tileX, int tileY, ServerClient sc) {
        Claim claim;
        block10: {
            block9: {
                block8: {
                    block7: {
                        if (level != null && ProtectAnimalsInteractPatch.isServerLevel(level)) break block7;
                        return false;
                    }
                    if (!ProtectAnimalsInteractPatch.isHostileOrAggressive(mob)) break block8;
                    return false;
                }
                claim = ProtectAnimalsInteractPatch.getClaimAt(level, tileX, tileY);
                if (claim != null && claim.hasOwner) break block9;
                return false;
            }
            if (sc != null) break block10;
            return false;
        }
        try {
            if (!ProtectAnimalsInteractPatch.isOwnerOrTeam(claim, sc)) {
                ProtectAnimalsInteractPatch.trySendMsg(sc, "This settlement is protected (animal).");
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static Claim getClaimAt(Level level, int tx, int ty) {
        try {
            SettlementsWorldData world = SettlementsWorldData.getSettlementsData((WorldEntityGameClock)level);
            NetworkSettlementData net = world.getNetworkDataAtTile(level.getIdentifier(), tx, ty);
            if (net != null && net.hasOwner()) {
                long owner = ProtectAnimalsInteractPatch.safeGetOwnerAuthFromNet(net);
                if (owner == -1L) {
                }
                int team = ProtectAnimalsInteractPatch.safeGetTeamIDFromNet(net);
                return new Claim(true, owner, team, net);
            }
            CachedSettlementData cached = world.getCachedDataAtTile(level.getIdentifier(), tx, ty);
            if (cached == null) {
            }
            long owner = ProtectAnimalsInteractPatch.safeGetOwnerAuthFromCached(cached);
            if (owner == -1L) {
            }
            int team = ProtectAnimalsInteractPatch.safeGetTeamIDFromCached(cached);
            return new Claim(true, owner, team, null);
        }
        finally {
            return null;
        }
    }

    private static boolean isOwnerOrTeam(Claim claim, ServerClient sc) {
        if (claim == null || sc == null) {
            return false;
        }
        if (sc.authentication == claim.ownerAuth) {
            return true;
        }
        try {
            if (claim.teamID > 0 && sc.getTeamID() == claim.teamID) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (claim.net != null) {
            try {
                return claim.net.streamTeamMembers().anyMatch(m -> m != null && m.authentication == serverClient.authentication);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static long safeGetOwnerAuthFromNet(NetworkSettlementData net) {
        try {
            return net.getOwnerAuth();
        }
        catch (Throwable throwable) {
            try {
                Method m = net.getClass().getMethod("getOwnerAuth", new Class[0]);
                Object r = m.invoke((Object)net, new Object[0]);
                if (r instanceof Number) {
                    return ((Number)r).longValue();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return -1L;
        }
    }

    private static int safeGetTeamIDFromNet(NetworkSettlementData net) {
        Object r;
        try {
            Method m = net.getClass().getMethod("getTeamID", new Class[0]);
            r = m.invoke((Object)net, new Object[0]);
            if (r instanceof Number) {
                return ((Number)r).intValue();
            }
        }
        catch (Throwable m) {
            // empty catch block
        }
        try {
            Field f = net.getClass().getDeclaredField("teamID");
            f.setAccessible(true);
            r = f.get(net);
            if (r instanceof Number) {
                return ((Number)r).intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    private static long safeGetOwnerAuthFromCached(CachedSettlementData cached) {
        try {
            return cached.getOwnerAuth();
        }
        catch (Throwable throwable) {
            Object r;
            try {
                Method m = cached.getClass().getMethod("getOwnerAuth", new Class[0]);
                r = m.invoke((Object)cached, new Object[0]);
                if (r instanceof Number) {
                    return ((Number)r).longValue();
                }
            }
            catch (Throwable m) {
                // empty catch block
            }
            try {
                Field f = cached.getClass().getDeclaredField("ownerAuth");
                f.setAccessible(true);
                r = f.get(cached);
                if (r instanceof Number) {
                    return ((Number)r).longValue();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return -1L;
        }
    }

    private static int safeGetTeamIDFromCached(CachedSettlementData cached) {
        try {
            return cached.getTeamID();
        }
        catch (Throwable throwable) {
            Object r;
            try {
                Method m = cached.getClass().getMethod("getTeamID", new Class[0]);
                r = m.invoke((Object)cached, new Object[0]);
                if (r instanceof Number) {
                    return ((Number)r).intValue();
                }
            }
            catch (Throwable m) {
                // empty catch block
            }
            try {
                Field f = cached.getClass().getDeclaredField("teamID");
                f.setAccessible(true);
                r = f.get(cached);
                if (r instanceof Number) {
                    return ((Number)r).intValue();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return 0;
        }
    }

    private static boolean isServerLevel(Level level) {
        try {
            return level.isServer();
        }
        catch (Throwable t) {
            return true;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isHostileOrAggressive(Mob mob) {
        try {
            f = Mob.class.getField("isHostile");
            if (Boolean.TRUE.equals(f.get(mob))) {
                return true;
            }
            ** GOTO lbl-1000
        }
        catch (Throwable f) {
            try lbl-1000:
            // 2 sources

            {
                try {
                    f = Mob.class.getField("isAggressive");
                    if (Boolean.TRUE.equals(f.get(mob))) {
                        return true;
                    }
                }
                catch (Throwable f) {
                    // empty catch block
                }
                try {
                    m = Mob.class.getMethod("isHostile", new Class[0]);
                    r = m.invoke((Object)mob, new Object[0]);
                    if (r instanceof Boolean && ((Boolean)r).booleanValue()) {
                        return true;
                    }
                }
                catch (Throwable m) {
                    // empty catch block
                }
                try {
                    m = Mob.class.getMethod("isAggressive", new Class[0]);
                    r = m.invoke((Object)mob, new Object[0]);
                    if (r instanceof Boolean == false) return false;
                    if ((Boolean)r == false) return false;
                    return true;
                }
                catch (Throwable var1_5) {
                    return false;
                }
            }
            catch (Throwable var1_6) {
                // empty catch block
            }
        }
        return false;
    }

    private static ServerClient safeGetServerClient(Object o) {
        if (o == null) {
            return null;
        }
        try {
            if (o instanceof ServerClient) {
                return (ServerClient)o;
            }
            Method m = o.getClass().getMethod("getServerClient", new Class[0]);
            Object r = m.invoke(o, new Object[0]);
            return r instanceof ServerClient ? (ServerClient)r : null;
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    private static void trySendMsg(ServerClient sc, String msg) {
        try {
            if (sc != null) {
                sc.sendChatMessage(msg);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static final class Claim {
        final boolean hasOwner;
        final long ownerAuth;
        final int teamID;
        final NetworkSettlementData net;

        Claim(boolean hasOwner, long ownerAuth, int teamID, NetworkSettlementData net) {
            this.hasOwner = hasOwner;
            this.ownerAuth = ownerAuth;
            this.teamID = teamID;
            this.net = net;
        }
    }

    @ModMethodPatch(target=Mob.class, name="interact", arguments={Level.class, int.class, int.class, PlayerMob.class})
    public static class Interact_PlayerMob {
        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        static boolean onEnter(@Advice.This Mob mob, @Advice.Argument(value=0) Level level, @Advice.Argument(value=1) int tileX, @Advice.Argument(value=2) int tileY, @Advice.Argument(value=3) PlayerMob player) {
            ServerClient sc = player != null ? ProtectAnimalsInteractPatch.safeGetServerClient(player) : null;
            return ProtectAnimalsInteractPatch.shouldSkipInteract(mob, level, tileX, tileY, sc);
        }
    }

    @ModMethodPatch(target=Mob.class, name="interact", arguments={Level.class, int.class, int.class, ServerClient.class})
    public static class Interact_ServerClient {
        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        static boolean onEnter(@Advice.This Mob mob, @Advice.Argument(value=0) Level level, @Advice.Argument(value=1) int tileX, @Advice.Argument(value=2) int tileY, @Advice.Argument(value=3) ServerClient sc) {
            return ProtectAnimalsInteractPatch.shouldSkipInteract(mob, level, tileX, tileY, sc);
        }
    }
}

