/*
 * Decompiled with CFR 0.152.
 */
package com.settlementguard;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import necesse.engine.GameEventInterface;
import necesse.engine.GameEventListener;
import necesse.engine.GameEvents;
import necesse.engine.events.players.ObjectDamageEvent;
import necesse.engine.events.players.ObjectInteractEvent;
import necesse.engine.events.players.TileDamageEvent;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.network.server.ServerClient;
import necesse.engine.world.WorldEntityGameClock;
import necesse.engine.world.worldData.SettlementsWorldData;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.SettlementFlagObject;
import necesse.level.maps.Level;
import necesse.level.maps.levelData.settlementData.CachedSettlementData;
import necesse.level.maps.levelData.settlementData.NetworkSettlementData;

@ModEntry
public class SettlementProtectionMod {
    private static final boolean DEBUG = false;
    private static final long CHAT_COOLDOWN_MS = 120000L;
    private static final Map<Long, Long> lastZoneMsg = new ConcurrentHashMap<Long, Long>();

    public void init() {
        System.out.println("[SettlementProtection] init (tiles/objects + animals + build block)");
        GameEvents.addListener(ObjectInteractEvent.class, (GameEventInterface)new GameEventListener<ObjectInteractEvent>(){

            public void onEvent(ObjectInteractEvent e) {
                Level level = e.level;
                int x = e.tileX;
                int y = e.tileY;
                if (level == null) {
                    return;
                }
                if (!SettlementProtectionMod.isClaimedSettlementTile(level, x, y)) {
                    return;
                }
                ServerClient sc = SettlementProtectionMod.safeGetServerClientFromPlayer(e.player);
                if (sc == null) {
                    return;
                }
                GameObject obj = SettlementProtectionMod.safeGetObject(level, x, y);
                if (obj instanceof SettlementFlagObject) {
                    if (SettlementProtectionMod.isOwner(level, x, y, sc)) {
                        return;
                    }
                    SettlementProtectionMod.denyImmediate(sc, "You are interacting with a protected settlement flag. The owner can review your request.");
                    return;
                }
                if (!SettlementProtectionMod.isOwnerOrTeamMember(level, x, y, sc)) {
                    SettlementProtectionMod.denyZoneThrottled(sc);
                    e.preventDefault();
                }
            }
        });
        GameEvents.addListener(ObjectDamageEvent.class, (GameEventInterface)new GameEventListener<ObjectDamageEvent>(){

            public void onEvent(ObjectDamageEvent e) {
                Level level = e.level;
                int x = e.tileX;
                int y = e.tileY;
                if (level == null) {
                    return;
                }
                if (!SettlementProtectionMod.isClaimedSettlementTile(level, x, y)) {
                    return;
                }
                ServerClient sc = e.client;
                if (sc == null) {
                    return;
                }
                GameObject obj = SettlementProtectionMod.safeGetObject(level, x, y);
                if (obj instanceof SettlementFlagObject) {
                    if (!SettlementProtectionMod.isOwner(level, x, y, sc)) {
                        SettlementProtectionMod.denyImmediate(sc, "Only the settlement owner can remove the settlement flag.");
                        e.preventDefault();
                    }
                    return;
                }
                if (!SettlementProtectionMod.isOwnerOrTeamMember(level, x, y, sc)) {
                    SettlementProtectionMod.denyZoneThrottled(sc);
                    e.preventDefault();
                }
            }
        });
        GameEvents.addListener(TileDamageEvent.class, (GameEventInterface)new GameEventListener<TileDamageEvent>(){

            public void onEvent(TileDamageEvent e) {
                Level level = e.level;
                int x = e.tileX;
                int y = e.tileY;
                if (level == null) {
                    return;
                }
                if (!SettlementProtectionMod.isClaimedSettlementTile(level, x, y)) {
                    return;
                }
                ServerClient sc = e.client;
                if (sc == null) {
                    return;
                }
                if (!SettlementProtectionMod.isOwnerOrTeamMember(level, x, y, sc)) {
                    SettlementProtectionMod.denyZoneThrottled(sc);
                    e.preventDefault();
                }
            }
        });
        SettlementProtectionMod.registerMobInteractListener("necesse.engine.events.players.MobInteractEvent");
        SettlementProtectionMod.registerPlaceListener("necesse.engine.events.players.ItemPlaceEvent");
    }

    private static boolean isClaimedSettlementTile(Level level, int tileX, int tileY) {
        Claim c = SettlementProtectionMod.getClaim(level, tileX, tileY);
        return c != null && c.hasOwner;
    }

    private static boolean isOwner(Level level, int tileX, int tileY, ServerClient client) {
        if (client == null) {
            return false;
        }
        Claim c = SettlementProtectionMod.getClaim(level, tileX, tileY);
        return c != null && c.hasOwner && client.authentication == c.ownerAuth;
    }

    private static boolean isOwnerOrTeamMember(Level level, int tileX, int tileY, ServerClient client) {
        if (client == null) {
            return false;
        }
        Claim c = SettlementProtectionMod.getClaim(level, tileX, tileY);
        if (c == null || !c.hasOwner) {
            return false;
        }
        if (client.authentication == c.ownerAuth) {
            return true;
        }
        try {
            if (c.teamID > 0 && client.getTeamID() == c.teamID) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (c.net != null) {
            try {
                return c.net.streamTeamMembers().anyMatch(sc -> sc != null && sc.authentication == serverClient.authentication);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static Claim getClaim(Level level, int tileX, int tileY) {
        if (level == null || !SettlementProtectionMod.isServerLevel(level)) {
            return null;
        }
        try {
            SettlementsWorldData world = SettlementsWorldData.getSettlementsData((WorldEntityGameClock)level);
            NetworkSettlementData net = world.getNetworkDataAtTile(level.getIdentifier(), tileX, tileY);
            if (net != null && net.hasOwner()) {
                long owner = SettlementProtectionMod.safeGetOwnerAuthFromNet(net);
                if (owner == -1L) {
                }
                int team = SettlementProtectionMod.safeGetTeamIDFromNet(net);
                return new Claim(true, owner, team, net);
            }
            CachedSettlementData cached = world.getCachedDataAtTile(level.getIdentifier(), tileX, tileY);
            if (cached == null) {
            }
            long owner = SettlementProtectionMod.safeGetOwnerAuthFromCached(cached);
            if (owner == -1L) {
            }
            int team = SettlementProtectionMod.safeGetTeamIDFromCached(cached);
            return new Claim(true, owner, team, null);
        }
        finally {
            return null;
        }
    }

    private static long safeGetOwnerAuthFromNet(NetworkSettlementData net) {
        try {
            return net.getOwnerAuth();
        }
        catch (Throwable throwable) {
            try {
                Method m = net.getClass().getMethod("getOwnerAuth", new Class[0]);
                Object r = m.invoke((Object)net, new Object[0]);
                if (r instanceof Number) {
                    return ((Number)r).longValue();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return -1L;
        }
    }

    private static int safeGetTeamIDFromNet(NetworkSettlementData net) {
        Object r;
        try {
            Method m = net.getClass().getMethod("getTeamID", new Class[0]);
            r = m.invoke((Object)net, new Object[0]);
            if (r instanceof Number) {
                return ((Number)r).intValue();
            }
        }
        catch (Throwable m) {
            // empty catch block
        }
        try {
            Field f = net.getClass().getDeclaredField("teamID");
            f.setAccessible(true);
            r = f.get(net);
            if (r instanceof Number) {
                return ((Number)r).intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    private static long safeGetOwnerAuthFromCached(CachedSettlementData cached) {
        try {
            return cached.getOwnerAuth();
        }
        catch (Throwable throwable) {
            Object r;
            try {
                Method m = cached.getClass().getMethod("getOwnerAuth", new Class[0]);
                r = m.invoke((Object)cached, new Object[0]);
                if (r instanceof Number) {
                    return ((Number)r).longValue();
                }
            }
            catch (Throwable m) {
                // empty catch block
            }
            try {
                Field f = cached.getClass().getDeclaredField("ownerAuth");
                f.setAccessible(true);
                r = f.get(cached);
                if (r instanceof Number) {
                    return ((Number)r).longValue();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return -1L;
        }
    }

    private static int safeGetTeamIDFromCached(CachedSettlementData cached) {
        try {
            return cached.getTeamID();
        }
        catch (Throwable throwable) {
            Object r;
            try {
                Method m = cached.getClass().getMethod("getTeamID", new Class[0]);
                r = m.invoke((Object)cached, new Object[0]);
                if (r instanceof Number) {
                    return ((Number)r).intValue();
                }
            }
            catch (Throwable m) {
                // empty catch block
            }
            try {
                Field f = cached.getClass().getDeclaredField("teamID");
                f.setAccessible(true);
                r = f.get(cached);
                if (r instanceof Number) {
                    return ((Number)r).intValue();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return 0;
        }
    }

    private static void denyImmediate(ServerClient client, String msg) {
        try {
            if (client != null) {
                client.sendChatMessage((GameMessage)new StaticMessage(msg));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void denyZoneThrottled(ServerClient client) {
        if (client == null) {
            return;
        }
        long auth = client.authentication;
        long now = System.currentTimeMillis();
        Long last = lastZoneMsg.get(auth);
        if (last == null || now - last >= 120000L) {
            lastZoneMsg.put(auth, now);
            SettlementProtectionMod.denyImmediate(client, "This settlement is protected.");
        }
    }

    private static boolean isServerLevel(Level level) {
        try {
            return level.isServer();
        }
        catch (Throwable t) {
            return true;
        }
    }

    private static GameObject safeGetObject(Level level, int x, int y) {
        try {
            return level.getObject(x, y);
        }
        catch (Throwable throwable) {
            try {
                return (GameObject)Level.class.getMethod("getObject", Integer.TYPE, Integer.TYPE).invoke((Object)level, x, y);
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
    }

    private static ServerClient safeGetServerClientFromPlayer(Object playerMob) {
        if (playerMob == null) {
            return null;
        }
        try {
            Method m = playerMob.getClass().getMethod("getServerClient", new Class[0]);
            Object r = m.invoke(playerMob, new Object[0]);
            return r instanceof ServerClient ? (ServerClient)r : null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static void registerMobInteractListener(String clsName) {
        try {
            Class.forName(clsName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void registerPlaceListener(String clsName) {
        try {
            Class.forName(clsName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static final class Claim {
        final boolean hasOwner;
        final long ownerAuth;
        final int teamID;
        final NetworkSettlementData net;

        Claim(boolean hasOwner, long ownerAuth, int teamID, NetworkSettlementData net) {
            this.hasOwner = hasOwner;
            this.ownerAuth = ownerAuth;
            this.teamID = teamID;
            this.net = net;
        }
    }
}

