/*
 * Decompiled with CFR 0.152.
 */
package com.jobs.patches;

import com.jobs.JobsMod;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.server.ServerClient;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=Mob.class, name="onDeath", arguments={Attacker.class, HashSet.class})
public class JobsMobDeathPatch {
    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void onEnter(@Advice.This Object mob, @Advice.Argument(value=0) Object attacker, @Advice.Argument(value=1) HashSet<?> attackers) {
        if (mob == null) {
            return;
        }
        ServerClient sc = JobsMobDeathPatch.extractServerClient(attacker);
        if (sc == null) {
            sc = JobsMobDeathPatch.extractServerClientFromAttackers(attackers);
        }
        if (sc == null) {
            return;
        }
        String mobName = JobsMobDeathPatch.safeStringId(mob);
        boolean isFriendlyNonHumanNonCritter = JobsMobDeathPatch.isInstance(mob, "necesse.entity.mobs.friendly.FriendlyMob") && !JobsMobDeathPatch.isInstance(mob, "necesse.entity.mobs.friendly.human.HumanMob") && !JobsMobDeathPatch.isInstance(mob, "necesse.entity.mobs.friendly.critters.CritterMob");
        boolean isWhitelistedCritter = JobsMobDeathPatch.hasSimpleName(mob, "DuckMob") || JobsMobDeathPatch.hasSimpleName(mob, "RabbitMob") || JobsMobDeathPatch.isInstance(mob, "necesse.entity.mobs.friendly.critters.DuckMob") || JobsMobDeathPatch.isInstance(mob, "necesse.entity.mobs.friendly.critters.RabbitMob");
        boolean isHostile = JobsMobDeathPatch.isInstance(mob, "necesse.entity.mobs.hostile.HostileMob");
        if (isFriendlyNonHumanNonCritter || isWhitelistedCritter) {
            JobsMod.JOBS.onFriendlyKilled(sc, mobName);
            return;
        }
        if (isHostile) {
            JobsMod.JOBS.onHostileKilled(sc, mobName);
        }
    }

    public static ServerClient extractServerClient(Object atkObj) {
        ServerClient sc;
        Object m;
        Object sc2;
        if (atkObj == null) {
            return null;
        }
        try {
            Object pm = atkObj.getClass().getMethod("getFirstPlayerOwner", new Class[0]).invoke(atkObj, new Object[0]);
            if (pm != null && (sc2 = pm.getClass().getMethod("getServerClient", new Class[0]).invoke(pm, new Object[0])) instanceof ServerClient) {
                return sc2;
            }
        }
        catch (Throwable pm) {
            // empty catch block
        }
        try {
            Object owner = atkObj.getClass().getMethod("getAttackOwner", new Class[0]).invoke(atkObj, new Object[0]);
            sc2 = JobsMobDeathPatch.resolveServerClientFromMobChain(owner, 5);
            if (sc2 != null) {
                return sc2;
            }
        }
        catch (Throwable owner) {
            // empty catch block
        }
        try {
            Method gm = atkObj.getClass().getMethod("getMob", new Class[0]);
            m = gm.invoke(atkObj, new Object[0]);
            sc = JobsMobDeathPatch.resolveServerClientFromMobChain(m, 5);
            if (sc != null) {
                return sc;
            }
        }
        catch (Throwable gm) {
            // empty catch block
        }
        try {
            Method go = atkObj.getClass().getMethod("getOwner", new Class[0]);
            m = go.invoke(atkObj, new Object[0]);
            sc = JobsMobDeathPatch.resolveServerClientFromMobChain(m, 5);
            if (sc != null) {
                return sc;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static ServerClient extractServerClientFromAttackers(Set<?> set) {
        if (set == null) {
            return null;
        }
        for (Object a : set) {
            ServerClient sc = JobsMobDeathPatch.extractServerClient(a);
            if (sc == null) continue;
            return sc;
        }
        return null;
    }

    public static ServerClient resolveServerClientFromMobChain(Object mob, int depth) {
        String[] chain;
        if (mob == null || depth <= 0) {
            return null;
        }
        try {
            Object sc = mob.getClass().getMethod("getServerClient", new Class[0]).invoke(mob, new Object[0]);
            if (sc instanceof ServerClient) {
                return (ServerClient)sc;
            }
        }
        catch (Throwable sc) {
            // empty catch block
        }
        String[] stringArray = chain = new String[]{"getFirstAttackOwner", "getAttackOwner", "getOwner"};
        int n = chain.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            try {
                Object next = mob.getClass().getMethod(m, new Class[0]).invoke(mob, new Object[0]);
                ServerClient sc = JobsMobDeathPatch.resolveServerClientFromMobChain(next, depth - 1);
                if (sc != null) {
                    return sc;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    public static boolean isInstance(Object o, String fqcn) {
        try {
            return Class.forName(fqcn).isInstance(o);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean hasSimpleName(Object o, String simple) {
        try {
            return o.getClass().getSimpleName().equals(simple);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String safeStringId(Object mob) {
        try {
            return String.valueOf(mob.getClass().getMethod("getStringID", new Class[0]).invoke(mob, new Object[0]));
        }
        catch (Throwable ignore) {
            return mob.getClass().getName();
        }
    }
}

