/*
 * Decompiled with CFR 0.152.
 */
package com.jobs.patches;

import com.jobs.JobsMod;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.server.ServerClient;
import necesse.entity.levelEvent.fishingEvent.FishingEvent;
import necesse.entity.mobs.FishingMob;
import necesse.entity.mobs.PlayerMob;
import necesse.inventory.InventoryItem;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=FishingMob.class, name="giveCaughtItem", arguments={FishingEvent.class, InventoryItem.class})
public class JobsFishCatchPatch {
    @Advice.OnMethodExit(suppress=Throwable.class)
    public static void onExit(@Advice.This FishingMob self, @Advice.Argument(value=0) FishingEvent event, @Advice.Argument(value=1) InventoryItem caught) {
        try {
            if (JobsMod.JOBS == null) {
                return;
            }
            if (event == null || caught == null) {
                return;
            }
            if (!event.level.isServer()) {
                return;
            }
            if (event.getMob() == null || !event.getMob().isPlayer) {
                return;
            }
            PlayerMob pm = (PlayerMob)event.getMob();
            ServerClient client = pm.getServerClient();
            if (client == null) {
                return;
            }
            String id = "unknown";
            try {
                id = caught.item.getStringID();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            JobsMod.JOBS.onFishCaught(client, id);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

