/*
 * Decompiled with CFR 0.152.
 */
package com.jobs;

import com.jobs.JobsMod;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import necesse.engine.events.players.ObjectDamageEvent;
import necesse.engine.network.server.ServerClient;
import necesse.level.gameObject.GameObject;
import necesse.level.maps.Level;

public final class JobsOreHooks {
    private static final Map<String, Boolean> wasOreAtHit = new ConcurrentHashMap<String, Boolean>();
    private static final Set<String> ORE_KEYWORDS = new HashSet<String>(Arrays.asList("ore", "ancientfossil", "copper", "glacial", "gold", "iron", "ivy", "mycelium", "nightsteel", "slimeum", "spiderite", "tungsten", "rockcopper", "rockgold", "rockiron", "rocktungsten", "rockancientfossil", "rockglacial", "rockivy", "rockmycelium", "rocknightsteel", "rockslimeum", "rockspiderite", "copperrock", "goldrock", "ironrock", "tungstenrock", "ancientfossilrock", "glacialrock", "ivyrock", "myceliumrock", "nightsteelrock", "slimeumrock", "spideriterock"));

    private JobsOreHooks() {
    }

    public static void onObjectDamage(ObjectDamageEvent e) {
        try {
            ServerClient sc = e.client;
            Level level = e.level;
            int tx = e.tileX;
            int ty = e.tileY;
            GameObject before = JobsOreHooks.safeGetObject(level, tx, ty);
            boolean wasOre = JobsOreHooks.looksLikeOre(before);
            wasOreAtHit.put(JobsOreHooks.key(level, tx, ty), wasOre);
            JobsMod.JOBS.runLater(() -> {
                try {
                    Boolean remembered = wasOreAtHit.remove(JobsOreHooks.key(level, tx, ty));
                    if (remembered == null || !remembered.booleanValue()) {
                        return;
                    }
                    GameObject now = JobsOreHooks.safeGetObject(level, tx, ty);
                    if (!JobsOreHooks.looksLikeOre(now) && JobsMod.JOBS.markIfNotRecentlyCounted(level, tx, ty, 3500L)) {
                        JobsMod.JOBS.onOreMined(sc);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, 2000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void onObjectDestroyedGeneric(Object e) {
        try {
            Level level = (Level)JobsOreHooks.getFieldOrGetter(e, "level", "getLevel", Level.class);
            Integer tx = (Integer)JobsOreHooks.getFieldOrGetter(e, "tileX", "getTileX", Integer.class);
            Integer ty = (Integer)JobsOreHooks.getFieldOrGetter(e, "tileY", "getTileY", Integer.class);
            ServerClient sc = JobsOreHooks.tryGetServerClient(e);
            if (level == null || tx == null || ty == null || sc == null) {
                return;
            }
            GameObject now = JobsOreHooks.safeGetObject(level, tx, ty);
            if (!JobsOreHooks.looksLikeOre(now) && JobsMod.JOBS.markIfNotRecentlyCounted(level, tx, ty, 3500L)) {
                JobsMod.JOBS.onOreMined(sc);
                System.out.println("[JobsMod][OreHooks] Miner +1 (generic) at " + String.valueOf(tx) + "," + String.valueOf(ty));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String key(Level level, int x, int y) {
        try {
            return String.valueOf(level.getIdentifier()) + ":" + x + ":" + y;
        }
        catch (Throwable t) {
            return "L:" + x + ":" + y;
        }
    }

    private static String norm(String s) {
        return s == null ? "" : s.toLowerCase().replace(" ", "").replace("_", "").replace("-", "");
    }

    static boolean looksLikeOre(GameObject obj) {
        if (obj == null) {
            return false;
        }
        try {
            String cls = JobsOreHooks.norm(obj.getClass().getSimpleName());
            if (JobsOreHooks.containsAnyKeyword(cls)) {
                return true;
            }
        }
        catch (Throwable cls) {
            // empty catch block
        }
        try {
            String s;
            Method m = obj.getClass().getMethod("getStringID", new Class[0]);
            Object id = m.invoke((Object)obj, new Object[0]);
            if (id instanceof String && JobsOreHooks.containsAnyKeyword(JobsOreHooks.norm(s = (String)id))) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean containsAnyKeyword(String s) {
        if (s.isEmpty()) {
            return false;
        }
        for (String k : ORE_KEYWORDS) {
            if (!s.contains(k)) continue;
            return true;
        }
        return false;
    }

    static GameObject safeGetObject(Level level, int x, int y) {
        try {
            return level.getObject(x, y);
        }
        catch (Throwable t) {
            try {
                return (GameObject)Level.class.getMethod("getObject", Integer.TYPE, Integer.TYPE).invoke((Object)level, x, y);
            }
            catch (Throwable ignore) {
                return null;
            }
        }
    }

    static Object getFieldOrGetter(Object e, String field, String getter, Class<?> type) {
        Object v2;
        try {
            v2 = e.getClass().getField(field).get(e);
            if (type.isInstance(v2)) {
                return v2;
            }
        }
        catch (Throwable v2) {
            // empty catch block
        }
        try {
            v2 = e.getClass().getMethod(getter, new Class[0]).invoke(e, new Object[0]);
            if (type.isInstance(v2)) {
                return v2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    static ServerClient tryGetServerClient(Object e) {
        Object v2;
        try {
            v2 = e.getClass().getField("client").get(e);
            if (v2 instanceof ServerClient) {
                ServerClient sc = (ServerClient)v2;
                return sc;
            }
        }
        catch (Throwable v2) {
            // empty catch block
        }
        try {
            v2 = e.getClass().getField("serverClient").get(e);
            if (v2 instanceof ServerClient) {
                ServerClient sc = (ServerClient)v2;
                return sc;
            }
        }
        catch (Throwable v3) {
            // empty catch block
        }
        try {
            Object sc;
            Object player = e.getClass().getField("player").get(e);
            if (player != null && (sc = player.getClass().getMethod("getServerClient", new Class[0]).invoke(player, new Object[0])) instanceof ServerClient) {
                return (ServerClient)sc;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

