/*
 * Decompiled with CFR 0.152.
 */
package com.jobs;

import com.jobs.JobCommand;
import com.jobs.JobsManager;
import com.jobs.JobsOreHooks;
import com.jobs.JobsTreeHooks;
import com.jobs.PacketJobsSelfStats;
import necesse.engine.GameEventInterface;
import necesse.engine.GameEventListener;
import necesse.engine.GameEvents;
import necesse.engine.events.players.ObjectDamageEvent;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.registries.PacketRegistry;

@ModEntry
public class JobsMod {
    public static final JobsManager JOBS = new JobsManager();

    public static void init() {
        System.out.println("[JobsMod] Init (listeners + commands)");
        try {
            JobCommand.register();
        }
        catch (Throwable t) {
            System.err.println("[JobsMod] Could not register /job command: " + String.valueOf(t));
        }
        try {
            PacketRegistry.registerPacket(PacketJobsSelfStats.class);
            System.out.println("[JobsMod] Registered Jobs GUI packet");
        }
        catch (Exception e) {
            System.out.println("[JobsMod] ERROR registering Jobs packets: " + String.valueOf(e));
        }
        GameEvents.addListener(ObjectDamageEvent.class, (GameEventInterface)new GameEventListener<ObjectDamageEvent>(){

            public void onEvent(ObjectDamageEvent e) {
                try {
                    JobsTreeHooks.onObjectDamage(e);
                    JobsOreHooks.onObjectDamage(e);
                }
                catch (Throwable t) {
                    System.err.println("[JobsMod] onObjectDamage err: " + String.valueOf(t));
                }
            }
        });
        System.out.println("[JobsMod] ObjectDamageEvent listener active (Woodcutter + Miner).");
    }
}

