/*
 * Decompiled with CFR 0.152.
 */
package com.jobs;

import com.jobs.GenericGiveUtil;
import com.jobs.JobsConfig;
import com.jobs.PacketJobsSelfStats;
import com.jobs.PermissionsUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketChatMessage;
import necesse.engine.network.server.ServerClient;
import necesse.level.maps.Level;

public class JobsManager {
    private final Map<Integer, JobType> jobBySlot = new ConcurrentHashMap<Integer, JobType>();
    private final Map<Integer, Integer> progressBySlot = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, String> nameBySlot = new ConcurrentHashMap<Integer, String>();
    private final Map<String, JobType> jobByName = new ConcurrentHashMap<String, JobType>();
    private final Map<String, Integer> progressByName = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Map<JobType, Integer>> progressByNameJob = new ConcurrentHashMap<String, Map<JobType, Integer>>();
    private final Map<String, Long> recentKills = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> recentlyCounted = new ConcurrentHashMap<String, Long>();
    private final Map<Integer, Long> lastMsg = new ConcurrentHashMap<Integer, Long>();
    private final Map<String, Map<Integer, List<RewardEntry>>> rankRewards = new HashMap<String, Map<Integer, List<RewardEntry>>>();
    private final Map<JobType, int[]> rankCoins = new EnumMap<JobType, int[]>(JobType.class);
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "JobsModScheduler");
            t.setDaemon(true);
            return t;
        }
    });
    private final Path storePath = Paths.get("jobsmod_store.txt", new String[0]);
    private final JobsConfig cfg = new JobsConfig();

    public JobsManager() {
        this.load();
        this.loadRankRewards();
        this.loadRankConfig();
    }

    public boolean isAdmin(ServerClient sc) {
        return PermissionsUtil.isAdminOrOwner(sc);
    }

    public void info(ServerClient sc) {
        this.cfg.reloadIfChanged();
        this.ensureLoadedFor(sc);
        this.sendInfo(sc);
    }

    public void joinJob(ServerClient sc, String name) {
        this.cfg.reloadIfChanged();
        this.ensureLoadedFor(sc);
        JobType jt = this.parseJob(name);
        if (jt == JobType.NONE) {
            this.send(sc, "[Jobs] Unknown job: " + name);
            return;
        }
        String nick = this.snapshotName(sc);
        this.jobBySlot.put(sc.slot, jt);
        this.jobByName.put(nick, jt);
        Map<JobType, Integer> jobsMap = this.progressByNameJob.get(nick);
        int prog = 0;
        if (jobsMap != null) {
            Integer p = jobsMap.get((Object)jt);
            if (p != null) {
                prog = p;
            }
        } else {
            jobsMap = new ConcurrentHashMap<JobType, Integer>();
            this.progressByNameJob.put(nick, jobsMap);
        }
        this.progressBySlot.put(sc.slot, prog);
        this.progressByName.put(nick, prog);
        this.send(sc, "[Jobs] You are now a " + String.valueOf((Object)jt) + ".");
        this.save();
    }

    public void leaveJob(ServerClient sc) {
        this.cfg.reloadIfChanged();
        this.ensureLoadedFor(sc);
        String nick = this.snapshotName(sc);
        this.jobBySlot.put(sc.slot, JobType.NONE);
        this.jobByName.put(nick, JobType.NONE);
        this.send(sc, "[Jobs] You have left your job.");
        this.save();
    }

    public void showConfig(ServerClient sc) {
        this.cfg.reloadIfChanged();
        Map<String, Integer> snap = this.cfg.snapshot();
        this.send(sc, "[Jobs] Current config values:");
        for (Map.Entry<String, Integer> e : snap.entrySet()) {
            this.send(sc, " - " + e.getKey() + " = " + String.valueOf(e.getValue()));
        }
    }

    public void reloadConfig(ServerClient sc) {
        this.cfg.reloadIfChanged();
        this.send(sc, "[Jobs] Config reloaded from file.");
    }

    public List<String> listJobs() {
        return Arrays.asList("woodcutter", "miner", "hunter", "slayer", "fisher");
    }

    public void onTreeChopped(ServerClient sc, Level level, int tileX, int tileY) {
        this.cfg.reloadIfChanged();
        this.ensureLoadedFor(sc);
        if (this.getJob(sc) != JobType.WOODCUTTER) {
            return;
        }
        this.bumpProgress(sc, this.getPerCoinForJob(JobType.WOODCUTTER), this.cfg.coinsForTrees(), "");
    }

    public void onTreeChopped(ServerClient sc) {
        this.onTreeChopped(sc, null, 0, 0);
    }

    public void onOreMined(ServerClient sc) {
        this.cfg.reloadIfChanged();
        this.ensureLoadedFor(sc);
        if (this.getJob(sc) != JobType.MINER) {
            return;
        }
        this.bumpProgress(sc, this.getPerCoinForJob(JobType.MINER), this.cfg.coinsForOres(), "");
    }

    public void onFriendlyKilled(ServerClient sc, String mobName) {
        this.cfg.reloadIfChanged();
        this.ensureLoadedFor(sc);
        if (this.getJob(sc) != JobType.HUNTER) {
            return;
        }
        if (!this.allowKill(sc, mobName)) {
            return;
        }
        this.bumpProgress(sc, this.getPerCoinForJob(JobType.HUNTER), this.cfg.coinsForFriendly(), "");
    }

    public void onHostileKilled(ServerClient sc, String mobName) {
        this.cfg.reloadIfChanged();
        this.ensureLoadedFor(sc);
        if (this.getJob(sc) != JobType.SLAYER) {
            return;
        }
        if (!this.allowKill(sc, mobName)) {
            return;
        }
        this.bumpProgress(sc, this.getPerCoinForJob(JobType.SLAYER), this.cfg.coinsForHostile(), "");
    }

    public void onFishCaught(ServerClient sc, String fishIdOrName) {
        this.cfg.reloadIfChanged();
        this.ensureLoadedFor(sc);
        if (this.getJob(sc) != JobType.FISHER) {
            return;
        }
        this.bumpProgress(sc, this.getPerCoinForJob(JobType.FISHER), this.cfg.coinsForFish(), "");
    }

    public JobType getJob(ServerClient sc) {
        JobType jt = this.jobBySlot.get(sc.slot);
        return jt == null ? JobType.NONE : jt;
    }

    public void send(ServerClient sc, String msg) {
        try {
            sc.sendPacket((Packet)new PacketChatMessage(msg));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void sendInfo(ServerClient sc) {
        int denom;
        JobType jt = this.getJob(sc);
        int prog = this.getProgressFor(sc);
        if (jt == JobType.NONE) {
            this.send(sc, "[Jobs] You don't have a job yet. Use /job list and /job join <name>.");
            return;
        }
        int perCoin = this.getPerCoinForJob(jt);
        int coins = perCoin > 0 ? prog / perCoin : 0;
        int rankLevel = this.computeRankLevel(jt, coins);
        String rankName = this.getRankName(jt, rankLevel);
        String jobNice = this.getJobNiceName(jt);
        String actionText = this.getJobActionText(jt);
        int needActionsForNextPoint = 0;
        if (perCoin > 0 && (needActionsForNextPoint = (denom = Math.max(1, perCoin)) - prog % denom) == denom) {
            needActionsForNextPoint = 0;
        }
        this.send(sc, "[Jobs] Current job: " + jobNice);
        if (rankLevel <= 0) {
            this.send(sc, "[Jobs] Rank: none (do more " + actionText.toLowerCase() + " to earn ranks)");
        } else {
            int nextRankCoins = this.coinsRequiredForRank(jt, rankLevel + 1);
            if (nextRankCoins < 0) {
                this.send(sc, "[Jobs] Rank: " + rankLevel + " - " + rankName + " (MAX rank)");
            } else {
                int actionsToNextRank;
                int coinsToNext = Math.max(0, nextRankCoins - coins);
                int n = actionsToNextRank = perCoin > 0 ? coinsToNext * perCoin : 0;
                if (actionsToNextRank <= 0) {
                    this.send(sc, "[Jobs] Rank: " + rankLevel + " - " + rankName + " (very close to next rank)");
                } else {
                    this.send(sc, "[Jobs] Rank: " + rankLevel + " - " + rankName + " (" + actionsToNextRank + " more " + actionText.toLowerCase() + " to next rank)");
                }
            }
        }
        if (perCoin > 0) {
            if (needActionsForNextPoint <= 0) {
                this.send(sc, "[Jobs] Progress: " + prog + " " + actionText.toLowerCase() + " done (" + perCoin + " = 1 job point, job point ready on next action)");
            } else {
                this.send(sc, "[Jobs] Progress: " + prog + " " + actionText.toLowerCase() + " done (" + perCoin + " = 1 job point, " + needActionsForNextPoint + " more for next job point)");
            }
        } else {
            this.send(sc, "[Jobs] Progress: " + prog + " " + actionText.toLowerCase() + " done.");
        }
        this.send(sc, "[Jobs] Tip: " + this.getJobHintText(jt));
    }

    private int getPerCoinForJob(JobType jt) {
        switch (jt) {
            case WOODCUTTER: {
                return this.cfg.treesPerCoin();
            }
            case MINER: {
                return this.cfg.oresPerCoin();
            }
            case HUNTER: {
                return this.cfg.friendlyPerCoin();
            }
            case SLAYER: {
                return this.cfg.hostilePerCoin();
            }
            case FISHER: {
                return this.cfg.fishPerCoin();
            }
        }
        return 1;
    }

    private int getProgressFor(ServerClient sc) {
        Integer p;
        JobType jt = this.getJob(sc);
        if (jt == JobType.NONE) {
            return 0;
        }
        String nick = this.snapshotName(sc);
        Map<JobType, Integer> jobsMap = this.progressByNameJob.get(nick);
        int prog = 0;
        if (jobsMap != null && (p = jobsMap.get((Object)jt)) != null) {
            prog = p;
        }
        this.progressBySlot.put(sc.slot, prog);
        this.progressByName.put(nick, prog);
        return prog;
    }

    private int getProgressFor(ServerClient sc, JobType jt) {
        if (sc == null || jt == null || jt == JobType.NONE) {
            return 0;
        }
        String nick = this.snapshotName(sc);
        Map<JobType, Integer> jobsMap = this.progressByNameJob.get(nick);
        if (jobsMap == null) {
            return 0;
        }
        Integer p = jobsMap.get((Object)jt);
        return p != null ? p : 0;
    }

    public void showRank(ServerClient sc) {
        this.cfg.reloadIfChanged();
        this.ensureLoadedFor(sc);
        JobType jt = this.getJob(sc);
        int prog = this.getProgressFor(sc);
        if (jt == JobType.NONE) {
            this.send(sc, "[Jobs] You don't have a job yet. Use /job list and /job join <name>.");
            return;
        }
        int perCoin = this.getPerCoinForJob(jt);
        int coins = perCoin > 0 ? prog / perCoin : 0;
        int rankLevel = this.computeRankLevel(jt, coins);
        String rankName = this.getRankName(jt, rankLevel);
        String jobNice = this.getJobNiceName(jt);
        String actionText = this.getJobActionText(jt);
        if (rankLevel <= 0) {
            this.send(sc, "[Jobs] Job: " + jobNice + " | No rank yet. Do more " + actionText.toLowerCase() + " to earn ranks!");
        } else {
            int nextRankCoins = this.coinsRequiredForRank(jt, rankLevel + 1);
            if (nextRankCoins < 0) {
                this.send(sc, "[Jobs] Job: " + jobNice + " | Rank " + rankLevel + " - " + rankName + " (MAX rank)");
            } else {
                int actionsToNext;
                int coinsToNext = Math.max(0, nextRankCoins - coins);
                int n = actionsToNext = perCoin > 0 ? coinsToNext * perCoin : 0;
                if (actionsToNext <= 0) {
                    this.send(sc, "[Jobs] Job: " + jobNice + " | Rank " + rankLevel + " - " + rankName + " (very close to next rank!)");
                } else {
                    this.send(sc, "[Jobs] Job: " + jobNice + " | Rank " + rankLevel + " - " + rankName + " (" + actionsToNext + " more " + actionText.toLowerCase() + " to next rank)");
                }
            }
        }
    }

    public void openGui(ServerClient sc) {
        if (sc == null) {
            return;
        }
        try {
            this.cfg.reloadIfChanged();
            this.ensureLoadedFor(sc);
            JobType currentJob = this.getJob(sc);
            String jobNice = this.getJobNiceName(currentJob);
            String nick = this.snapshotName(sc);
            JobType[] order = new JobType[]{JobType.WOODCUTTER, JobType.MINER, JobType.HUNTER, JobType.SLAYER, JobType.FISHER};
            int[] actions = new int[order.length];
            int[] ranks = new int[order.length];
            int i = 0;
            while (i < order.length) {
                int prog;
                JobType jt = order[i];
                actions[i] = prog = this.getProgressFor(sc, jt);
                int perCoin = this.getPerCoinForJob(jt);
                int coins = perCoin > 0 ? prog / perCoin : 0;
                ranks[i] = this.computeRankLevel(jt, coins);
                ++i;
            }
            sc.sendPacket((Packet)new PacketJobsSelfStats(sc, nick, nick, jobNice, actions, ranks));
        }
        catch (Throwable t) {
            System.out.println("[JobsMod] Failed to send Jobs GUI packet: " + String.valueOf(t));
        }
    }

    public int getRank(ServerClient sc) {
        this.cfg.reloadIfChanged();
        this.ensureLoadedFor(sc);
        JobType jt = this.getJob(sc);
        if (jt == JobType.NONE) {
            return 0;
        }
        int prog = this.getProgressFor(sc);
        int perCoin = this.getPerCoinForJob(jt);
        int coins = perCoin > 0 ? prog / perCoin : 0;
        return this.computeRankLevel(jt, coins);
    }

    private int computeRankLevel(JobType jt, int coins) {
        if (jt == JobType.NONE) {
            return 0;
        }
        int[] th = this.rankCoins.get((Object)jt);
        if (th == null || th.length < 5) {
            th = new int[]{1, 10, 25, 50, 100};
        }
        if (coins >= th[4]) {
            return 5;
        }
        if (coins >= th[3]) {
            return 4;
        }
        if (coins >= th[2]) {
            return 3;
        }
        if (coins >= th[1]) {
            return 2;
        }
        if (coins >= th[0]) {
            return 1;
        }
        return 0;
    }

    private int coinsRequiredForRank(JobType jt, int rankLevel) {
        if (jt == JobType.NONE || rankLevel <= 0 || rankLevel > 5) {
            return -1;
        }
        int[] th = this.rankCoins.get((Object)jt);
        if (th == null || th.length < 5) {
            th = new int[]{1, 10, 25, 50, 100};
        }
        return th[rankLevel - 1];
    }

    private String getRankName(JobType jt, int rankLevel) {
        if (rankLevel <= 0 || jt == JobType.NONE) {
            return "Unemployed";
        }
        return (switch (rankLevel) {
            case 1 -> "Rookie";
            case 2 -> "Apprentice";
            case 3 -> "Skilled";
            case 4 -> "Expert";
            default -> "Master";
        }) + " " + (switch (jt) {
            case JobType.WOODCUTTER -> "Woodcutter";
            case JobType.MINER -> "Miner";
            case JobType.HUNTER -> "Hunter";
            case JobType.SLAYER -> "Slayer";
            case JobType.FISHER -> "Fisher";
            default -> "Worker";
        });
    }

    private String getMasterTitle(JobType jt) {
        switch (jt) {
            case WOODCUTTER: {
                return "Master Woodcutter";
            }
            case MINER: {
                return "Master Miner";
            }
            case HUNTER: {
                return "Master Hunter";
            }
            case SLAYER: {
                return "Master Slayer";
            }
            case FISHER: {
                return "Master Fisherman";
            }
        }
        return "Master Worker";
    }

    private String getJobNiceName(JobType jt) {
        switch (jt) {
            case WOODCUTTER: {
                return "Woodcutter";
            }
            case MINER: {
                return "Miner";
            }
            case HUNTER: {
                return "Hunter";
            }
            case SLAYER: {
                return "Slayer";
            }
            case FISHER: {
                return "Fisher";
            }
        }
        return "Unemployed";
    }

    private String getJobActionText(JobType jt) {
        switch (jt) {
            case WOODCUTTER: {
                return "trees chopped";
            }
            case MINER: {
                return "ores mined";
            }
            case HUNTER: {
                return "animals hunted";
            }
            case SLAYER: {
                return "hostile mobs killed";
            }
            case FISHER: {
                return "fish caught";
            }
        }
        return "actions";
    }

    private String getJobHintText(JobType jt) {
        switch (jt) {
            case WOODCUTTER: {
                return "Chop trees to earn coins and rank up as a Woodcutter.";
            }
            case MINER: {
                return "Mine ore veins to earn coins and rank up as a Miner.";
            }
            case HUNTER: {
                return "Hunt friendly animals to earn coins and rank up as a Hunter.";
            }
            case SLAYER: {
                return "Kill hostile mobs to earn coins and rank up as a Slayer.";
            }
            case FISHER: {
                return "Catch fish to earn coins and rank up as a Fisher.";
            }
        }
        return "Join a job with /job join <name> to start earning coins and ranks.";
    }

    private void bumpProgress(ServerClient sc, int perCoin, int coinsReward, String incMsg) {
        int newCoins;
        int newRank;
        JobType jt = this.getJob(sc);
        if (jt == JobType.NONE) {
            return;
        }
        String nick = this.snapshotName(sc);
        Map<JobType, Integer> jobsMap = this.progressByNameJob.get(nick);
        if (jobsMap == null) {
            jobsMap = new ConcurrentHashMap<JobType, Integer>();
            this.progressByNameJob.put(nick, jobsMap);
        }
        int oldProg = 0;
        Integer old = jobsMap.get((Object)jt);
        if (old != null) {
            oldProg = old;
        }
        int oldCoins = perCoin > 0 ? oldProg / perCoin : 0;
        int oldRank = this.computeRankLevel(jt, oldCoins);
        int p = oldProg + 1;
        jobsMap.put(jt, p);
        this.progressBySlot.put(sc.slot, p);
        this.progressByName.put(nick, p);
        if (perCoin > 0 && p % perCoin == 0) {
            this.reward(sc, "coin", Math.max(0, coinsReward));
        } else if (incMsg != null && !incMsg.isEmpty()) {
            int denom = Math.max(1, perCoin);
            int need = denom - p % denom;
            this.sendThrottled(sc, incMsg + " (" + need + " more)", 1200L);
        }
        if (perCoin > 0 && jt != JobType.NONE && (newRank = this.computeRankLevel(jt, newCoins = p / perCoin)) > oldRank) {
            String rankName = this.getRankName(jt, newRank);
            this.send(sc, "[Jobs] Rank up! You are now " + rankName + ".");
            if (newRank == 5) {
                this.send(sc, "[Jobs] You have reached MAX rank for this job! (" + this.getMasterTitle(jt) + ")");
            }
            this.giveRankRewards(sc, jt, newRank);
        }
        this.save();
    }

    public void reward(ServerClient sc, String itemId, int amount) {
        if (amount <= 0) {
            return;
        }
        GenericGiveUtil.give(sc, itemId, amount);
    }

    private boolean allowKill(ServerClient sc, String mobName) {
        if (mobName == null || mobName.isEmpty()) {
            return true;
        }
        String key = sc.slot + ":" + mobName.toLowerCase(Locale.ROOT);
        long now = System.currentTimeMillis();
        Long last = this.recentKills.get(key);
        if (last != null && now - last < 500L) {
            return false;
        }
        this.recentKills.put(key, now);
        return true;
    }

    public boolean markIfNotRecentlyCounted(Level level, int x, int y, long windowMs) {
        String k;
        try {
            k = String.valueOf(level.getIdentifier()) + ":" + x + ":" + y;
        }
        catch (Throwable t) {
            k = "L:" + x + ":" + y;
        }
        long now = System.currentTimeMillis();
        Long last = this.recentlyCounted.get(k);
        if (last != null && now - last < windowMs) {
            return false;
        }
        this.recentlyCounted.put(k, now);
        return true;
    }

    public void runLater(Runnable r, long delayMs) {
        this.scheduler.schedule(r, delayMs, TimeUnit.MILLISECONDS);
    }

    private void sendThrottled(ServerClient sc, String msg, long minDeltaMs) {
        long now = System.currentTimeMillis();
        Long last = this.lastMsg.get(sc.slot);
        if (last == null || now - last >= minDeltaMs) {
            this.send(sc, msg);
            this.lastMsg.put(sc.slot, now);
        }
    }

    private void loadRankRewards() {
        Object var3_7;
        this.rankRewards.clear();
        Path p = Paths.get("jobs_ranks_rewards.txt", new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                var3_7 = null;
                try (BufferedWriter bw = Files.newBufferedWriter(p, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                    bw.write("# ============================================\n");
                    bw.write("# Eternal RPG - Jobs Rank Rewards (FULL VERSION)\n");
                    bw.write("# ============================================\n\n");
                    bw.write("job=WOODCUTTER;rank=1;item=woodaxe;amount=1\n");
                    bw.write("job=WOODCUTTER;rank=1;item=coin;amount=50\n");
                    bw.write("job=WOODCUTTER;rank=1;item=healthpotion;amount=3\n");
                    bw.write("job=WOODCUTTER;rank=2;item=ironaxe;amount=1\n");
                    bw.write("job=WOODCUTTER;rank=2;item=coin;amount=300\n");
                    bw.write("job=WOODCUTTER;rank=2;item=bread;amount=10\n");
                    bw.write("job=WOODCUTTER;rank=3;item=frostaxe;amount=1\n");
                    bw.write("job=WOODCUTTER;rank=3;item=coin;amount=600\n");
                    bw.write("job=WOODCUTTER;rank=3;item=healthpotion;amount=10\n");
                    bw.write("job=WOODCUTTER;rank=4;item=quartzaxe;amount=1\n");
                    bw.write("job=WOODCUTTER;rank=4;item=coin;amount=900\n");
                    bw.write("job=WOODCUTTER;rank=4;item=bread;amount=15\n");
                    bw.write("job=WOODCUTTER;rank=5;item=coin;amount=1200\n");
                    bw.write("job=WOODCUTTER;rank=5;item=myceliumaxe;amount=1\n");
                    bw.write("job=WOODCUTTER;rank=5;item=healthpotion;amount=20\n\n");
                    bw.write("job=MINER;rank=1;item=woodpickaxe;amount=1\n");
                    bw.write("job=MINER;rank=1;item=coin;amount=50\n");
                    bw.write("job=MINER;rank=1;item=healthpotion;amount=3\n");
                    bw.write("job=MINER;rank=2;item=ironpickaxe;amount=1\n");
                    bw.write("job=MINER;rank=2;item=coin;amount=300\n");
                    bw.write("job=MINER;rank=2;item=torch;amount=25\n");
                    bw.write("job=MINER;rank=3;item=frostpickaxe;amount=1\n");
                    bw.write("job=MINER;rank=3;item=coin;amount=600\n");
                    bw.write("job=MINER;rank=3;item=healthpotion;amount=10\n");
                    bw.write("job=MINER;rank=4;item=quartzpickaxe;amount=1\n");
                    bw.write("job=MINER;rank=4;item=coin;amount=900\n");
                    bw.write("job=MINER;rank=4;item=bread;amount=15\n");
                    bw.write("job=MINER;rank=5;item=coin;amount=1200\n");
                    bw.write("job=MINER;rank=5;item=icepickaxe;amount=1\n");
                    bw.write("job=MINER;rank=5;item=healthpotion;amount=20\n\n");
                    bw.write("job=HUNTER;rank=1;item=woodbow;amount=1\n");
                    bw.write("job=HUNTER;rank=1;item=arrow;amount=50\n");
                    bw.write("job=HUNTER;rank=1;item=coin;amount=50\n");
                    bw.write("job=HUNTER;rank=2;item=ironbow;amount=1\n");
                    bw.write("job=HUNTER;rank=2;item=arrow;amount=75\n");
                    bw.write("job=HUNTER;rank=2;item=coin;amount=300\n");
                    bw.write("job=HUNTER;rank=3;item=frostbow;amount=1\n");
                    bw.write("job=HUNTER;rank=3;item=ironarrow;amount=100\n");
                    bw.write("job=HUNTER;rank=3;item=coin;amount=600\n");
                    bw.write("job=HUNTER;rank=4;item=ironarrow;amount=150\n");
                    bw.write("job=HUNTER;rank=4;item=arachnidwebbow;amount=1\n");
                    bw.write("job=HUNTER;rank=4;item=coin;amount=900\n");
                    bw.write("job=HUNTER;rank=5;item=antiquebow;amount=1\n");
                    bw.write("job=HUNTER;rank=5;item=ironarrow;amount=200\n");
                    bw.write("job=HUNTER;rank=5;item=coin;amount=1200\n\n");
                    bw.write("job=SLAYER;rank=1;item=woodspear;amount=1\n");
                    bw.write("job=SLAYER;rank=1;item=coin;amount=50\n");
                    bw.write("job=SLAYER;rank=1;item=healthpotion;amount=5\n");
                    bw.write("job=SLAYER;rank=2;item=ironspear;amount=1\n");
                    bw.write("job=SLAYER;rank=2;item=coin;amount=300\n");
                    bw.write("job=SLAYER;rank=3;item=voidspear;amount=1\n");
                    bw.write("job=SLAYER;rank=3;item=coin;amount=600\n");
                    bw.write("job=SLAYER;rank=3;item=healthpotion;amount=10\n");
                    bw.write("job=SLAYER;rank=4;item=tungstenspear;amount=1\n");
                    bw.write("job=SLAYER;rank=4;item=coin;amount=900\n");
                    bw.write("job=SLAYER;rank=4;item=bread;amount=30\n");
                    bw.write("job=SLAYER;rank=5;item=cryospear;amount=1\n");
                    bw.write("job=SLAYER;rank=5;item=coin;amount=1200\n");
                    bw.write("job=SLAYER;rank=5;item=healthpotion;amount=20\n\n");
                    bw.write("job=FISHER;rank=1;item=woodfishingrod;amount=1\n");
                    bw.write("job=FISHER;rank=1;item=bait;amount=25\n");
                    bw.write("job=FISHER;rank=1;item=coin;amount=50\n");
                    bw.write("job=FISHER;rank=2;item=ironfishingrod;amount=1\n");
                    bw.write("job=FISHER;rank=2;item=bait;amount=35\n");
                    bw.write("job=FISHER;rank=2;item=coin;amount=300\n");
                    bw.write("job=FISHER;rank=3;item=overgrownfishingrod;amount=1\n");
                    bw.write("job=FISHER;rank=3;item=bait;amount=45\n");
                    bw.write("job=FISHER;rank=3;item=coin;amount=600\n");
                    bw.write("job=FISHER;rank=4;item=goldfishingrod;amount=1\n");
                    bw.write("job=FISHER;rank=4;item=fishinglure;amount=2\n");
                    bw.write("job=FISHER;rank=4;item=bait;amount=80\n");
                    bw.write("job=FISHER;rank=4;item=coin;amount=900\n");
                    bw.write("job=FISHER;rank=5;item=depthscatcher;amount=1\n");
                    bw.write("job=FISHER;rank=5;item=fishinglure;amount=3\n");
                    bw.write("job=FISHER;rank=5;item=bait;amount=80\n");
                    bw.write("job=FISHER;rank=5;item=coin;amount=1200\n");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                System.out.println("[JobsMod] Failed to create default jobs_ranks_rewards.txt: " + e.getMessage());
                return;
            }
            System.out.println("[JobsMod] jobs_ranks_rewards.txt created with default values.");
        }
        try {
            Throwable e = null;
            var3_7 = null;
            try (BufferedReader br = Files.newBufferedReader(p, StandardCharsets.UTF_8);){
                String line;
                while ((line = br.readLine()) != null) {
                    List<RewardEntry> list;
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    String[] parts = line.split(";");
                    String job = null;
                    Integer rank = null;
                    String item = null;
                    Integer amount = null;
                    String[] stringArray = parts;
                    int n = parts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String part = stringArray[n2];
                        String[] kv = part.split("=");
                        if (kv.length == 2) {
                            String key = kv[0].trim();
                            String val = kv[1].trim();
                            try {
                                if (key.equals("job")) {
                                    job = val.toUpperCase(Locale.ROOT);
                                } else if (key.equals("rank")) {
                                    rank = Integer.parseInt(val);
                                } else if (key.equals("item")) {
                                    item = val;
                                } else if (key.equals("amount")) {
                                    amount = Integer.parseInt(val);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        ++n2;
                    }
                    if (job == null || rank == null || item == null || amount == null || rank <= 0 || amount <= 0) continue;
                    Map<Integer, List<RewardEntry>> byRank = this.rankRewards.get(job);
                    if (byRank == null) {
                        byRank = new HashMap<Integer, List<RewardEntry>>();
                        this.rankRewards.put(job, byRank);
                    }
                    if ((list = byRank.get(rank)) == null) {
                        list = new ArrayList<RewardEntry>();
                        byRank.put(rank, list);
                    }
                    list.add(new RewardEntry(item, amount));
                }
                System.out.println("[JobsMod] Rank rewards loaded: " + this.rankRewards.size() + " jobs.");
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            System.out.println("[JobsMod] Error loading jobs_ranks_rewards.txt: " + e.getMessage());
        }
    }

    private void giveRankRewards(ServerClient sc, JobType job, int rank) {
        Map<Integer, List<RewardEntry>> jobRewards = this.rankRewards.get(job.name());
        if (jobRewards == null) {
            return;
        }
        List<RewardEntry> rewards = jobRewards.get(rank);
        if (rewards == null) {
            return;
        }
        for (RewardEntry r : rewards) {
            GenericGiveUtil.give(sc, r.item, r.amount);
            this.send(sc, "[Jobs] Rank reward: +" + r.amount + " " + r.item);
        }
    }

    private void loadRankConfig() {
        Object var4_8;
        this.rankCoins.clear();
        Path p = Paths.get("jobs_rank_config.txt", new String[0]);
        int[] defaultThresholds = new int[]{1, 10, 25, 50, 100};
        if (!Files.exists(p, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                var4_8 = null;
                try (BufferedWriter bw = Files.newBufferedWriter(p, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                    bw.write("# Eternal RPG - Jobs rank config\n");
                    bw.write("# Format:\n");
                    bw.write("# job=JOBNAME;rank1=COINS;rank2=COINS;rank3=COINS;rank4=COINS;rank5=COINS\n\n");
                    bw.write("job=WOODCUTTER;rank1=1;rank2=50;rank3=150;rank4=200;rank5=250\n");
                    bw.write("job=MINER;rank1=1;rank2=50;rank3=80;rank4=140;rank5=200\n");
                    bw.write("job=HUNTER;rank1=1;rank2=50;rank3=100;rank4=150;rank5=200\n");
                    bw.write("job=SLAYER;rank1=2;rank2=50;rank3=100;rank4=150;rank5=250\n");
                    bw.write("job=FISHER;rank1=1;rank2=10;rank3=25;rank4=50;rank5=83\n");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                System.out.println("[JobsMod] Failed to create jobs_rank_config.txt: " + e.getMessage());
            }
        }
        try {
            Throwable e = null;
            var4_8 = null;
            try (BufferedReader br = Files.newBufferedReader(p, StandardCharsets.UTF_8);){
                String line;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    String[] parts = line.split(";");
                    String jobStr = null;
                    int[] th = Arrays.copyOf(defaultThresholds, 5);
                    String[] stringArray = parts;
                    int n = parts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String part = stringArray[n2];
                        String[] kv = part.split("=");
                        if (kv.length == 2) {
                            String key = kv[0].trim();
                            String val = kv[1].trim();
                            try {
                                if (key.equals("job")) {
                                    jobStr = val.toUpperCase(Locale.ROOT);
                                } else if (key.equals("rank1")) {
                                    th[0] = Integer.parseInt(val);
                                } else if (key.equals("rank2")) {
                                    th[1] = Integer.parseInt(val);
                                } else if (key.equals("rank3")) {
                                    th[2] = Integer.parseInt(val);
                                } else if (key.equals("rank4")) {
                                    th[3] = Integer.parseInt(val);
                                } else if (key.equals("rank5")) {
                                    th[4] = Integer.parseInt(val);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        ++n2;
                    }
                    if (jobStr == null) continue;
                    JobType jt = null;
                    try {
                        jt = JobType.valueOf(jobStr);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (jt == null || jt == JobType.NONE) continue;
                    int i = 1;
                    while (i < th.length) {
                        if (th[i] < th[i - 1]) {
                            th[i] = th[i - 1];
                        }
                        ++i;
                    }
                    this.rankCoins.put(jt, th);
                }
                System.out.println("[JobsMod] Rank config loaded: " + this.rankCoins.size() + " jobs.");
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            System.out.println("[JobsMod] Error loading jobs_rank_config.txt: " + e.getMessage());
        }
        JobType[] jobTypeArray = JobType.values();
        int n = jobTypeArray.length;
        int n3 = 0;
        while (n3 < n) {
            JobType jt = jobTypeArray[n3];
            if (jt != JobType.NONE && !this.rankCoins.containsKey((Object)jt)) {
                this.rankCoins.put(jt, Arrays.copyOf(defaultThresholds, 5));
            }
            ++n3;
        }
    }

    private void save() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(this.storePath, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                for (Map.Entry<Integer, JobType> entry : this.jobBySlot.entrySet()) {
                    Integer p;
                    int slot = entry.getKey();
                    String name = this.sanitize(this.nameBySlot.getOrDefault(slot, "unknown"));
                    JobType jt = entry.getValue();
                    if (jt == null) {
                        jt = JobType.NONE;
                    }
                    int prog = 0;
                    Map<JobType, Integer> jobsMap = this.progressByNameJob.get(name);
                    if (jobsMap != null && (p = jobsMap.get((Object)jt)) != null) {
                        prog = p;
                    }
                    bw.write(slot + ";" + name + ";" + jt.name() + ";" + prog + "\n");
                }
                for (Map.Entry<Object, Object> entry : this.progressByNameJob.entrySet()) {
                    Map jobsMap;
                    String name = this.sanitize((String)entry.getKey());
                    if (name.isEmpty() || (jobsMap = (Map)entry.getValue()) == null) continue;
                    for (Map.Entry jEntry : jobsMap.entrySet()) {
                        JobType jt = (JobType)((Object)jEntry.getKey());
                        int prog = (Integer)jEntry.getValue();
                        bw.write("-1;" + name + ";" + jt.name() + ";" + prog + "\n");
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void load() {
        this.jobBySlot.clear();
        this.progressBySlot.clear();
        this.nameBySlot.clear();
        this.jobByName.clear();
        this.progressByName.clear();
        this.progressByNameJob.clear();
        if (!Files.exists(this.storePath, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader br = Files.newBufferedReader(this.storePath, StandardCharsets.UTF_8);){
                while (true) {
                    int prog;
                    JobType jt;
                    int slot;
                    String[] parts;
                    String line;
                    if ((line = br.readLine()) == null) {
                        return;
                    }
                    if ((line = line.trim()).isEmpty() || (parts = line.split(";")).length < 4) continue;
                    try {
                        slot = Integer.parseInt(parts[0]);
                    }
                    catch (NumberFormatException ex) {
                        continue;
                    }
                    String name = parts[1];
                    if (name == null || name.isEmpty()) continue;
                    try {
                        jt = JobType.valueOf(parts[2]);
                    }
                    catch (IllegalArgumentException ex) {
                        jt = JobType.NONE;
                    }
                    try {
                        prog = Integer.parseInt(parts[3]);
                    }
                    catch (NumberFormatException ex) {
                        prog = 0;
                    }
                    Map<JobType, Integer> jobsMap = this.progressByNameJob.get(name);
                    if (jobsMap == null) {
                        jobsMap = new ConcurrentHashMap<JobType, Integer>();
                        this.progressByNameJob.put(name, jobsMap);
                    }
                    jobsMap.put(jt, prog);
                    if (slot < 0) continue;
                    this.jobByName.put(name, jt);
                    this.progressByName.put(name, prog);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String sanitize(String s) {
        if (s == null) {
            return "unknown";
        }
        return s.replace(';', '_').replace('\n', ' ').replace('\r', ' ');
    }

    private String snapshotName(ServerClient sc) {
        block13: {
            String n = null;
            try {
                n = sc.getName();
                if (n != null && !n.isEmpty()) {
                    this.nameBySlot.put(sc.slot, n);
                    return n;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                String s;
                String gm;
                if (sc.playerMob == null || (gm = sc.playerMob.getDisplayName()) == null) break block13;
                try {
                    Object tr = gm.getClass().getMethod("translate", new Class[0]).invoke((Object)gm, new Object[0]);
                    if (tr instanceof String && !(s = (String)tr).isEmpty()) {
                        this.nameBySlot.put(sc.slot, s);
                        return s;
                    }
                }
                catch (Throwable tr) {
                    // empty catch block
                }
                try {
                    Object gs = gm.getClass().getMethod("getString", new Class[0]).invoke((Object)gm, new Object[0]);
                    if (gs instanceof String && !(s = (String)gs).isEmpty()) {
                        this.nameBySlot.put(sc.slot, s);
                        return s;
                    }
                }
                catch (Throwable gs) {
                    // empty catch block
                }
                String s2 = gm.toString();
                if (s2 != null && !s2.isEmpty()) {
                    this.nameBySlot.put(sc.slot, s2);
                    return s2;
                }
            }
            catch (Throwable gm) {
                // empty catch block
            }
        }
        String fallback = this.nameBySlot.get(sc.slot);
        if (fallback == null || fallback.isEmpty()) {
            fallback = "unknown";
        }
        return fallback;
    }

    private void ensureLoadedFor(ServerClient sc) {
        Integer p;
        if (sc == null) {
            return;
        }
        String nick = this.snapshotName(sc);
        JobType jt = this.jobBySlot.get(sc.slot);
        String storedName = this.nameBySlot.get(sc.slot);
        if (jt == null || storedName == null || !storedName.equalsIgnoreCase(nick)) {
            jt = this.jobByName.get(nick);
            if (jt == null) {
                jt = JobType.NONE;
            }
            this.jobBySlot.put(sc.slot, jt);
        }
        Map<JobType, Integer> jobsMap = this.progressByNameJob.get(nick);
        int prog = 0;
        if (jobsMap != null && (p = jobsMap.get((Object)jt)) != null) {
            prog = p;
        }
        this.progressBySlot.put(sc.slot, prog);
        this.progressByName.put(nick, prog);
        this.nameBySlot.put(sc.slot, nick);
        this.jobByName.put(nick, jt);
    }

    public void adminSetProgress(ServerClient admin, String playerName, String jobName, int progress) {
        JobType jt = this.parseJob(jobName);
        if (jt == JobType.NONE) {
            this.send(admin, "[Jobs] Unknown job: " + jobName);
            return;
        }
        if (playerName == null || playerName.trim().isEmpty()) {
            this.send(admin, "[Jobs] Invalid player name.");
            return;
        }
        String targetName = playerName.trim();
        int p = Math.max(0, progress);
        Map<JobType, Integer> jobsMap = this.progressByNameJob.get(targetName);
        if (jobsMap == null) {
            jobsMap = new ConcurrentHashMap<JobType, Integer>();
            this.progressByNameJob.put(targetName, jobsMap);
        }
        jobsMap.put(jt, p);
        for (Map.Entry<Integer, String> e : this.nameBySlot.entrySet()) {
            int slot;
            JobType current;
            String n = e.getValue();
            if (n == null || !n.equalsIgnoreCase(targetName) || (current = this.jobBySlot.get(slot = e.getKey().intValue())) != jt) continue;
            this.progressBySlot.put(slot, p);
        }
        this.jobByName.put(targetName, jt);
        this.progressByName.put(targetName, p);
        this.save();
        this.send(admin, "[Jobs] Set " + targetName + " job " + String.valueOf((Object)jt) + " progress to " + p + ".");
    }

    private JobType parseJob(String s) {
        if (s == null) {
            return JobType.NONE;
        }
        if ((s = s.trim().toLowerCase(Locale.ROOT)).equals("woodcutter") || s.equals("drvoseca") || s.equals("drvosjeca")) {
            return JobType.WOODCUTTER;
        }
        if (s.equals("miner") || s.equals("mining") || s.equals("rudar")) {
            return JobType.MINER;
        }
        if (s.equals("hunter") || s.equals("lovac")) {
            return JobType.HUNTER;
        }
        if (s.equals("slayer") || s.equals("ubica")) {
            return JobType.SLAYER;
        }
        if (s.equals("fisher") || s.equals("fishing") || s.equals("pecaros")) {
            return JobType.FISHER;
        }
        return JobType.NONE;
    }

    public static enum JobType {
        NONE,
        WOODCUTTER,
        MINER,
        HUNTER,
        SLAYER,
        FISHER;

    }

    private static class RewardEntry {
        final String item;
        final int amount;

        RewardEntry(String item, int amount) {
            this.item = item;
            this.amount = amount;
        }
    }
}

