/*
 * Decompiled with CFR 0.152.
 */
package com.jobs;

import com.jobs.JobsJobInfoForm;
import java.util.Locale;
import necesse.engine.network.Packet;
import necesse.engine.network.client.Client;
import necesse.engine.network.packet.PacketChatMessage;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.MainGameFormManager;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormLabel;
import necesse.gfx.forms.components.FormTextButton;
import necesse.gfx.gameFont.FontOptions;

public class JobsGuiForm
extends Form {
    private final Client client;
    private final MainGameFormManager formManager;
    private final String canonicalName;
    final String displayName;
    private String currentJob;
    private FormLabel currentJobLabel;
    private final int[] jobActions;
    private final int[] jobRanks;
    private static final String[] JOB_CODES = new String[]{"WOODCUTTER", "MINER", "HUNTER", "SLAYER", "FISHER"};
    private static final String[] JOB_NAMES = new String[]{"Woodcutter", "Miner", "Hunter", "Slayer", "Fisher"};

    public JobsGuiForm(Client client, MainGameFormManager formManager, String canonicalName, String displayName, String currentJob, int[] jobActions, int[] jobRanks) {
        super("jobsGuiForm", 900, 260);
        this.client = client;
        this.formManager = formManager;
        this.canonicalName = canonicalName;
        this.displayName = displayName != null ? displayName : canonicalName;
        this.currentJob = currentJob == null || currentJob.isEmpty() ? "Unemployed" : currentJob;
        this.jobActions = jobActions != null ? jobActions : new int[]{};
        this.jobRanks = jobRanks != null ? jobRanks : new int[]{};
        this.buildGui();
    }

    private void buildGui() {
        FontOptions titleFont = new FontOptions(22);
        FontOptions infoFont = new FontOptions(16);
        FontOptions jobFont = new FontOptions(16);
        FormTextButton closeBtn = (FormTextButton)this.addComponent((FormComponent)new FormTextButton("X", this.getWidth() - 26, 6, 20));
        closeBtn.onClicked(e -> this.setHidden(true));
        this.addComponent((FormComponent)new FormLabel("Jobs - " + this.displayName, titleFont, -1, 16, 16));
        this.currentJobLabel = (FormLabel)this.addComponent((FormComponent)new FormLabel("Your current Job: " + this.currentJob, infoFont, -1, 16, 52));
        this.addComponent((FormComponent)new FormLabel("Choose a job and click Join to start, or Leave to quit your job.", new FontOptions(14), -1, 16, 74));
        this.addComponent((FormComponent)new FormLabel("Each job gives coins as you work, and every rank automatically grants you a special kit.", new FontOptions(14), -1, 16, 92));
        int rowYNames = 120;
        int rowYButtons = 150;
        int colCount = JOB_CODES.length;
        int leftMargin = 80;
        int rightMargin = 80;
        int usableWidth = this.getWidth() - leftMargin - rightMargin;
        int colStep = colCount > 1 ? usableWidth / (colCount - 1) : 0;
        int i = 0;
        while (i < colCount) {
            int colX = leftMargin + i * colStep;
            String jobNice = JOB_NAMES[i];
            this.addComponent((FormComponent)new FormLabel(jobNice.toUpperCase(Locale.ROOT), jobFont, -1, colX - 60, rowYNames));
            FormTextButton joinBtn = (FormTextButton)this.addComponent((FormComponent)new FormTextButton("Join", colX - 70, rowYButtons, 60));
            int idx = i++;
            joinBtn.onClicked(e -> this.onJoinJob(idx));
            FormTextButton infoBtn = (FormTextButton)this.addComponent((FormComponent)new FormTextButton("Info", colX + 10, rowYButtons, 60));
            infoBtn.onClicked(e -> this.onInfoJob(idx));
        }
        FormTextButton leaveBtn = (FormTextButton)this.addComponent((FormComponent)new FormTextButton("Leave job", this.getWidth() / 2 - 70, 200, 140));
        leaveBtn.onClicked(e -> this.onLeaveJob());
    }

    private void onJoinJob(int index) {
        if (this.client == null || index < 0 || index >= JOB_CODES.length) {
            return;
        }
        String code = JOB_CODES[index].toLowerCase(Locale.ROOT);
        String nice = JOB_NAMES[index];
        String cmd = "/job join " + code;
        try {
            this.client.network.sendPacket((Packet)new PacketChatMessage(this.client.getSlot(), cmd));
        }
        catch (Throwable t) {
            System.out.println("[JobsMod] Failed to send /job join cmd: " + String.valueOf(t));
        }
        this.setCurrentJob(nice);
    }

    private void onLeaveJob() {
        if (this.client == null) {
            return;
        }
        try {
            this.client.network.sendPacket((Packet)new PacketChatMessage(this.client.getSlot(), "/job leave"));
        }
        catch (Throwable t) {
            System.out.println("[JobsMod] Failed to send /job leave cmd: " + String.valueOf(t));
        }
        this.setCurrentJob("Unemployed");
    }

    private void onInfoJob(int index) {
        if (this.formManager == null) {
            return;
        }
        if (index < 0 || index >= JOB_CODES.length) {
            return;
        }
        String jobNice = JOB_NAMES[index];
        int xp = this.jobActions != null && index < this.jobActions.length ? this.jobActions[index] : 0;
        int rank = this.jobRanks != null && index < this.jobRanks.length ? this.jobRanks[index] : 0;
        JobsJobInfoForm infoForm = new JobsJobInfoForm(this.formManager, this, this.displayName, jobNice, rank, xp);
        this.formManager.addComponent((FormComponent)infoForm);
        this.setHidden(true);
        infoForm.setHidden(false);
    }

    private void setCurrentJob(String jobName) {
        String string = this.currentJob = jobName != null && !jobName.isEmpty() ? jobName : "Unemployed";
        if (this.currentJobLabel != null) {
            this.currentJobLabel.setText("Your current Job: " + this.currentJob);
        }
    }
}

