/*
 * Decompiled with CFR 0.152.
 */
package com.jobs;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;

public final class JobsConfig {
    private final Path path = Paths.get("jobsmod_config.txt", new String[0]);
    private volatile long lastLoadedTs = -1L;
    private final Map<String, Integer> defaults = Map.ofEntries(Map.entry("TREES_PER_COIN", 1), Map.entry("ORES_PER_COIN", 1), Map.entry("FRIENDLY_PER_COIN", 1), Map.entry("HOSTILE_PER_COIN", 1), Map.entry("FISH_PER_COIN", 1), Map.entry("COINS_FOR_TREES", 1), Map.entry("COINS_FOR_ORES", 1), Map.entry("COINS_FOR_FRIENDLY", 1), Map.entry("COINS_FOR_HOSTILE", 1), Map.entry("COINS_FOR_FISH", 1));
    private final Map<String, Integer> values = new HashMap<String, Integer>();

    public JobsConfig() {
        this.ensureFileExists();
        this.reloadIfChanged();
    }

    private void ensureFileExists() {
        if (Files.exists(this.path, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(this.path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                bw.write("# Eternal RPG - Jobs config\n");
                bw.write("# koliko akcija treba za 1 coin\n");
                bw.write("TREES_PER_COIN=1\n");
                bw.write("ORES_PER_COIN=1\n");
                bw.write("FRIENDLY_PER_COIN=1\n");
                bw.write("HOSTILE_PER_COIN=1\n");
                bw.write("FISH_PER_COIN=1\n");
                bw.write("\n");
                bw.write("# koliko coins se daje kad se ispuni kvota\n");
                bw.write("COINS_FOR_TREES=1\n");
                bw.write("COINS_FOR_ORES=1\n");
                bw.write("COINS_FOR_FRIENDLY=1\n");
                bw.write("COINS_FOR_HOSTILE=1\n");
                bw.write("COINS_FOR_FISH=1\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("[JobsMod][Config] Failed to create default jobsmod_config.txt: " + e.getMessage());
        }
    }

    public synchronized void reloadIfChanged() {
        try {
            long ts = Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
            if (ts == this.lastLoadedTs && !this.values.isEmpty()) {
                return;
            }
        }
        catch (IOException ts) {
            // empty catch block
        }
        HashMap<String, Integer> tmp = new HashMap<String, Integer>(this.defaults);
        try {
            if (!Files.exists(this.path, new LinkOption[0])) {
                this.ensureFileExists();
            }
            for (String line : Files.readAllLines(this.path, StandardCharsets.UTF_8)) {
                int idx;
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || (idx = line.indexOf(61)) <= 0) continue;
                String k = line.substring(0, idx).trim();
                String v = line.substring(idx + 1).trim();
                try {
                    int val = Integer.parseInt(v);
                    tmp.put(k, Math.max(0, val));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.values.clear();
        this.values.putAll(tmp);
        try {
            this.lastLoadedTs = Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("[JobsMod][Config] Loaded: " + String.valueOf(this.values));
    }

    public int treesPerCoin() {
        return this.values.getOrDefault("TREES_PER_COIN", this.defaults.get("TREES_PER_COIN"));
    }

    public int oresPerCoin() {
        return this.values.getOrDefault("ORES_PER_COIN", this.defaults.get("ORES_PER_COIN"));
    }

    public int friendlyPerCoin() {
        return this.values.getOrDefault("FRIENDLY_PER_COIN", this.defaults.get("FRIENDLY_PER_COIN"));
    }

    public int hostilePerCoin() {
        return this.values.getOrDefault("HOSTILE_PER_COIN", this.defaults.get("HOSTILE_PER_COIN"));
    }

    public int fishPerCoin() {
        return this.values.getOrDefault("FISH_PER_COIN", this.defaults.get("FISH_PER_COIN"));
    }

    public int coinsForTrees() {
        return this.values.getOrDefault("COINS_FOR_TREES", this.defaults.get("COINS_FOR_TREES"));
    }

    public int coinsForOres() {
        return this.values.getOrDefault("COINS_FOR_ORES", this.defaults.get("COINS_FOR_ORES"));
    }

    public int coinsForFriendly() {
        return this.values.getOrDefault("COINS_FOR_FRIENDLY", this.defaults.get("COINS_FOR_FRIENDLY"));
    }

    public int coinsForHostile() {
        return this.values.getOrDefault("COINS_FOR_HOSTILE", this.defaults.get("COINS_FOR_HOSTILE"));
    }

    public int coinsForFish() {
        return this.values.getOrDefault("COINS_FOR_FISH", this.defaults.get("COINS_FOR_FISH"));
    }

    public Map<String, Integer> snapshot() {
        return new HashMap<String, Integer>(this.values);
    }
}

