/*
 * Decompiled with CFR 0.152.
 */
package com.jobs;

import com.jobs.JobsMod;
import com.jobs.PermissionsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import necesse.engine.commands.AutoComplete;
import necesse.engine.commands.ChatCommand;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.CommandsManager;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;

public class JobCommand
extends ChatCommand {
    private JobCommand() {
        super("job", PermissionLevel.USER);
    }

    public static void register() {
        CommandsManager.registerServerCommand((ChatCommand)new JobCommand());
    }

    public boolean isCheat() {
        return false;
    }

    public String getUsage() {
        return "/job gui>";
    }

    public String getAction() {
        return "Jobs system";
    }

    public String getCurrentUsage(Client c, Server s, ServerClient sc, String[] args) {
        return "Usage: /job gui";
    }

    public List<AutoComplete> autocomplete(Client c, Server s, ServerClient sc, String[] args) {
        return Collections.emptyList();
    }

    public boolean run(Client client, Server server, ServerClient sc, ArrayList<String> args, CommandLog log) {
        if (sc == null) {
            log.add("Server-only.");
            return false;
        }
        if (args.isEmpty()) {
            JobsMod.JOBS.openGui(sc);
            return true;
        }
        String sub = args.get(0).toLowerCase(Locale.ROOT);
        if (sub.equals("reloadcfg")) {
            if (!PermissionsUtil.isAdminOrOwner(sc)) {
                JobsMod.JOBS.send(sc, "[Jobs] You don't have permission to use /job reloadcfg");
                return false;
            }
            JobsMod.JOBS.reloadConfig(sc);
            return true;
        }
        if (sub.equals("xpset")) {
            int progress;
            if (!PermissionsUtil.isAdminOrOwner(sc)) {
                JobsMod.JOBS.send(sc, "[Jobs] You don't have permission to use /job xpset");
                return false;
            }
            if (args.size() < 4) {
                JobsMod.JOBS.send(sc, "Usage: /job xpset <player> <job> <progress>");
                return false;
            }
            String playerName = args.get(1);
            String jobName = args.get(2);
            try {
                progress = Integer.parseInt(args.get(3));
            }
            catch (NumberFormatException e) {
                JobsMod.JOBS.send(sc, "[Jobs] Progress must be a number.");
                return false;
            }
            JobsMod.JOBS.adminSetProgress(sc, playerName, jobName, progress);
            return true;
        }
        if (sub.equals("info")) {
            JobsMod.JOBS.info(sc);
            return true;
        }
        if (sub.equals("join")) {
            if (args.size() < 2) {
                JobsMod.JOBS.send(sc, "Usage: /job join <name>");
                return false;
            }
            JobsMod.JOBS.joinJob(sc, args.get(1));
            return true;
        }
        if (sub.equals("list")) {
            JobsMod.JOBS.send(sc, "Available jobs: " + String.join((CharSequence)", ", JobsMod.JOBS.listJobs()));
            return true;
        }
        if (sub.equals("leave")) {
            JobsMod.JOBS.leaveJob(sc);
            return true;
        }
        if (sub.equals("rank")) {
            JobsMod.JOBS.showRank(sc);
            return true;
        }
        if (sub.equals("gui")) {
            JobsMod.JOBS.openGui(sc);
            return true;
        }
        JobsMod.JOBS.send(sc, "Unknown subcommand. Use: list | join | leave | info | rank | gui | reloadcfg | xpset");
        return false;
    }
}

