/*
 * Decompiled with CFR 0.152.
 */
package com.loginmod;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;

public class TextStore {
    private final Path file;
    private final Map<String, String> db = new LinkedHashMap<String, String>();

    public TextStore(String filename) {
        this.file = Paths.get(filename, new String[0]);
        try {
            if (!Files.exists(this.file, new LinkOption[0])) {
                if (this.file.getParent() != null) {
                    Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
                }
                Files.createFile(this.file, new FileAttribute[0]);
            }
            for (String line : Files.readAllLines(this.file, StandardCharsets.UTF_8)) {
                String[] p;
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || (p = line.split(":", 2)).length != 2) continue;
                this.db.put(p[0], p[1]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean register(String user, String pass) {
        if (this.db.containsKey(user)) {
            return false;
        }
        this.db.put(user, pass);
        this.flush();
        return true;
    }

    public synchronized boolean check(String user, String pass) {
        return pass.equals(this.db.get(user));
    }

    public synchronized void flush() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedWriter w = Files.newBufferedWriter(this.file, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING);){
                for (Map.Entry<String, String> e : this.db.entrySet()) {
                    w.write(e.getKey() + ":" + e.getValue());
                    w.newLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

