/*
 * Decompiled with CFR 0.152.
 */
package com.loginmod;

import com.loginmod.ChangePassCommand;
import com.loginmod.LoginCommand;
import com.loginmod.LoginManager;
import com.loginmod.RegisterCommand;
import com.loginmod.ResetUserCommand;
import necesse.engine.GameEventInterface;
import necesse.engine.GameEventListener;
import necesse.engine.GameEvents;
import necesse.engine.commands.ChatCommand;
import necesse.engine.commands.CommandsManager;
import necesse.engine.events.ServerClientConnectedEvent;
import necesse.engine.events.ServerClientDisconnectEvent;
import necesse.engine.events.ServerStartEvent;
import necesse.engine.events.ServerStopEvent;
import necesse.engine.events.players.MobInteractEvent;
import necesse.engine.events.players.ObjectDamageEvent;
import necesse.engine.events.players.ObjectInteractEvent;
import necesse.engine.events.players.TileDamageEvent;
import necesse.engine.network.server.ServerClient;

public class LoginMod {
    public static final LoginManager LOGIN = new LoginManager();

    public static void init() {
        CommandsManager.registerServerCommand((ChatCommand)new LoginCommand());
        CommandsManager.registerServerCommand((ChatCommand)new RegisterCommand());
        CommandsManager.registerServerCommand((ChatCommand)new ChangePassCommand());
        CommandsManager.registerServerCommand((ChatCommand)new ResetUserCommand());
        GameEvents.addListener(ServerStartEvent.class, (GameEventInterface)new GameEventListener<ServerStartEvent>(){

            public void onEvent(ServerStartEvent e) {
                LOGIN.attachServer(e.server);
                LOGIN.load();
            }
        });
        GameEvents.addListener(ServerStopEvent.class, (GameEventInterface)new GameEventListener<ServerStopEvent>(){

            public void onEvent(ServerStopEvent e) {
                LOGIN.save();
                LOGIN.detachServer();
            }
        });
        GameEvents.addListener(ServerClientConnectedEvent.class, (GameEventInterface)new GameEventListener<ServerClientConnectedEvent>(){

            public void onEvent(ServerClientConnectedEvent e) {
                ServerClient sc = e.client;
                LOGIN.markNotLogged(sc);
                LOGIN.freeze(sc);
                LOGIN.rememberPos(sc);
                String name = LoginMod.safePlayerName(sc);
                if (LOGIN.hasAccount(name)) {
                    LOGIN.send(sc, "Welcome back, " + name + "!");
                    LOGIN.send(sc, "You are already registered. Please /login <password> to play.");
                } else {
                    LOGIN.send(sc, "Welcome " + name + "!");
                    LOGIN.send(sc, "To play, please /register <password>.");
                }
            }
        });
        GameEvents.addListener(ServerClientDisconnectEvent.class, (GameEventInterface)new GameEventListener<ServerClientDisconnectEvent>(){

            public void onEvent(ServerClientDisconnectEvent e) {
                LOGIN.clear(e.client);
            }
        });
        GameEvents.addListener(ObjectInteractEvent.class, (GameEventInterface)new GameEventListener<ObjectInteractEvent>(){

            public void onEvent(ObjectInteractEvent e) {
                try {
                    ServerClient sc = e.player.getServerClient();
                    if (sc != null && !LOGIN.isLogged(sc)) {
                        e.preventDefault();
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        });
        GameEvents.addListener(ObjectDamageEvent.class, (GameEventInterface)new GameEventListener<ObjectDamageEvent>(){

            public void onEvent(ObjectDamageEvent e) {
                try {
                    ServerClient sc = e.client;
                    if (sc != null && !LOGIN.isLogged(sc)) {
                        e.preventDefault();
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        });
        GameEvents.addListener(TileDamageEvent.class, (GameEventInterface)new GameEventListener<TileDamageEvent>(){

            public void onEvent(TileDamageEvent e) {
                try {
                    ServerClient sc = e.client;
                    if (sc != null && !LOGIN.isLogged(sc)) {
                        e.preventDefault();
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        });
        GameEvents.addListener(MobInteractEvent.class, (GameEventInterface)new GameEventListener<MobInteractEvent>(){

            public void onEvent(MobInteractEvent e) {
                try {
                    ServerClient sc = e.player.getServerClient();
                    if (sc != null && !LOGIN.isLogged(sc)) {
                        e.preventDefault();
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        });
    }

    private static String safePlayerName(ServerClient sc) {
        Object n2;
        block15: {
            try {
                n2 = sc.getName();
                if (n2 != null && !((String)n2).isEmpty()) {
                    return n2;
                }
            }
            catch (Throwable n2) {
                // empty catch block
            }
            try {
                String gm;
                if (sc.playerMob == null || (gm = sc.playerMob.getDisplayName()) == null) break block15;
                try {
                    Object tr = gm.getClass().getMethod("translate", new Class[0]).invoke((Object)gm, new Object[0]);
                    if (tr instanceof String && !((String)tr).isEmpty()) {
                        return (String)tr;
                    }
                }
                catch (Throwable tr) {
                    // empty catch block
                }
                try {
                    Object gs = gm.getClass().getMethod("getString", new Class[0]).invoke((Object)gm, new Object[0]);
                    if (gs instanceof String && !((String)gs).isEmpty()) {
                        return (String)gs;
                    }
                }
                catch (Throwable gs) {
                    // empty catch block
                }
                String s = gm.toString();
                if (s != null && !s.isEmpty()) {
                    return s;
                }
            }
            catch (Throwable gm) {
                // empty catch block
            }
        }
        try {
            n2 = ServerClient.class.getMethod("getName", new Class[0]).invoke((Object)sc, new Object[0]);
            if (n2 instanceof String && !((String)n2).isEmpty()) {
                return (String)n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "Player";
    }
}

