/*
 * Decompiled with CFR 0.152.
 */
package com.loginmod;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketChatMessage;
import necesse.engine.network.packet.PacketPlayerMovement;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;

public class LoginManager {
    private final Map<String, String> userToHash = new HashMap<String, String>();
    private final Set<Integer> loggedIn = new HashSet<Integer>();
    private final Map<Integer, Float> prevSpeed = new HashMap<Integer, Float>();
    private final Map<Integer, float[]> lastPos = new HashMap<Integer, float[]>();
    private final Map<Integer, Long> lastWarn = new HashMap<Integer, Long>();
    private Path storePath;
    private Server server;
    private ScheduledExecutorService freezerLoop;

    public void attachServer(Server server) {
        this.server = server;
        this.startFreezerLoop();
    }

    public void detachServer() {
        this.stopFreezerLoop();
        this.server = null;
    }

    public void load() {
        try {
            Path res = Paths.get("resources", new String[0]);
            if (!Files.exists(res, new LinkOption[0])) {
                Files.createDirectories(res, new FileAttribute[0]);
            }
            this.storePath = res.resolve("login.txt");
            if (!Files.exists(this.storePath, new LinkOption[0])) {
                Files.createFile(this.storePath, new FileAttribute[0]);
            }
            this.userToHash.clear();
            for (String line : Files.readAllLines(this.storePath, StandardCharsets.UTF_8)) {
                int i;
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || (i = line.indexOf(58)) <= 0) continue;
                this.userToHash.put(line.substring(0, i), line.substring(i + 1));
            }
            System.out.println("[LoginMod] Loaded " + this.userToHash.size() + " users");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void save() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedWriter w = Files.newBufferedWriter(this.storePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                for (Map.Entry<String, String> e : this.userToHash.entrySet()) {
                    w.write(e.getKey() + ":" + e.getValue());
                    w.newLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void send(ServerClient sc, String msg) {
        sc.getServer().network.sendPacket((Packet)new PacketChatMessage(msg), sc);
    }

    public void markNotLogged(ServerClient sc) {
        this.loggedIn.remove(sc.slot);
    }

    public void markLogged(ServerClient sc) {
        this.loggedIn.add(sc.slot);
        this.unfreeze(sc);
        String display = LoginManager.safePlayerName(sc);
        this.send(sc, "Logged in successfully! Welcome back, " + display + "!");
    }

    public void clear(ServerClient sc) {
        this.loggedIn.remove(sc.slot);
        this.prevSpeed.remove(sc.slot);
        this.lastPos.remove(sc.slot);
        this.lastWarn.remove(sc.slot);
    }

    public boolean isLogged(ServerClient sc) {
        return this.loggedIn.contains(sc.slot);
    }

    public void rememberPos(ServerClient sc) {
        this.lastPos.put(sc.slot, new float[]{sc.playerMob.x, sc.playerMob.y});
    }

    public void freeze(ServerClient sc) {
        try {
            if (!this.prevSpeed.containsKey(sc.slot)) {
                this.prevSpeed.put(sc.slot, Float.valueOf(sc.playerMob.getSpeed()));
            }
            sc.playerMob.setSpeed(0.0f);
            sc.playerMob.dx = 0.0f;
            sc.playerMob.dy = 0.0f;
            sc.playerMob.hotbarLocked = true;
            this.rememberPos(sc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unfreeze(ServerClient sc) {
        try {
            float restore = this.prevSpeed.getOrDefault(sc.slot, Float.valueOf(40.0f)).floatValue();
            sc.playerMob.setSpeed(restore);
            sc.playerMob.hotbarLocked = false;
            this.prevSpeed.remove(sc.slot);
            this.rememberPos(sc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean hasAccount(String name) {
        return this.userToHash.containsKey(name);
    }

    public boolean register(String name, String password) {
        if (this.userToHash.containsKey(name)) {
            return false;
        }
        this.userToHash.put(name, LoginManager.sha256(password));
        return true;
    }

    public boolean login(String name, String password) {
        String h = this.userToHash.get(name);
        return h != null && h.equals(LoginManager.sha256(password));
    }

    public boolean changePass(String name, String oldPass, String newPass) {
        String h = this.userToHash.get(name);
        if (h == null || !h.equals(LoginManager.sha256(oldPass))) {
            return false;
        }
        this.userToHash.put(name, LoginManager.sha256(newPass));
        this.save();
        return true;
    }

    public boolean resetUser(String username) {
        if (!this.userToHash.containsKey(username)) {
            return false;
        }
        this.userToHash.remove(username);
        this.save();
        this.load();
        System.out.println("[LoginMod] User '" + username + "' removed and login database reloaded.");
        return true;
    }

    private static String sha256(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] d = md.digest(s.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            byte[] byArray = d;
            int n = d.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                sb.append(String.format("%02x", b));
                ++n2;
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void startFreezerLoop() {
        this.stopFreezerLoop();
        this.freezerLoop = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "LoginMod-Freezer");
            t.setDaemon(true);
            return t;
        });
        this.freezerLoop.scheduleAtFixedRate(this::enforceFreeze, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    private void stopFreezerLoop() {
        if (this.freezerLoop != null) {
            this.freezerLoop.shutdownNow();
            this.freezerLoop = null;
        }
    }

    private void enforceFreeze() {
        try {
            if (this.server == null) {
                return;
            }
            for (ServerClient c : this.server.getClients()) {
                if (c == null) continue;
                if (!this.isLogged(c)) {
                    c.playerMob.setSpeed(0.0f);
                    c.playerMob.dx = 0.0f;
                    c.playerMob.dy = 0.0f;
                    c.playerMob.hotbarLocked = true;
                    float[] lp = this.lastPos.computeIfAbsent(c.slot, s -> new float[]{serverClient.playerMob.x, serverClient.playerMob.y});
                    float dx = c.playerMob.x - lp[0];
                    float dy = c.playerMob.y - lp[1];
                    if (!(dx * dx + dy * dy > 1.0E-4f)) continue;
                    c.playerMob.x = lp[0];
                    c.playerMob.y = lp[1];
                    this.server.network.sendPacket((Packet)new PacketPlayerMovement(c, false), c);
                    long now = System.currentTimeMillis();
                    long last = this.lastWarn.getOrDefault(c.slot, 0L);
                    if (now - last <= 1000L) continue;
                    this.send(c, "You must log in first!");
                    this.lastWarn.put(c.slot, now);
                    continue;
                }
                this.lastPos.put(c.slot, new float[]{c.playerMob.x, c.playerMob.y});
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String safePlayerName(ServerClient sc) {
        Object n2;
        block15: {
            try {
                n2 = sc.getName();
                if (n2 != null && !((String)n2).isEmpty()) {
                    return n2;
                }
            }
            catch (Throwable n2) {
                // empty catch block
            }
            try {
                String gm;
                if (sc.playerMob == null || (gm = sc.playerMob.getDisplayName()) == null) break block15;
                try {
                    Object tr = gm.getClass().getMethod("translate", new Class[0]).invoke((Object)gm, new Object[0]);
                    if (tr instanceof String && !((String)tr).isEmpty()) {
                        return (String)tr;
                    }
                }
                catch (Throwable tr) {
                    // empty catch block
                }
                try {
                    Object gs = gm.getClass().getMethod("getString", new Class[0]).invoke((Object)gm, new Object[0]);
                    if (gs instanceof String && !((String)gs).isEmpty()) {
                        return (String)gs;
                    }
                }
                catch (Throwable gs) {
                    // empty catch block
                }
                String s = gm.toString();
                if (s != null && !s.isEmpty()) {
                    return s;
                }
            }
            catch (Throwable gm) {
                // empty catch block
            }
        }
        try {
            n2 = ServerClient.class.getMethod("getName", new Class[0]).invoke((Object)sc, new Object[0]);
            if (n2 instanceof String && !((String)n2).isEmpty()) {
                return (String)n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "Player";
    }
}

