/*
 * Decompiled with CFR 0.152.
 */
package controlsettlershapiness.patch;

import controlsettlershapiness.ControlsettlershapinessMod;
import java.util.ArrayList;
import java.util.List;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.GameMessageBuilder;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.entity.mobs.friendly.human.HappinessModifier;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.level.maps.levelData.settlementData.SettlementBed;
import necesse.level.maps.levelData.settlementData.SettlementRoom;
import necesse.level.maps.levelData.settlementData.settler.DietThought;
import necesse.level.maps.levelData.settlementData.settler.FoodQuality;
import necesse.level.maps.levelData.settlementData.settler.PopulationThought;
import necesse.level.maps.levelData.settlementData.settler.Settler;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=HumanMob.class, name="getHappinessModifiers", arguments={})
public class HappinessModifierPatch {
    @Advice.OnMethodExit
    static void onExit(@Advice.This HumanMob ThisSettler, @Advice.Return(readOnly=false) List<HappinessModifier> modifiersList) {
        ArrayList<HappinessModifier> happinessModifiersPatch = new ArrayList<HappinessModifier>();
        if (ThisSettler.getWorldEntity() != null) {
            int differentFoodsEaten;
            DietThought dietThought;
            if (ControlsettlershapinessMod.settingsGetter.getBoolean("FoodQualityModifierEnabled")) {
                if (ThisSettler.lastFoodEaten != null && ThisSettler.lastFoodEaten.quality != null) {
                    happinessModifiersPatch.add(ThisSettler.lastFoodEaten.quality.getModifier());
                } else {
                    happinessModifiersPatch.add(FoodQuality.noFoodModifier);
                }
            }
            if (ControlsettlershapinessMod.settingsGetter.getBoolean("DifferentFoodsEatenModifierEnabled") && (dietThought = Settler.getDietThought((int)(differentFoodsEaten = (int)ThisSettler.recentFoodItemIDsEaten.stream().distinct().count()))) != null) {
                happinessModifiersPatch.add(dietThought.getModifier());
            }
            if (ThisSettler.levelSettler != null) {
                PopulationThought populationThough;
                SettlementBed Bed = ThisSettler.levelSettler.getBed();
                if (Bed != null) {
                    SettlementRoom Room = Bed.getRoom();
                    if (Room != null) {
                        int occupiedBeds = Room.getOccupiedBeds();
                        String sharingMode = (String)ControlsettlershapinessMod.settingsGetter.getSelection("room_sharing");
                        if ("doublebed_sharing_enabled".equals(sharingMode)) {
                            if (occupiedBeds == 2) {
                                happinessModifiersPatch.add(new HappinessModifier(0, (GameMessage)new GameMessageBuilder().append("settlement", "sharingroom").append(" (" + (occupiedBeds - 1) + ")")));
                            } else {
                                int penalty = Math.min(10 + (occupiedBeds - 1) * 10, 50);
                                happinessModifiersPatch.add(new HappinessModifier(-penalty, (GameMessage)new GameMessageBuilder().append("settlement", "sharingroom").append(" (" + (occupiedBeds - 1) + ")")));
                            }
                        } else if ("room_sharing_enabled".equals(sharingMode)) {
                            happinessModifiersPatch.add(new HappinessModifier(0, (GameMessage)new GameMessageBuilder().append("settlement, sharingroom").append(" (" + (occupiedBeds - 1) + ")")));
                        } else if ("room_sharing_disabled".equals(sharingMode)) {
                            happinessModifiersPatch.addAll(Bed.getHappinessModifiers());
                        }
                        if (Room.getRoomProperty("outsidefloor") > 0) {
                            if (!ControlsettlershapinessMod.settingsGetter.getBoolean("RoomMissingFloorModifierEnabled")) {
                                happinessModifiersPatch.add(new HappinessModifier(0, (GameMessage)new GameMessageBuilder().append("settlement", "outsidefloor")));
                            } else {
                                happinessModifiersPatch.add(new HappinessModifier(10, (GameMessage)new GameMessageBuilder().append("settlement", "outsidefloor")));
                            }
                        }
                        if (Room.getRoomProperty("lights") <= 0) {
                            if (!ControlsettlershapinessMod.settingsGetter.getBoolean("RoomMissingLightModifierEnabled")) {
                                happinessModifiersPatch.add(new HappinessModifier(0, (GameMessage)new GameMessageBuilder().append("settlement", "lights")));
                            } else {
                                happinessModifiersPatch.add(new HappinessModifier(-10, (GameMessage)new GameMessageBuilder().append("settlement", "lights")));
                            }
                        }
                        happinessModifiersPatch.add(Settler.getRoomSize((int)Room.getRoomSize()).getModifier());
                        happinessModifiersPatch.add(Settler.getRoomQuality((int)Room.getFurnitureScore()).getModifier());
                    } else if (ControlsettlershapinessMod.settingsGetter.getBoolean("BedOutsideModifierEnabled")) {
                        happinessModifiersPatch.add(HappinessModifier.bedOutsideModifier);
                    }
                }
                if ((populationThough = Settler.getPopulationThough((int)ThisSettler.levelSettler.data.countTotalSettlers())) != null) {
                    happinessModifiersPatch.add(populationThough.getModifier());
                }
            } else if (ControlsettlershapinessMod.settingsGetter.getBoolean("NoBedModifierEnabled")) {
                happinessModifiersPatch.add(HappinessModifier.noBedModifier);
            }
        }
        modifiersList = happinessModifiersPatch;
    }
}

